/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.action;

import com.macrofocus.application.high_d.action.ImageSelection;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class CopyAction
extends AbstractAction {
    private Component component;

    public CopyAction(String name, Component component) {
        super(name);
        this.component = component;
    }

    public CopyAction(final PropertiesModel propertiesModel) {
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    CopyAction.this.updateProperties(propertiesModel);
                }
            });
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.component != null) {
            Dimension size = this.component.getSize();
            BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 2);
            this.component.paint(bufferedImage.createGraphics());
            ImageSelection imageSelection = new ImageSelection(bufferedImage);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.getSystemClipboard().setContents(imageSelection, null);
        }
    }

    public void setComponent(Component component) {
        this.component = component;
        this.setEnabled(component != null);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Copy";
        if (propertiesModel != null && propertiesModel.isAvailable("action.copy.label")) {
            name = (String)propertiesModel.getValue("action.copy.label");
        }
        this.putValue("Name", name);
    }
}

