/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.action;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.high_d.model.HighDModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.action.AbstractMAction;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Serializer;

public class ExportSettingsAction
extends AbstractMAction {
    private final FileChooserFactory fileChooserFactory;
    private final Container contentPane;
    private final ApplicationModel applicationModel;
    private HighDModel model;

    public ExportSettingsAction(Container contentPane, FileChooserFactory fileChooserFactory, ApplicationModel applicationModel, ResourcesModel resourcesModel) {
        super("Export Settings", "action.exportsettings.label", true, resourcesModel);
        this.contentPane = contentPane;
        this.fileChooserFactory = fileChooserFactory;
        this.applicationModel = applicationModel;
        URL url = resourcesModel.getUrl("Export16.gif");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
        this.setModel(null);
    }

    public void actionPerformed(ActionEvent e) {
        int input;
        File file;
        FileFilter fileFilter = null;
        do {
            JFileChooser fileChooser;
            int value;
            if ((value = (fileChooser = this.fileChooserFactory.getFileChooser()).showSaveDialog(this.contentPane)) != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            fileFilter = fileChooser.getFileFilter();
        } while ((file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension())) == null || fileFilter == null);
        if (file.exists() && (input = JOptionPane.showConfirmDialog(this.contentPane, "File " + file.getName() + " already exist! Overwrite?", "File already exist", 0, 2)) == 1) {
            return;
        }
        Element root = new Element("High-D");
        root.addAttribute(new Attribute("version", this.applicationModel.getVersionModel().toString()));
        root.addAttribute(new Attribute("x", Integer.toString(this.contentPane.getX())));
        root.addAttribute(new Attribute("y", Integer.toString(this.contentPane.getY())));
        root.addAttribute(new Attribute("width", Integer.toString(this.contentPane.getWidth())));
        root.addAttribute(new Attribute("height", Integer.toString(this.contentPane.getHeight())));
        root.addAttribute(new Attribute("user", this.applicationModel.getLicenseModel().getUsername()));
        this.model.save(file, root);
        Document doc = new Document(root);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            Serializer serializer = new Serializer((OutputStream)bos, "UTF-8");
            serializer.setIndent(4);
            serializer.write(doc);
            bos.close();
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    public void setModel(HighDModel tmm) {
        this.model = tmm;
        this.setEnabled(tmm != null);
    }
}

