/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document.swing;

import com.jidesoft.status.ProgressStatusBarItem;
import com.jidesoft.status.ResizeStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.swing.JideBoxLayout;
import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.helper.ComponentCleaner;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.java2d.RenderingHintsModel;
import com.macrofocus.util.swing.icon.ColoredIcon;
import com.macrofocus.util.swing.logo.Java2DLogoView;
import de.javasoft.syntheticaaddons.SystemMonitor;
import de.javasoft.syntheticaaddons.systemmonitor.CollectorFactory;
import de.javasoft.syntheticaaddons.systemmonitor.SystemMonitorModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SwingHighDStatusBar<Row, Column>
extends StatusBar
implements CPStatusBar<JComponent> {
    private final Java2DLogoView logoView;
    private final ProgressStatusBarItem progress;
    private final JLabel pathPanel;
    private SystemMonitor monitor;
    private static SystemMonitorModel systemMonitorModel;
    private DataFrame<Row, Column, ?> dataFrame;
    private MutableSelection<Row> selection;
    private Filter<Row> filter;
    private MutableColoring<Color, Row> coloring;
    private Command resetFilters;
    private final SelectionListener selectionListener = selectionEvent -> this.updatePathPanel();
    private final FilterListener filterListener = filterEvent -> this.updatePathPanel();
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public SwingHighDStatusBar(Action aboutAction, ResourcesModel resourcesModel, RenderingHintsModel renderingHintsModel) {
        this.setOpaque(true);
        this.progress = new ProgressStatusBarItem(){

            public Dimension getPreferredSize() {
                return new Dimension(100, super.getPreferredSize().height);
            }
        };
        this.getProgress().setProgress(100);
        this.add((Component)this.progress, "flexible");
        JPanel colorButtons = new JPanel();
        colorButtons.setOpaque(false);
        JideBoxLayout layout = new JideBoxLayout((Container)colorButtons);
        colorButtons.setLayout((LayoutManager)layout);
        JButton greenButton = this.createColorButton(new Color(0, 30, 255));
        greenButton.putClientProperty("JButton.segmentPosition", "first");
        colorButtons.add((Component)greenButton, "flexible");
        colorButtons.add((Component)this.createColorButton(new Color(0, 188, 26)), "flexible");
        colorButtons.add((Component)this.createColorButton(new Color(205, 0, 232)), "flexible");
        colorButtons.add((Component)this.createColorButton(new Color(128, 177, 211)), "flexible");
        colorButtons.add((Component)this.createColorButton(new Color(50, 255, 0)), "flexible");
        colorButtons.add((Component)this.createColorButton(new Color(179, 222, 105)), "flexible");
        colorButtons.add((Component)this.createColorButton(new Color(228, 167, 242)), "flexible");
        JButton pinkButton = this.createColorButton(new Color(255, 159, 159));
        pinkButton.putClientProperty("JButton.segmentPosition", "last");
        colorButtons.add((Component)pinkButton, "flexible");
        JButton resetButton = new JButton((Icon)new ColoredIcon(Color.lightGray, Color.darkGray, 14, 14, 0, 0, 14, 14, 6));
        resetButton.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        resetButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingHighDStatusBar.this.selection.clearSelection();
                SwingHighDStatusBar.this.coloring.clearColoring();
            }
        }, (Object)resetButton));
        colorButtons.add((Component)resetButton, "flexible");
        resetButton.putClientProperty("JButton.segmentPosition", "last");
        this.add(colorButtons, "flexible");
        JButton resetFiltersButton = new JButton(new AbstractAction("Reset Filters"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingHighDStatusBar.this.resetFilters.execute();
            }
        });
        this.add(resetFiltersButton, "flexible");
        this.pathPanel = new JLabel();
        this.add(this.pathPanel, "vary");
        this.logoView = new Java2DLogoView(aboutAction, renderingHintsModel, resourcesModel != null ? resourcesModel.getPropertiesModel() : null);
        this.logoView.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.logoView.setPreferredSize(new Dimension(100, 100));
        this.add((Component)this.logoView, "flexible");
        try {
            JComponent gc = this.createSyntheticaSystemMonitor();
            this.add(gc, "flexible");
        }
        catch (ExceptionInInitializerError gc) {
            // empty catch block
        }
        ResizeStatusBarItem resize = new ResizeStatusBarItem();
        this.add((Component)resize, "flexible");
    }

    private JComponent createSyntheticaSystemMonitor() {
        SystemMonitorModel model = SwingHighDStatusBar.getSystemMonitorModel();
        this.monitor = new SyntheticaSystemMonitor(model);
        return this.monitor;
    }

    private static SystemMonitorModel getSystemMonitorModel() {
        if (systemMonitorModel == null) {
            systemMonitorModel = new SystemMonitorModel();
            int collectorDelay = 500;
            int collectorBufferSize = 400;
            systemMonitorModel.addCollector(CollectorFactory.CollectorID.HEAP_MEMORY_USAGE.id, collectorBufferSize, collectorDelay, CollectorFactory.getFactory().createCollector(CollectorFactory.CollectorID.HEAP_MEMORY_USAGE.id));
            systemMonitorModel.addCollector(CollectorFactory.CollectorID.CPU_USAGE.id, collectorBufferSize, collectorDelay, CollectorFactory.getFactory().createCollector(CollectorFactory.CollectorID.CPU_USAGE.id));
            systemMonitorModel.setColor(CollectorFactory.CollectorID.CPU_USAGE.id, new Color(240, 192, 192));
            systemMonitorModel.setColor(CollectorFactory.CollectorID.HEAP_MEMORY_USAGE.id, new Color(192, 192, 240));
        }
        return systemMonitorModel;
    }

    private JButton createColorButton(final Color color) {
        JButton button = new JButton((Icon)new ColoredIcon(color, Color.black, 14, 14));
        button.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingHighDStatusBar.this.colorize(color);
            }
        }, (Object)button));
        button.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        button.putClientProperty("Synthetica.background", color);
        button.putClientProperty("Synthetica.background.alpha", Float.valueOf(0.2f));
        button.putClientProperty("JButton.segmentPosition", "middle");
        return button;
    }

    private void colorize(Color color) {
        ArrayList<Object> toColor = new ArrayList<Object>();
        if (this.selection.isActive()) {
            for (Object row : this.selection) {
                toColor.add(row);
            }
            this.selection.clearSelection();
        } else {
            for (Object row : this.dataFrame.rows()) {
                if (this.filter.isFiltered(row)) continue;
                toColor.add(row);
            }
        }
        this.coloring.setColorElements(toColor, (CPColor)new SwingColor(color));
    }

    public JLabel getPathPanel() {
        return this.pathPanel;
    }

    public void setLogoVisible(boolean visible) {
        this.logoView.setVisible(visible);
    }

    public ProgressStatusBarItem getProgress() {
        return this.progress;
    }

    public void setModel(DataFrame<Row, Column, ?> dataFrame, MutableSelection<Row> selection, Filter<Row> filter, MutableColoring<Color, Row> coloring, Command resetFilters) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this.selectionListener);
        }
        if (this.filter != null) {
            this.filter.removeFilterListener(this.filterListener);
        }
        this.dataFrame = dataFrame;
        this.selection = selection;
        this.filter = filter;
        this.coloring = coloring;
        this.resetFilters = resetFilters;
        if (this.selection != null) {
            this.selection.addSelectionListener(this.selectionListener);
        }
        if (this.filter != null) {
            this.filter.addFilterListener(this.filterListener);
        }
        this.updatePathPanel();
    }

    private void updatePathPanel() {
        if (this.dataFrame != null) {
            int visibleCount;
            Object visible = this.filter.getFilteredCount() > 0 ? visibleCount + " " + ((visibleCount = this.dataFrame.getRowCount() - this.filter.getFilteredCount()) > 1 ? "are" : "is") : "all are";
            this.pathPanel.setText("Of " + this.dataFrame.getRowCount() + " items, " + (String)visible + " visible, and " + this.selection.getSelectedCount() + " " + (this.selection.getSelectedCount() > 1 ? "are" : "is") + " selected");
        } else {
            this.pathPanel.setText("");
        }
    }

    public JComponent getNativeComponent() {
        return this;
    }

    public void setStatus(MutableProperty<String> status) {
    }

    public void setStatusComponent(JComponent jComponent) {
    }

    public void dispose() {
        this.setModel(null, null, null, null, null);
        this.logoView.setAction(null);
        if (this.monitor != null) {
            this.monitor.stopRepaintThread();
            this.monitor.setModel(null);
            this.monitor = null;
        }
        ComponentCleaner.cleanComponent((Component)((Object)this));
    }

    private static class SyntheticaSystemMonitor
    extends SystemMonitor {
        public SyntheticaSystemMonitor(SystemMonitorModel model) {
            super(false);
            this.setOpaque(false);
            this.setBackground(UIManager.getColor("Panel.background"));
            this.setGridColor(new Color(127, 127, 127, 15));
            this.setGridSize(10);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setPreferredSize(new Dimension(40, 0));
            this.setModel(model);
            this.addCaption(CollectorFactory.CollectorID.CPU_USAGE.id, "CPU Usage:", "%{percentValue}.0f%%", true);
            this.addCaption(CollectorFactory.CollectorID.HEAP_MEMORY_USAGE.id, "Heap Usage:", "%{value},.2fMB / %{maxValue},.2fMB", true);
            this.setSpotlightEnabled(false);
            this.setPopupEnabled(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        System.gc();
                    }
                }
            });
        }

        public void updateUI() {
            super.updateUI();
            this.setBackground(UIManager.getColor("Panel.background"));
        }
    }
}

