/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.mahout;

import com.macrofocus.application.high_d.mahout.ClustersFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ClusterHelper {
    public static void writePointsToFile(List<Vector> points, Configuration conf, Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, path, LongWritable.class, VectorWritable.class);
        long recNum = 0L;
        VectorWritable vec = new VectorWritable();
        for (Vector point : points) {
            vec.set(point);
            writer.append((Writable)new LongWritable(recNum++), (Writable)vec);
        }
        writer.close();
    }

    public static List<List<Cluster>> readClusters(Configuration conf, Path output) throws IOException {
        ArrayList<List<Cluster>> Clusters = new ArrayList<List<Cluster>>();
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        for (FileStatus s : fs.listStatus(output, (PathFilter)new ClustersFilter())) {
            ArrayList<Cluster> clusters = new ArrayList<Cluster>();
            for (ClusterWritable value : new SequenceFileDirValueIterable(s.getPath(), PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
                Cluster cluster = value.getValue();
                clusters.add(cluster);
            }
            Clusters.add(clusters);
        }
        return Clusters;
    }
}

