/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.mahout;

import com.macrofocus.application.high_d.mahout.ClusterHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.clustering.kmeans.KMeansDriver;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;

public class Mahout {
    public static final double[][] points = new double[][]{{1.0, 1.0}, {2.0, 1.0}, {1.0, 2.0}, {2.0, 2.0}, {3.0, 3.0}, {8.0, 8.0}, {9.0, 8.0}, {8.0, 9.0}, {9.0, 9.0}};

    public static List<Vector> getPoints(double[][] raw) {
        ArrayList<Vector> points = new ArrayList<Vector>();
        for (int i = 0; i < raw.length; ++i) {
            double[] fr = raw[i];
            NamedVector vec = new NamedVector((Vector)new RandomAccessSparseVector(fr.length), Integer.toString(i));
            vec.assign(fr);
            points.add((Vector)vec);
        }
        return points;
    }

    public static void main(String[] args) throws Exception {
        Mahout.run(points, 2);
    }

    public static Map<Integer, List<Integer>> run(double[][] points, int k) throws Exception {
        List<Vector> vectors = Mahout.getPoints(points);
        File testData = new File("testdata");
        if (!testData.exists()) {
            testData.mkdir();
        }
        if (!(testData = new File("testdata/points")).exists()) {
            testData.mkdir();
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        ClusterHelper.writePointsToFile(vectors, conf, new Path("testdata/points/file1"));
        Path path = new Path("testdata/clusters/part-00000");
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, path, Text.class, Kluster.class);
        for (int i = 0; i < k; ++i) {
            Vector vec = vectors.get(i);
            Kluster cluster = new Kluster(vec, i, (DistanceMeasure)new EuclideanDistanceMeasure());
            writer.append((Writable)new Text(cluster.getIdentifier()), (Writable)cluster);
        }
        writer.close();
        Path output = new Path("output");
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        KMeansDriver.run((Configuration)conf, (Path)new Path("testdata/points"), (Path)new Path("testdata/clusters"), (Path)output, (DistanceMeasure)new EuclideanDistanceMeasure(), (double)0.001, (int)1000, (boolean)true, (double)0.0, (boolean)false);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, new Path("output/clusteredPoints/part-m-00000"), conf);
        HashMap<Integer, List<Integer>> list = new HashMap<Integer, List<Integer>>();
        IntWritable key = new IntWritable();
        WeightedVectorWritable value = new WeightedVectorWritable();
        while (reader.next((Writable)key, (Writable)value)) {
            System.out.println(value.toString() + " belongs to cluster " + key.toString());
            if (!list.containsKey(key.get())) {
                list.put(key.get(), new ArrayList());
            }
            ((List)list.get(key.get())).add(Integer.valueOf(((NamedVector)value.getVector()).getName()));
        }
        reader.close();
        return list;
    }
}

