/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.settings;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.grid.TableColumnChooser;
import com.macrofocus.application.high_d.document.AxesPanel;
import com.macrofocus.application.high_d.settings.SwingAxesTable;
import com.macrofocus.application.high_d.settings.SwingAxisPropertyPanel;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.order.MutableVisibleOrder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.OverlayLayout;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public class SwingAxesPanel<Row, Column>
extends JPanel
implements AxesPanel<JComponent> {
    private HighDFactory<?, ?, ?, ?, Row, Column, ?> factory;
    private JScrollPane tableScrollPane;
    private JButton reorderButton;
    private JPanel mainPanel;
    private JScrollPane propertiesScrollPane;
    private final SwingAxesTable<Row, Column> axisTable;
    private final SwingAxisPropertyPanel axisPropertyPanel;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public SwingAxesPanel() {
        this.$$$setupUI$$$();
        this.axisTable = new SwingAxesTable();
        this.tableScrollPane.setViewportView((Component)((Object)this.axisTable));
        AbstractButton tableColumnChooserButton = TableColumnChooser.getTableColumnChooserButton(this.axisTable);
        tableColumnChooserButton.setContentAreaFilled(false);
        this.tableScrollPane.setCorner("UPPER_RIGHT_CORNER", tableColumnChooserButton);
        this.axisPropertyPanel = new SwingAxisPropertyPanel();
        this.propertiesScrollPane.setViewportView(this.axisPropertyPanel.getMainPanel());
        this.reorderButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingAxesPanel.this.axisTable.getModel() != null) {
                    int i;
                    MutableVisibleOrder axisOrder = ((AxisGroupModel)SwingAxesPanel.this.factory.getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder();
                    ArrayList<AxisModel> ns = new ArrayList<AxisModel>();
                    int n = axisOrder.size();
                    double[][] s = new double[n][n];
                    int rows = SwingAxesPanel.this.factory.getDataFrame().getRowCount();
                    double[][] a = new double[rows][n];
                    for (int c = 0; c < n; ++c) {
                        AxisModel axisModel = (AxisModel)axisOrder.get(c);
                        for (int r = 0; r < rows; ++r) {
                            Number value = axisModel.getValue((Object)r);
                            a[r][c] = value != null ? (value.doubleValue() - axisModel.getMinimum()) / (axisModel.getMaximum() - axisModel.getMinimum()) : 0.5;
                        }
                    }
                    Array2DRowRealMatrix d = new Array2DRowRealMatrix(a);
                    SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)d);
                    RealMatrix contributions = svd.getCovariance(0.0);
                    for (i = 0; i < n; ++i) {
                        s[i][i] = Math.abs(contributions.getEntry(i, i));
                    }
                    for (i = 0; i < n; ++i) {
                        for (int j = 0; j < n; ++j) {
                            if (i == j) continue;
                            AxisModel axisModel1 = (AxisModel)axisOrder.get(i);
                            AxisModel axisModel2 = (AxisModel)axisOrder.get(j);
                            s[i][j] = Math.abs(SwingAxesPanel.this.correlation(axisModel1, axisModel2));
                        }
                    }
                    int l = -1;
                    double largest = -1.7976931348623157E308;
                    AxisModel first = null;
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (!(largest < s[i2][i2])) continue;
                        largest = s[i2][i2];
                        l = i2;
                        first = (AxisModel)axisOrder.get(i2);
                    }
                    ns.add(first);
                    while (ns.size() < n) {
                        largest = -1.7976931348623157E308;
                        int index = -1;
                        AxisModel next = null;
                        for (int i3 = 0; i3 < n; ++i3) {
                            AxisModel axisModel;
                            if (i3 == l || ns.contains(axisModel = (AxisModel)axisOrder.get(i3)) || !(largest < s[l][i3])) continue;
                            largest = s[l][i3];
                            index = i3;
                            next = axisModel;
                        }
                        l = index;
                        ns.add(next);
                    }
                    axisOrder.setOrder(ns);
                }
            }
        }, (Object)this.reorderButton));
        this.setLayout(new OverlayLayout(this));
        this.add(this.mainPanel);
    }

    private double correlation(AxisModel a1, AxisModel a2) {
        SimpleRegression regression = new SimpleRegression();
        int rowCount = Math.min(a1.getRowCount(), a2.getRowCount());
        for (int i = 0; i < rowCount; ++i) {
            Number v1 = a1.getValue((Object)i);
            Number v2 = a2.getValue((Object)i);
            if (v1 == null || v2 == null) continue;
            regression.addData(v1.doubleValue(), v2.doubleValue());
        }
        return regression.getR();
    }

    public void setModel(HighDFactory<?, ?, ?, ?, Row, Column, ?> factory) {
        this.factory = factory;
        this.reorderButton.setEnabled(factory != null);
        this.axisTable.setModel(factory);
        this.axisPropertyPanel.setModel(((AxisGroupModel)factory.getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder(), ((AxisGroupModel)factory.getFiltersAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder(), factory.getVisual().getFilter(), this.axisTable.getModel(), this.axisTable.getSelectionModel());
    }

    public CPComponent<JComponent> getMainComponent() {
        return SwingFactory.getInstance().createComponent((JComponent)this);
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        JSplitPane splitPane1 = new JSplitPane();
        splitPane1.setDividerLocation(300);
        splitPane1.setOrientation(0);
        this.mainPanel.add((Component)splitPane1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, new Dimension(0, -1), new Dimension(200, 200), null, 2, false));
        this.tableScrollPane = new JScrollPane();
        this.tableScrollPane.setVerticalScrollBarPolicy(22);
        splitPane1.setLeftComponent(this.tableScrollPane);
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesScrollPane.setHorizontalScrollBarPolicy(31);
        splitPane1.setRightComponent(this.propertiesScrollPane);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.reorderButton = new JButton();
        this.reorderButton.setText("Reorder");
        panel1.add((Component)this.reorderButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

