/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.swing;

import com.macrofocus.application.document.View;
import com.macrofocus.application.high_d.document.HighDView;
import com.macrofocus.application.high_d.document.JavaHighDDocument;
import com.macrofocus.application.high_d.document.swing.SwingHighDApplication;
import com.macrofocus.application.high_d.document.swing.SwingHighDView;
import com.macrofocus.application.high_d.swing.HighD;
import com.macrofocus.application.high_d.swing.ScreenShotsHelper;
import com.macrofocus.colormap.editor.ColorMapPanel;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.swing.SwingDockingPanel;
import com.macrofocus.util.swing.export.format.AbstractRasterExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DefaultContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.macrofocus.util.swing.export.format.PNGExportFormat;
import com.macrofocus.util.swing.export.format.TIFFExportFormat;
import com.macrofocus.util.swing.export.format.WebPExportFormat;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class ScreenShots {
    private final AbstractRasterExportFormat[] rasterExportFormats = new AbstractRasterExportFormat[]{new PNGExportFormat(), new TIFFExportFormat(), new WebPExportFormat()};
    private final ExportFormat[] vectorExportFormats = new ExportFormat[0];
    private final ExportFormat[] documentationExportFormats = new ExportFormat[]{new PNGExportFormat()};

    public ScreenShots() {
        try {
            String home = System.getProperty("user.home");
            File datasets = new File(home, "/macrofocus/dataset/high-d");
            File output = new File(home, "/build/high-d/screenshots");
            if (!output.exists()) {
                output.mkdirs();
            }
            System.setProperty("macrofocus.laf.useScreenMenuBar", "false");
            HighD app = new HighD(null, null);
            String lf = "synthetica-whitevision";
            SwingHighDApplication application = HighD.init("synthetica-whitevision");
            application.start((String)null);
            File documentation = new File(home, "/java/macrofocus/www/web/public/products/high-d/documentation");
            SwingHighDView view = (SwingHighDView)ScreenShotsHelper.open(new File(datasets, "Italian Olive Oils.mhd"), application);
            view.getDockingManager().getWestDockingBar().setActive((Dockable)view.getDockingManager().getWestDockingBar().getDockables().get(0), true);
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "ui/High-D"), (Component)application.getApplicationState().getWindow((View)view).getNativeWindow());
            ScreenShotsHelper.close(application, (HighDView)view);
            view = (SwingHighDView)ScreenShotsHelper.open(new File(datasets, "Cars.mhd"), application);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            SwingDockingPanel configurationPanel = view.getConfiguration().getMainPanel();
            view.getDockingManager().getWestDockingBar().setActive((Dockable)view.getDockingManager().getWestDockingBar().getDockables().get(0), true);
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "axes/axes"), view.getAxes());
            MutableColorMapping colorMapping = ((JavaHighDDocument)view.getDocument()).getVisual().getColorMapping();
            colorMapping.getColorSelection().setSelected(((JavaHighDDocument)view.getDocument()).getDataFrame().getColumnKey(2));
            view.getDockingManager().getWestDockingBar().setActive((Dockable)view.getDockingManager().getWestDockingBar().getDockables().get(1), true);
            view.getConfiguration().setAnimated(false);
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/configuration"), (Component)configurationPanel);
            view.getConfiguration().getColorExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            colorMapping.getColorSelection().setSelected(((JavaHighDDocument)view.getDocument()).getDataFrame().getColumnKey(8));
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/color-categorical"), view.getConfiguration().getColorGroupPanel());
            colorMapping.getColorSelection().setSelected(((JavaHighDDocument)view.getDocument()).getDataFrame().getColumnKey(2));
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/color-predefined"), view.getConfiguration().getColorGroupPanel());
            view.getConfiguration().getColorMapPanel().setType(ColorMapPanel.Type.Custom);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/color-custom"), view.getConfiguration().getColorGroupPanel());
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/legend"), view.getConfiguration().getLegend());
            view.getConfiguration().getRenderingExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/rendering"), view.getConfiguration().getRenderingGroupPanel());
            ScreenShotsHelper.close(application, (HighDView)view);
            view = (SwingHighDView)ScreenShotsHelper.open(new File(datasets, "BADAC Swiss Cities Ranking 2005.mhd"), application);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "cartoplot/cartoplotview"), (Component)view.getCartoPlotDockable().getComponent());
            ScreenShotsHelper.close(application, (HighDView)view);
            File dataset = new File(datasets, "Cars.mhd");
            HighDView view2 = ScreenShotsHelper.open(dataset, application);
            ScreenShotsHelper.takeScreenShot(output, "Cars", application, view2);
            ScreenShotsHelper.close(application, view2);
            view2 = ScreenShotsHelper.open(new File(datasets, "Chemical Elements.mhd"), application);
            ScreenShotsHelper.takeScreenShot(output, "Chemical Elements", application, view2);
            ScreenShotsHelper.close(application, view2);
            view2 = ScreenShotsHelper.open(new File(datasets, "Digital Cameras.mhd"), application);
            ScreenShotsHelper.takeScreenShot(output, "Digital Cameras", application, view2);
            ScreenShotsHelper.close(application, view2);
            view2 = ScreenShotsHelper.open(new File(datasets, "Italian Olive Oils.mhd"), application);
            ScreenShotsHelper.takeScreenShot(output, "Italian Olive Oils", application, view2);
            ScreenShotsHelper.close(application, view2);
            view2 = ScreenShotsHelper.open(new File(datasets, "TOP500 Supercomputing Sites - 200806.mhd"), application);
            ScreenShotsHelper.takeScreenShot(output, "TOP500 Supercomputing Sites - 200806", application, view2);
            ScreenShotsHelper.close(application, view2);
            view2 = ScreenShotsHelper.open(new File(datasets, "Tours de France.mhd"), application);
            ScreenShotsHelper.takeScreenShot(output, "Tours de France", application, view2);
            ScreenShotsHelper.close(application, view2);
            view2 = ScreenShotsHelper.open(new File(datasets, "USDA National Nutrient Database for Standard Reference, Rel. 24.mhd"), application);
            ScreenShotsHelper.takeScreenShot(output, "USDA National Nutrient Database for Standard Reference, Rel. 24", application, view2);
            ScreenShotsHelper.close(application, view2);
            view2 = ScreenShotsHelper.open(new File(datasets, "Vinho Verde Wine Quality.mhd"), application);
            ScreenShotsHelper.takeScreenShot(output, "Vinho Verde Wine Quality", application, view2);
            ScreenShotsHelper.close(application, view2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void open(File dataset, SwingHighDApplication app) {
        app.openData(dataset);
        app.waitUntilReady();
    }

    private void close(SwingHighDApplication app) {
        app.setFocusedModelDirty(false);
        app.closeData(app.getFocusedModel());
    }

    public static void main(String[] args) {
        new ScreenShots();
    }

    private void takeScreenShot(final File output, final String name, final SwingHighDApplication app) {
        app.waitUntilReady();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (AbstractRasterExportFormat abstractRasterExportFormat : ScreenShots.this.rasterExportFormats) {
                        ScreenShots.this.saveImage(abstractRasterExportFormat, app, name, output, Toolkit.getDefaultToolkit().getScreenResolution());
                        ScreenShots.this.saveImage(abstractRasterExportFormat, app, name, output, 300.0f);
                        ScreenShots.this.saveImage(abstractRasterExportFormat, app, name, output, 32.4f);
                    }
                    for (AbstractRasterExportFormat abstractRasterExportFormat : ScreenShots.this.vectorExportFormats) {
                        ScreenShots.this.saveImage((ExportFormat<Component>)abstractRasterExportFormat, app, name, output);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void saveImage(ExportFormat<Component> exportFormat, SwingHighDApplication app, String name, File output) {
        try {
            File destination = new File(output, "high-d");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            SwingHighDView focusedView = app.getFocusedView();
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)focusedView.getCurrentView()), new File(destination, name + "-high-d." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveImage(AbstractRasterExportFormat exportFormat, SwingHighDApplication app, String name, File output, float dpi) {
        File destination;
        exportFormat.setOutputDPI(dpi);
        String dpiString = Integer.toString((int)dpi);
        try {
            destination = new File(output, "application/" + dpiString + "dpi");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)app.getRootWindow()), new File(destination, name + "-" + dpiString + "dpi." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            destination = new File(output, "high-d/" + dpiString + "dpi");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            SwingHighDView focusedView = app.getFocusedView();
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)focusedView.getCurrentView()), new File(destination, name + "-high-d-" + dpiString + "dpi." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveForDocumentation(SwingHighDApplication app, File file, Component component) {
        app.waitUntilReady();
        for (ExportFormat exportFormat : this.documentationExportFormats) {
            try {
                exportFormat.save((ContentProvider)new DefaultContentProvider((Object)component), file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

