/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.view.statistics;

import com.jidesoft.grid.RolloverTableUtils;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.macrofocus.application.high_d.view.table.RowStripeNavigationSortableTable;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.dataframe.DataFrameTableModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.statistics.PresentationStatisticsDataFrame;
import com.macrofocus.high_d.statistics.StatisticsDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.visual.Visual;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class StatisticsTable<Row, C>
extends RowStripeNavigationSortableTable {
    private StatisticsDataFrame<Row, C> statisticsDataFrame;
    private Visual<Color, Row, C> visual;
    private final MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            StatisticsTable.this.updateProbing();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            StatisticsTable.this.setNavigationRolloverRow(-1);
            StatisticsTable.this.updateProbing();
        }
    };
    private final MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e) {
            StatisticsTable.this.updateProbing();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            StatisticsTable.this.updateProbing();
        }
    };

    public StatisticsTable() {
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setLoadSelectionOnTableDataChanged(true);
        RolloverTableUtils.install((JTable)((Object)this));
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StatisticsTable.this.updateProbing();
            }
        });
    }

    public void setModel(StatisticsDataFrame<Row, C> statisticsDataFrame, Visual<Color, Row, C> visual, AxisGroupModel axisGroupModel) {
        this.visual = visual;
        this.statisticsDataFrame = statisticsDataFrame;
        this.setModel((TableModel)new DataFrameTableModel((DataFrame)new PresentationStatisticsDataFrame((CPFactory)SwingFactory.getInstance(), statisticsDataFrame, axisGroupModel)));
        TableUtils.autoResizeColumn((JTable)((Object)this), (int)0);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    private void updateProbing() {
        int[] selected;
        int row = this.getNavigationRolloverRow();
        ArrayList<Object> rows = new ArrayList<Object>();
        for (int i : selected = this.getSelectedRows()) {
            if (row == i) continue;
            rows.add(this.statisticsDataFrame.getRowKey(i));
        }
        if (row >= 0) {
            int actualRow = TableModelWrapperUtils.getActualRowAt((TableModel)this.getModel(), (int)row);
            this.visual.getAnnotationProbing().setSelected(this.statisticsDataFrame.getRowKey(actualRow));
        } else {
            this.visual.getAnnotationProbing().clearSelection();
        }
        MutableSelection annotation = this.visual.getAnnotationSelection();
        ArrayList<Object> objects = rows;
        annotation.setSelectedIterable(objects);
    }
}

