/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.view.table;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.molap.dataframe.DataFrame;
import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class FilterableTableSelectionCoordinator<Row> {
    private boolean updating = false;

    public FilterableTableSelectionCoordinator(final DataFrame<Row, ?, ?> dataFrame, final SortableTable table, final ListSelectionModel listSelectionModel, final MutableSelection<Row> selection) {
        selection.addSelectionListener(new SelectionListener<Row>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void selectionChanged(SelectionEvent<Row> event) {
                if (!FilterableTableSelectionCoordinator.this.updating) {
                    FilterableTableSelectionCoordinator.this.updating = true;
                    try {
                        listSelectionModel.setValueIsAdjusting(true);
                        for (Object row : event.getAffected()) {
                            int visualRow = TableModelWrapperUtils.getRowAt((TableModel)table.getModel(), (int)dataFrame.getRowAddress(row));
                            if (selection.isSelected(row)) {
                                listSelectionModel.addSelectionInterval(visualRow, visualRow);
                                table.scrollRowToVisible(visualRow);
                                continue;
                            }
                            listSelectionModel.removeSelectionInterval(visualRow, visualRow);
                        }
                        listSelectionModel.setValueIsAdjusting(false);
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                    catch (Error ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        FilterableTableSelectionCoordinator.this.updating = false;
                    }
                }
            }
        });
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting() && !FilterableTableSelectionCoordinator.this.updating) {
                    FilterableTableSelectionCoordinator.this.updating = true;
                    try {
                        if (!listSelectionModel.isSelectionEmpty()) {
                            ArrayList<Object> selected = new ArrayList<Object>();
                            for (int visualRow = 0; visualRow < table.getModel().getRowCount(); ++visualRow) {
                                int actualRow = TableModelWrapperUtils.getActualRowAt((TableModel)table.getModel(), (int)visualRow);
                                if (!listSelectionModel.isSelectedIndex(visualRow)) continue;
                                Object row = dataFrame.getRowKey(actualRow);
                                selected.add(row);
                            }
                            selection.setSelectedIterable(selected);
                        } else {
                            selection.clearSelection();
                        }
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                    catch (Error ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        FilterableTableSelectionCoordinator.this.updating = false;
                    }
                }
            }
        });
    }
}

