/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.BinaryExpression;
import prefuse.data.expression.Expression;
import prefuse.util.TypeLib;

public class ArithmeticExpression
extends BinaryExpression {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int POW = 4;
    public static final int MOD = 5;
    private Class a = null;

    /*
     * WARNING - void declaration
     */
    public ArithmeticExpression(int operation, Expression left, Expression right) {
        super((int)var1_1, 0, 5, (Expression)var2_2, (Expression)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public Class getType(Schema s2) {
        if (this.a == null) {
            Class clazz;
            Class clazz2 = this.m_left.getType(s2);
            clazz = this.m_right.getType((Schema)((Object)clazz));
            this.a = TypeLib.getNumericType(clazz2, clazz);
        }
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object get(Tuple t2) {
        Class clazz = this.getType(t2.getSchema());
        if (Integer.TYPE == clazz || Byte.TYPE == clazz) {
            return ((AbstractExpression)this).getInt(t2);
        }
        if (Long.TYPE == clazz) {
            return (long)((AbstractExpression)this).getInt(t2);
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(((AbstractExpression)this).getFloat(t2));
        }
        if (Double.TYPE == clazz) {
            void var1_1;
            return ((AbstractExpression)this).getDouble((Tuple)var1_1);
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(Tuple t2) {
        void var1_1;
        int n2 = this.m_left.getInt(t2);
        int n3 = this.m_right.getInt((Tuple)var1_1);
        switch (this.m_op) {
            case 0: {
                return n2 + n3;
            }
            case 1: {
                return n2 - n3;
            }
            case 2: {
                return n2 * n3;
            }
            case 3: {
                return n2 / n3;
            }
            case 4: {
                return (int)Math.pow(n2, n3);
            }
            case 5: {
                return n2 % n3;
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(Tuple t2) {
        void var1_1;
        long l2 = this.m_left.getLong(t2);
        long l3 = this.m_right.getLong((Tuple)var1_1);
        switch (this.m_op) {
            case 0: {
                return l2 + l3;
            }
            case 1: {
                return l2 - l3;
            }
            case 2: {
                return l2 * l3;
            }
            case 3: {
                return l2 / l3;
            }
            case 4: {
                return (long)Math.pow(l2, l3);
            }
            case 5: {
                return l2 % l3;
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getFloat(Tuple t2) {
        void var1_1;
        float f2 = this.m_left.getFloat(t2);
        float f3 = this.m_right.getFloat((Tuple)var1_1);
        switch (this.m_op) {
            case 0: {
                return f2 + f3;
            }
            case 1: {
                return f2 - f3;
            }
            case 2: {
                return f2 * f3;
            }
            case 3: {
                return f2 / f3;
            }
            case 4: {
                return (float)Math.pow(f2, f3);
            }
            case 5: {
                return (float)ArithmeticExpression.IEEEremainder(f2, f3);
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDouble(Tuple t2) {
        void var1_1;
        double d2 = this.m_left.getDouble(t2);
        double d3 = this.m_right.getDouble((Tuple)var1_1);
        switch (this.m_op) {
            case 0: {
                return d2 + d3;
            }
            case 1: {
                return d2 - d3;
            }
            case 2: {
                return d2 * d3;
            }
            case 3: {
                return d2 / d3;
            }
            case 4: {
                return Math.pow(d2, d3);
            }
            case 5: {
                return ArithmeticExpression.IEEEremainder(d2, d3);
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    /*
     * WARNING - void declaration
     */
    public static double IEEEremainder(double f1, double f2) {
        void var2_1;
        double d2;
        double d3 = Math.round(f1 / f2);
        return d2 - d3 * var2_1;
    }

    public String toString() {
        char c2 = '?';
        switch (this.m_op) {
            case 0: {
                c2 = '+';
                break;
            }
            case 1: {
                c2 = '-';
                break;
            }
            case 2: {
                c2 = '*';
                break;
            }
            case 3: {
                c2 = '/';
                break;
            }
            case 4: {
                c2 = '^';
                break;
            }
            case 5: {
                c2 = '%';
            }
        }
        return "(" + this.m_left.toString() + " " + c2 + " " + this.m_right.toString() + ")";
    }
}

