/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.Utils;
import org.opendatafoundation.data.spss.SPSSDataRecord;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSNumericVariable;
import org.opendatafoundation.data.spss.SPSSRecordType1;
import org.opendatafoundation.data.spss.SPSSRecordType2;
import org.opendatafoundation.data.spss.SPSSRecordType3;
import org.opendatafoundation.data.spss.SPSSRecordType4;
import org.opendatafoundation.data.spss.SPSSRecordType6;
import org.opendatafoundation.data.spss.SPSSRecordType7;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype11;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype13;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype3;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype4;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype5;
import org.opendatafoundation.data.spss.SPSSStringVariable;
import org.opendatafoundation.data.spss.SPSSUtils;
import org.opendatafoundation.data.spss.SPSSVariable;
import org.opendatafoundation.data.spss.SPSSVariableCategory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPSSFile
extends RandomAccessFile {
    public static final int VERSION_MAJOR = 2008;
    public static final int VERSION_MINOR = 1;
    public static final String DDI2_NAMESPACE = "http://www.icpsr.umich.edu/DDI";
    public static final String DDI3_ARCHIVE_NAMESPACE = "ddi:archive:3_0";
    public static final String DDI3_INSTANCE_NAMESPACE = "ddi:instance:3_0";
    public static final String DDI3_LOGICAL_PRODUCT_NAMESPACE = "ddi:logicalproduct:3_0";
    public static final String DDI3_PHYSICAL_PRODUCT_NAMESPACE = "ddi:physicaldataproduct:3_0";
    public static final String DDI3_PHYSICAL_INSTANCE_NAMESPACE = "ddi:physicalinstance:3_0";
    public static final String DDI3_PROPRIETARY_RECORD_NAMESPACE = "ddi:physicaldataproduct/proprietary:3_0_Beta";
    public static final String DDI3_REUSABLE_NAMESPACE = "ddi:reusable:3_0";
    public static final String DDI3_STUDY_UNIT_NAMESPACE = "ddi:studyunit:3_0";
    public String categorySchemeIDSuffix = "CatSch";
    public String codeSchemeIDSuffix = "CodSch";
    public String dataRelationshipID = "DataRel";
    public String grossFileID = "GroFilStr";
    public String grossRecordStructureID = "GroRecStr";
    public String logicalRecordID = "LogRec";
    public String physicalRecordSegmentID = "PhysRecSeg1";
    public String logicalProductIDSuffix = "LogPrd";
    public String physicalDataProductIDSuffix = "PhyPrd";
    public String physicalStructureSchemeSuffix = "PhyStrSch";
    public String physicalStructureID = "PhyStr";
    public String recordLayoutSchemeSuffix = "RecLaySch";
    public String physicalInstanceIDSuffix = "PhyIns";
    public String physicalInstanceFileID = "DataFile";
    public String variableSchemeIDSuffix = "VarSch";
    public String variableCategoryPrefix = "Cat";
    public String variableIDPrefix = "V";
    public Boolean logFlag = true;
    public File logFile;
    Writer logWriter;
    private long start;
    private long elapsed;
    public File file;
    String uniqueID;
    boolean isBigEndian = false;
    byte[] cacheBuffer = new byte[4096];
    long cacheStart = -1L;
    long cachePointer = -1L;
    long cacheEnd = -1L;
    Charset charset = null;
    SPSSRecordType1 infoRecord;
    Map<Integer, SPSSVariable> variableMap;
    SPSSRecordType6 documentationRecord;
    SPSSRecordType7Subtype3 integerInformationRecord;
    SPSSRecordType7Subtype4 floatInformationRecord;
    SPSSRecordType7Subtype5 variableSetsInformationRecord;
    SPSSRecordType7Subtype11 variableDisplayParamsRecord;
    SPSSRecordType7Subtype13 longVariableNamesRecord;
    public boolean isMetadataLoaded = false;
    long dataStartPosition = -1L;
    public boolean isDataLoaded = false;

    public SPSSFile(File file) throws FileNotFoundException {
        super(file, "r");
        this.file = file;
    }

    public SPSSFile(File file, String string) throws FileNotFoundException {
        super(file, string);
        this.file = file;
    }

    public SPSSFile(String string) throws FileNotFoundException {
        super(string, "r");
        this.file = new File(string);
    }

    public SPSSFile(String string, String string2) throws FileNotFoundException {
        super(string, "r");
        this.file = new File(string);
    }

    public SPSSFile(File file, Charset charset) throws FileNotFoundException {
        super(file, "r");
        this.file = file;
        this.charset = charset;
    }

    public SPSSFile(File file, String string, Charset charset) throws FileNotFoundException {
        super(file, string);
        this.file = file;
        this.charset = charset;
    }

    public SPSSFile(String string, Charset charset) throws FileNotFoundException {
        super(string, "r");
        this.file = new File(string);
        this.charset = charset;
    }

    public SPSSFile(String string, String string2, Charset charset) throws FileNotFoundException {
        super(string, "r");
        this.file = new File(string);
        this.charset = charset;
    }

    public void dumpData() throws SPSSFileException, IOException {
        this.dumpData(0);
    }

    public void dumpData(int n) throws SPSSFileException, IOException {
        this.dumpData(n, new FileFormatInfo());
    }

    public void dumpData(int n, FileFormatInfo fileFormatInfo) throws SPSSFileException, IOException {
        if (n <= 0 || n > this.getRecordCount()) {
            n = this.getRecordCount();
        }
        this.log(this.getRecordFromDisk(fileFormatInfo, true));
        for (int i = 2; i <= n; ++i) {
            this.log(this.getRecordFromDisk(fileFormatInfo, false));
        }
    }

    public void dumpDDI2() throws SPSSFileException, TransformerException {
        this.log(Utils.DOM2String(this.getDDI2(new FileFormatInfo())));
    }

    public void dumpDDI3() throws SPSSFileException, TransformerException {
        this.log(Utils.DOM2String(this.getDDI3LogicalProduct()));
        this.log(Utils.DOM2String(this.getDDI3PhysicalDataProduct(new FileFormatInfo())));
        this.log(Utils.DOM2String(this.getDDI3PhysicalInstance(null, new FileFormatInfo())));
    }

    public void dumpMetadata() {
        this.log(this.infoRecord.toString());
        Iterator<Integer> iterator = this.variableMap.keySet().iterator();
        while (iterator.hasNext()) {
            SPSSVariable sPSSVariable = this.variableMap.get(iterator.next());
            this.log(sPSSVariable.variableRecord.toString());
        }
        if (this.documentationRecord != null) {
            this.log(this.documentationRecord.toString());
        }
        if (this.integerInformationRecord != null) {
            this.log(this.integerInformationRecord.toString());
        }
        if (this.floatInformationRecord != null) {
            this.log(this.floatInformationRecord.toString());
        }
        if (this.variableSetsInformationRecord != null) {
            this.log(this.variableSetsInformationRecord.toString());
        }
        if (this.variableDisplayParamsRecord != null) {
            this.log(this.variableDisplayParamsRecord.toString());
        }
        if (this.longVariableNamesRecord != null) {
            this.log(this.longVariableNamesRecord.toString());
        }
    }

    public long exportData(File file, FileFormatInfo fileFormatInfo) throws IOException, SPSSFileException {
        if (file == null) {
            throw new SPSSFileException("File should not be null.");
        }
        if (file.isDirectory()) {
            throw new SPSSFileException("File should not be a directory: " + file);
        }
        this.log("\nExporting data to " + file.getCanonicalPath());
        this.start = System.currentTimeMillis();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        if (this.infoRecord.numberOfCases > 0) {
            if (fileFormatInfo.format == FileFormatInfo.Format.ASCII && (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.DELIMITED || fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.CSV) && fileFormatInfo.namesOnFirstLine) {
                String string = "";
                Iterator<Integer> iterator = this.variableMap.keySet().iterator();
                int n = 1;
                while (iterator.hasNext()) {
                    SPSSVariable sPSSVariable = this.variableMap.get(iterator.next());
                    if (n > 1) {
                        string = fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.CSV ? string + "," : string + fileFormatInfo.asciiDelimiter;
                    }
                    string = string + sPSSVariable.getName();
                    ++n;
                }
                outputStreamWriter.write(string + "\n");
            }
            outputStreamWriter.write(this.getRecordFromDisk(fileFormatInfo, true) + "\n");
            for (int i = 2; i <= this.getRecordCount(); ++i) {
                outputStreamWriter.write(this.getRecordFromDisk(fileFormatInfo, false) + "\n");
            }
        } else {
            this.log("WARNING: files does not contain any data");
        }
        outputStreamWriter.close();
        this.elapsed = System.currentTimeMillis() - this.start;
        this.log("" + this.elapsed + " ms, file size  " + file.length() / 1024L + "Kb");
        return this.elapsed;
    }

    public boolean isCompressed() throws SPSSFileException {
        if (this.infoRecord != null) {
            return this.infoRecord.compressionSwitch != 0;
        }
        throw new SPSSFileException("SPSS file not initialized");
    }

    public Document getDDI2() throws SPSSFileException {
        return this.getDDI2(new FileFormatInfo());
    }

    public Document getDDI2(FileFormatInfo fileFormatInfo) throws SPSSFileException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = document.createElementNS(DDI2_NAMESPACE, "codeBook");
            element.setAttribute("version", "2.0");
            element.setAttribute("ID", this.getUniqueID());
            document.appendChild(element);
            Element element2 = (Element)element.appendChild(document.createElementNS(DDI2_NAMESPACE, "docDscr"));
            Element element3 = (Element)element2.appendChild(document.createElementNS(DDI2_NAMESPACE, "citation"));
            Element element4 = (Element)element3.appendChild(document.createElementNS(DDI2_NAMESPACE, "titlStmt"));
            Element element5 = (Element)element4.appendChild(document.createElementNS(DDI2_NAMESPACE, "titl"));
            element5.setTextContent("SPSS File " + this.file.getName());
            Element element6 = (Element)element3.appendChild(document.createElementNS(DDI2_NAMESPACE, "prodStmt"));
            element5 = (Element)element6.appendChild(document.createElementNS(DDI2_NAMESPACE, "prodDate"));
            String string = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            element5.setAttribute("date", string);
            element5.setTextContent(string);
            element5 = (Element)element6.appendChild(document.createElementNS(DDI2_NAMESPACE, "software"));
            element5.setAttribute("version", "2008.1");
            element5.setTextContent("UKDA/ODaF DExT Tools");
            Element element7 = (Element)element.appendChild(document.createElementNS(DDI2_NAMESPACE, "stdyDscr"));
            Element element8 = (Element)element7.appendChild(document.createElementNS(DDI2_NAMESPACE, "citation"));
            Element element9 = (Element)element8.appendChild(document.createElementNS(DDI2_NAMESPACE, "titlStmt"));
            element5 = (Element)element9.appendChild(document.createElementNS(DDI2_NAMESPACE, "titl"));
            element5.setTextContent("SPSS File " + this.file.getName());
            Element element10 = (Element)element8.appendChild(document.createElementNS(DDI2_NAMESPACE, "prodStmt"));
            element5 = (Element)element10.appendChild(document.createElementNS(DDI2_NAMESPACE, "prodDate"));
            element5 = (Element)element10.appendChild(document.createElementNS(DDI2_NAMESPACE, "software"));
            element5.setTextContent(this.infoRecord.productIdentification.substring(5));
            Element element11 = (Element)element.appendChild(document.createElementNS(DDI2_NAMESPACE, "fileDscr"));
            Element element12 = (Element)element11.appendChild(document.createElementNS(DDI2_NAMESPACE, "fileTxt"));
            element5 = (Element)element12.appendChild(document.createElementNS(DDI2_NAMESPACE, "fileName"));
            element5.setTextContent(this.file.getName());
            Element element13 = (Element)element12.appendChild(document.createElementNS(DDI2_NAMESPACE, "dimensns"));
            element5 = (Element)element13.appendChild(document.createElementNS(DDI2_NAMESPACE, "caseQnty"));
            element5.setTextContent("" + this.infoRecord.numberOfCases);
            element5 = (Element)element13.appendChild(document.createElementNS(DDI2_NAMESPACE, "varQnty"));
            element5.setTextContent("" + this.variableMap.size());
            element5 = (Element)element12.appendChild(document.createElementNS(DDI2_NAMESPACE, "fileType"));
            element5.setTextContent(this.infoRecord.productIdentification.substring(5));
            Element element14 = (Element)element.appendChild(document.createElementNS(DDI2_NAMESPACE, "dataDscr"));
            Iterator<Integer> iterator = this.variableMap.keySet().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                SPSSVariable sPSSVariable = this.variableMap.get(iterator.next());
                element14.appendChild(sPSSVariable.getDDI2(document, fileFormatInfo, n));
                n += sPSSVariable.getLength(fileFormatInfo);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SPSSFileException("Error creating DDI Document: " + parserConfigurationException.getMessage());
        }
        return document;
    }

    public String getDDI3DefaultLogicalProductID() {
        return this.getUniqueID() + "_" + this.logicalProductIDSuffix;
    }

    public String getDDI3DefaultPhysicalDataProductID(FileFormatInfo fileFormatInfo) {
        return this.getUniqueID() + "_" + this.physicalDataProductIDSuffix + "_" + fileFormatInfo.toString();
    }

    public String getDDI3DefaultPhysicalInstanceID(FileFormatInfo fileFormatInfo) {
        return this.getUniqueID() + "_" + this.physicalInstanceIDSuffix + "_" + fileFormatInfo.toString();
    }

    public String getDDI3DefaultPhysicalStructureSchemeID(FileFormatInfo fileFormatInfo) {
        return this.getUniqueID() + "_" + this.physicalStructureSchemeSuffix + "_" + fileFormatInfo.toString();
    }

    public String getDDI3DefaultRecordLayoutSchemeID(FileFormatInfo fileFormatInfo) {
        return this.getUniqueID() + "_" + this.recordLayoutSchemeSuffix + "_" + fileFormatInfo.toString();
    }

    public String getDDI3DefaultVariableSchemeID() {
        return this.getUniqueID() + "_" + this.variableSchemeIDSuffix;
    }

    public Document getDDI3LogicalProduct() throws SPSSFileException {
        return this.getDDI3LogicalProduct(null, null);
    }

    public Document getDDI3LogicalProduct(String string) throws SPSSFileException {
        return this.getDDI3LogicalProduct(string, null);
    }

    public Document getDDI3LogicalProduct(String string, String string2) throws SPSSFileException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Object object;
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = (Element)document.appendChild(document.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "LogicalProduct"));
            Utils.setDDIMaintainableId(element, this.getDDI3DefaultLogicalProductID());
            Element element2 = (Element)element.appendChild(document.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "DataRelationship"));
            Utils.setDDIIdentifiableId(element2, this.dataRelationshipID);
            Element element3 = (Element)element2.appendChild(document.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "LogicalRecord"));
            Utils.setDDIIdentifiableId(element3, this.logicalRecordID);
            element3.setAttribute("hasLocator", "false");
            Element element4 = (Element)element3.appendChild(document.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "VariablesInRecord"));
            element4.setAttribute("allVariablesInLogicalProduct", "true");
            Element element5 = (Element)element4.appendChild(document.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "VariableSchemeReference"));
            Element element6 = (Element)element5.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            element6.setTextContent(this.getDDI3DefaultVariableSchemeID());
            Iterator<Integer> iterator = this.variableMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = this.variableMap.get(iterator.next());
                if (!((SPSSVariable)object).hasValueLabels()) continue;
                element.appendChild(((SPSSVariable)object).getDDI3CategoryScheme(document));
            }
            iterator = this.variableMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = this.variableMap.get(iterator.next());
                if (!((SPSSVariable)object).hasValueLabels()) continue;
                element.appendChild(((SPSSVariable)object).getDDI3CodeScheme(document));
            }
            object = (Element)element.appendChild(document.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "VariableScheme"));
            Utils.setDDIMaintainableId((Element)object, this.getDDI3DefaultVariableSchemeID());
            iterator = this.variableMap.keySet().iterator();
            while (iterator.hasNext()) {
                SPSSVariable sPSSVariable = this.variableMap.get(iterator.next());
                object.appendChild(sPSSVariable.getDDI3Variable(document));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SPSSFileException("Error creating DDI Document: " + parserConfigurationException.getMessage());
        }
        return document;
    }

    public Document getDDI3PhysicalDataProduct(FileFormatInfo fileFormatInfo) throws SPSSFileException {
        return this.getDDI3PhysicalDataProduct(fileFormatInfo, null, null, null);
    }

    public Document getDDI3PhysicalDataProduct(FileFormatInfo fileFormatInfo, String string) throws SPSSFileException {
        return this.getDDI3PhysicalDataProduct(fileFormatInfo, string, null, null);
    }

    private Document getDDI3PhysicalDataProduct(FileFormatInfo fileFormatInfo, String string, String string2) throws SPSSFileException {
        return this.getDDI3PhysicalDataProduct(fileFormatInfo, string, string2, null);
    }

    private Document getDDI3PhysicalDataProduct(FileFormatInfo fileFormatInfo, String string, String string2, String string3) throws SPSSFileException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = (Element)document.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalDataProduct"));
            if (string2 == null) {
                string2 = this.getDDI3DefaultPhysicalDataProductID(fileFormatInfo);
            }
            Utils.setDDIMaintainableId(element, string2);
            Element element2 = (Element)element.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalStructureScheme"));
            Utils.setDDIMaintainableId(element2, this.getDDI3DefaultPhysicalStructureSchemeID(fileFormatInfo));
            Element element3 = (Element)element2.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalStructure"));
            Utils.setDDIVersionableId(element3, this.physicalStructureID);
            Element element4 = (Element)element3.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "LogicalProductReference"));
            Element element5 = (Element)element4.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            if (string == null) {
                string = this.getDDI3DefaultLogicalProductID();
            }
            element5.setTextContent(string);
            element5 = (Element)element3.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "Format"));
            element5.setTextContent(fileFormatInfo.toString());
            element5 = (Element)element3.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "DefaultDecimalSeparator"));
            element5.setTextContent(".");
            Element element6 = (Element)element3.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "GrossRecordStructure"));
            Utils.setDDIIdentifiableId(element6, this.grossRecordStructureID);
            element6.setAttribute("numberOfPhysicalSegments", "1");
            Element element7 = (Element)element6.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "LogicalRecordReference"));
            element5 = (Element)element7.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            element5.setTextContent(this.logicalRecordID);
            Element element8 = (Element)element6.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalRecordSegment"));
            Utils.setDDIIdentifiableId(element8, this.physicalRecordSegmentID);
            element8.setAttribute("segmentOrder", "1");
            element8.setAttribute("hasSegmentKey", "false");
            Element element9 = (Element)element.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "RecordLayoutScheme"));
            Utils.setDDIMaintainableId(element9, this.getDDI3DefaultRecordLayoutSchemeID(fileFormatInfo));
            Element element10 = fileFormatInfo.format == FileFormatInfo.Format.ASCII ? (Element)element9.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "RecordLayout")) : (Element)element9.appendChild(document.createElementNS(DDI3_PROPRIETARY_RECORD_NAMESPACE, "ProprietaryRecordLayout"));
            Utils.setDDIIdentifiableId(element10, fileFormatInfo.toString());
            Element element11 = (Element)element10.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalStructureReference"));
            element5 = (Element)element11.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "Scheme"));
            element5 = (Element)element5.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            element5.setTextContent(this.getDDI3DefaultPhysicalStructureSchemeID(fileFormatInfo));
            element5 = (Element)element11.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            element5.setTextContent(this.physicalStructureID);
            element5 = (Element)element11.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalRecordSegmentUsed"));
            element5.setTextContent(this.physicalRecordSegmentID);
            element5 = (Element)element10.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "CharacterSet"));
            element5.setTextContent("ASCII");
            element5 = (Element)element10.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "ArrayBase"));
            element5.setTextContent("1");
            if (fileFormatInfo.format == FileFormatInfo.Format.ASCII) {
                Element element12 = (Element)element10.appendChild(document.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "DefaultVariableSchemeReference"));
                element5 = (Element)element12.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
                element5.setTextContent(this.getDDI3DefaultVariableSchemeID());
                Iterator<Integer> iterator = this.variableMap.keySet().iterator();
                int n = 1;
                while (iterator.hasNext()) {
                    SPSSVariable sPSSVariable = this.variableMap.get(iterator.next());
                    element10.appendChild(sPSSVariable.getDDI3DataItem(document, fileFormatInfo, n));
                    if (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.FIXED) {
                        n += sPSSVariable.getLength(fileFormatInfo);
                        continue;
                    }
                    ++n;
                }
            } else {
                Object object;
                Element element13 = (Element)element10.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "Software"));
                element5 = (Element)element13.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "Name"));
                element5.setTextContent(fileFormatInfo.toString());
                if (this.integerInformationRecord != null) {
                    object = this.integerInformationRecord.releaseMajor + "." + this.integerInformationRecord.releaseMinor;
                    if (this.integerInformationRecord.releaseSpecial > 0) {
                        object = (String)object + "." + this.integerInformationRecord.releaseSpecial;
                    }
                    element5 = (Element)element13.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "Version"));
                    element5.setTextContent((String)object);
                }
                element5 = (Element)element13.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "Description"));
                element5.setTextContent(this.infoRecord.productIdentification);
                object = (Element)element10.appendChild(document.createElementNS(DDI3_PROPRIETARY_RECORD_NAMESPACE, "DefaultVariableSchemeReference"));
                element5 = (Element)object.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
                element5.setTextContent(this.getDDI3DefaultVariableSchemeID());
                Element element14 = (Element)element10.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryInfo"));
                element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                element5.setAttribute("name", "Compression");
                element5.setTextContent("" + this.infoRecord.compressionSwitch);
                element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                element5.setAttribute("name", "CompressionBias");
                element5.setTextContent("" + this.infoRecord.compressionBias);
                if (this.integerInformationRecord != null) {
                    element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    element5.setAttribute("name", "MachineCode");
                    element5.setTextContent("" + this.integerInformationRecord.machineCode);
                    element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    element5.setAttribute("name", "FloatingPointRepresentation");
                    element5.setTextContent("" + this.integerInformationRecord.floatRepresentation + " [" + this.integerInformationRecord.getFloatRepresentationLabel() + "]");
                    element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    element5.setAttribute("name", "Endianness");
                    element5.setTextContent("" + this.integerInformationRecord.endianness + " [" + this.integerInformationRecord.getEndiannessLabel() + "]");
                    element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    element5.setAttribute("name", "CharacterSet");
                    element5.setTextContent("" + this.integerInformationRecord.characterRepresentation + " [" + this.integerInformationRecord.getCharacterRepresentationLabel() + "]");
                }
                if (this.floatInformationRecord != null) {
                    element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    element5.setAttribute("name", "Sysmiss");
                    element5.setTextContent("" + this.floatInformationRecord.sysmiss);
                    element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    element5.setAttribute("name", "HighestSysmissRecode");
                    element5.setTextContent("" + this.floatInformationRecord.highest);
                    element5 = (Element)element14.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    element5.setAttribute("name", "LowsetSysmissRecode");
                    element5.setTextContent("" + this.floatInformationRecord.lowest);
                }
                Iterator<Integer> iterator = this.variableMap.keySet().iterator();
                while (iterator.hasNext()) {
                    SPSSVariable sPSSVariable = this.variableMap.get(iterator.next());
                    element10.appendChild(sPSSVariable.getDDI3ProprietaryDataItem(document));
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SPSSFileException("Error creating DDI Document: " + parserConfigurationException.getMessage());
        }
        return document;
    }

    public Document getDDI3PhysicalInstance(URI uRI, FileFormatInfo fileFormatInfo) throws SPSSFileException {
        return this.getDDI3PhysicalInstance(uRI, fileFormatInfo, null, null, null);
    }

    private Document getDDI3PhysicalInstance(URI uRI, FileFormatInfo fileFormatInfo, String string) throws SPSSFileException {
        return this.getDDI3PhysicalInstance(uRI, fileFormatInfo, string, null, null);
    }

    private Document getDDI3PhysicalInstance(URI uRI, FileFormatInfo fileFormatInfo, String string, String string2) throws SPSSFileException {
        return this.getDDI3PhysicalInstance(uRI, fileFormatInfo, string, string2, null);
    }

    private Document getDDI3PhysicalInstance(URI uRI, FileFormatInfo fileFormatInfo, String string, String string2, String string3) throws SPSSFileException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = (Element)document.appendChild(document.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "PhysicalInstance"));
            if (string2 == null) {
                string2 = this.getDDI3DefaultPhysicalInstanceID(fileFormatInfo);
            }
            Utils.setDDIMaintainableId(element, string2);
            Element element2 = (Element)element.appendChild(document.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "RecordLayoutReference"));
            if (string == null) {
                string = this.getDDI3DefaultRecordLayoutSchemeID(fileFormatInfo);
            }
            Element element3 = (Element)element2.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "Scheme"));
            element3 = (Element)element3.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            element3.setTextContent(string);
            element3 = (Element)element2.appendChild(document.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            element3.setTextContent(fileFormatInfo.toString());
            Element element4 = (Element)element.appendChild(document.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "DataFileIdentification"));
            Utils.setDDIIdentifiableId(element4, this.physicalInstanceFileID);
            if (fileFormatInfo.format == FileFormatInfo.Format.SPSS) {
                element4.setAttribute("isMaster", "true");
            }
            if (uRI != null) {
                element3 = (Element)element4.appendChild(document.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "URI"));
                if (uRI != null) {
                    element3.setTextContent(uRI.toString());
                }
            }
            Element element5 = (Element)element.appendChild(document.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "GrossFileStructure"));
            Utils.setDDIIdentifiableId(element5, this.grossFileID);
            element3 = (Element)element5.appendChild(document.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "CaseQuantity"));
            element3.setTextContent("" + this.getRecordCount());
            element3 = (Element)element5.appendChild(document.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "OverallRecordCount"));
            element3.setTextContent("" + this.getRecordCount());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SPSSFileException("Error creating DDI PhysicalInstance: " + parserConfigurationException.getMessage());
        }
        catch (DOMException dOMException) {
            throw new SPSSFileException("Error creating DDI PhysicalInstance: " + dOMException.getMessage());
        }
        return document;
    }

    public String getRecord(int n, FileFormatInfo fileFormatInfo) throws SPSSFileException {
        if (!this.isMetadataLoaded) {
            throw new SPSSFileException("Metadata has not been loaded");
        }
        if (!this.isDataLoaded) {
            throw new SPSSFileException("Data has not been loaded");
        }
        String string = "";
        if (n < 1 || n > this.getRecordCount()) {
            throw new SPSSFileException("Invalid record number [" + n + ". Range is 1 to " + this.getRecordCount() + "]");
        }
        Iterator<Integer> iterator = this.variableMap.keySet().iterator();
        int n2 = 1;
        while (iterator.hasNext()) {
            if (n2 > 1) {
                if (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.DELIMITED) {
                    string = string + fileFormatInfo.asciiDelimiter;
                } else if (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.CSV) {
                    string = string + ",";
                }
            }
            SPSSVariable sPSSVariable = this.variableMap.get(iterator.next());
            string = string + sPSSVariable.getValueAsString(n, fileFormatInfo);
            ++n2;
        }
        return string;
    }

    public String getRecordFromDisk(FileFormatInfo fileFormatInfo, boolean bl) throws SPSSFileException, IOException {
        if (!this.isMetadataLoaded) {
            this.loadMetadata();
        }
        String string = "";
        SPSSDataRecord sPSSDataRecord = new SPSSDataRecord();
        if (bl) {
            this.seek(this.dataStartPosition);
            SPSSDataRecord.clusterIndex = (byte)8;
        }
        sPSSDataRecord.read(this, true);
        Iterator<Integer> iterator = this.variableMap.keySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            if (n > 1) {
                if (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.DELIMITED) {
                    string = string + fileFormatInfo.asciiDelimiter;
                } else if (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.CSV) {
                    string = string + ",";
                }
            }
            SPSSVariable sPSSVariable = this.variableMap.get(iterator.next());
            string = string + sPSSVariable.getValueAsString(0, fileFormatInfo);
            ++n;
        }
        return string;
    }

    public int getRecordCount() {
        return this.infoRecord.numberOfCases;
    }

    public String getUniqueID() {
        if (this.uniqueID == null) {
            this.uniqueID = "ID_" + UUID.randomUUID().toString();
        }
        return this.uniqueID;
    }

    public SPSSVariable getVariable(int n) {
        if (n >= this.variableMap.size() || n < 0) {
            return null;
        }
        return (SPSSVariable)this.variableMap.values().toArray()[n];
    }

    public int getVariableCount() {
        return this.variableMap.size();
    }

    public void loadData() throws IOException, SPSSFileException {
        if (this.dataStartPosition < 1L) {
            throw new SPSSFileException("Error: data location pointer not initialized.");
        }
        SPSSDataRecord sPSSDataRecord = new SPSSDataRecord();
        this.seek(this.dataStartPosition);
        for (int i = 0; i < this.infoRecord.numberOfCases; ++i) {
            sPSSDataRecord.read(this);
        }
        this.isDataLoaded = true;
    }

    public void loadMetadata() throws FileNotFoundException, IOException, SPSSFileException {
        long l;
        Iterator<SPSSRecordType7Subtype11.VariableDisplayParams> iterator;
        int n;
        Object object;
        Object object2;
        int n2;
        if (this.isMetadataLoaded) {
            throw new SPSSFileException("Metadata is already loaded");
        }
        int n3 = 0;
        this.seek(0L);
        this.infoRecord = new SPSSRecordType1();
        this.infoRecord.read(this);
        this.log(this.infoRecord.toString());
        this.variableMap = new LinkedHashMap<Integer, SPSSVariable>();
        int n4 = 0;
        do {
            object2 = new SPSSRecordType2();
            ((SPSSRecordType2)object2).read(this);
            if (((SPSSRecordType2)object2).variableTypeCode >= 0) {
                int n5;
                this.log(((SPSSRecordType2)object2).toString());
                object = ((SPSSRecordType2)object2).variableTypeCode == 0 ? new SPSSNumericVariable(this) : new SPSSStringVariable(this);
                ((SPSSVariable)object).variableRecord = object2;
                ((SPSSVariable)object).variableShortName = ((SPSSRecordType2)object2).name;
                ((SPSSVariable)object).variableName = ((SPSSRecordType2)object2).name;
                this.variableMap.put(n4, (SPSSVariable)object);
                ((SPSSVariable)object).variableNumber = this.variableMap.size();
                if (((SPSSRecordType2)object2).missingValueFormatCode > 0) {
                    for (n5 = 0; n5 < ((SPSSRecordType2)object2).missingValueFormatCode; ++n5) {
                        SPSSVariableCategory sPSSVariableCategory = ((SPSSVariable)object).addCategory(((SPSSRecordType2)object2).missingValue[n5], "");
                        sPSSVariableCategory.isMissing = true;
                    }
                } else if (((SPSSRecordType2)object2).missingValueFormatCode <= -2) {
                    n5 = (int)SPSSUtils.byte8ToDouble(((SPSSRecordType2)object2).missingValue[0]);
                    int n6 = (int)SPSSUtils.byte8ToDouble(((SPSSRecordType2)object2).missingValue[1]);
                    for (n = n5; n <= n6; ++n) {
                        iterator = ((SPSSNumericVariable)object).addCategory(n, "");
                        ((SPSSVariableCategory)((Object)iterator)).isMissing = true;
                    }
                    if (((SPSSRecordType2)object2).missingValueFormatCode == -3) {
                        SPSSVariableCategory sPSSVariableCategory = ((SPSSVariable)object).addCategory(((SPSSRecordType2)object2).missingValue[2], "");
                        sPSSVariableCategory.isMissing = true;
                    }
                }
            }
            ++n4;
            l = this.getFilePointer();
            n2 = this.readSPSSInt();
            this.seek(l);
        } while (n2 == 2);
        if (this.infoRecord.OBSperObservation == -1) {
            this.infoRecord.OBSperObservation = n4;
        }
        this.log("\n# VARIABLES: " + this.variableMap.size());
        object2 = this.variableMap.keySet().iterator();
        while (object2.hasNext()) {
            object = this.variableMap.get(object2.next());
        }
        block17: do {
            l = this.getFilePointer();
            n2 = this.readSPSSInt();
            switch (n2) {
                case 3: {
                    Object object3;
                    this.seek(l);
                    object = new SPSSRecordType3();
                    ((SPSSRecordType3)object).read(this);
                    this.log(((SPSSRecordType3)object).toString());
                    SPSSRecordType4 sPSSRecordType4 = new SPSSRecordType4();
                    sPSSRecordType4.read(this);
                    this.log(sPSSRecordType4.toString());
                    for (int i = 0; i < sPSSRecordType4.numberOfVariables; ++i) {
                        SPSSVariable sPSSVariable = this.variableMap.get(sPSSRecordType4.variableIndex[i] - 1);
                        sPSSVariable.valueLabelRecord = object;
                        for (byte[] byArray : ((SPSSRecordType3)object).valueLabel.keySet()) {
                            object3 = sPSSVariable.addCategory(byArray, ((SPSSRecordType3)object).valueLabel.get(byArray));
                        }
                    }
                    continue block17;
                }
                case 6: {
                    this.seek(l);
                    SPSSRecordType6 sPSSRecordType6 = new SPSSRecordType6();
                    sPSSRecordType6.read(this);
                    this.log(sPSSRecordType6.toString());
                    break;
                }
                case 7: {
                    Object object3;
                    n = this.readSPSSInt();
                    this.seek(l);
                    switch (n) {
                        case 3: {
                            this.integerInformationRecord = new SPSSRecordType7Subtype3();
                            this.integerInformationRecord.read(this);
                            this.log(this.integerInformationRecord.toString());
                            break;
                        }
                        case 4: {
                            this.floatInformationRecord = new SPSSRecordType7Subtype4();
                            this.floatInformationRecord.read(this);
                            this.log(this.floatInformationRecord.toString());
                            break;
                        }
                        case 5: {
                            this.variableSetsInformationRecord = new SPSSRecordType7Subtype5();
                            this.variableSetsInformationRecord.read(this);
                            this.log(this.variableSetsInformationRecord.toString());
                            break;
                        }
                        case 11: {
                            this.variableDisplayParamsRecord = new SPSSRecordType7Subtype11();
                            this.variableDisplayParamsRecord.read(this);
                            this.log(this.variableDisplayParamsRecord.toString());
                            n3 = 0;
                            for (SPSSRecordType7Subtype11.VariableDisplayParams variableDisplayParams : this.variableDisplayParamsRecord.variableDisplayParams) {
                                this.getVariable((int)n3).measure = variableDisplayParams.measure;
                                this.getVariable((int)n3).displayWidth = variableDisplayParams.width;
                                this.getVariable((int)n3).alignment = variableDisplayParams.alignment;
                                ++n3;
                            }
                            continue block17;
                        }
                        case 13: {
                            this.longVariableNamesRecord = new SPSSRecordType7Subtype13();
                            this.longVariableNamesRecord.read(this);
                            this.log(this.longVariableNamesRecord.toString());
                            iterator = this.longVariableNamesRecord.nameMap.entrySet().iterator();
                            n3 = 0;
                            while (iterator.hasNext()) {
                                Map.Entry entry = (Map.Entry)((Object)iterator.next());
                                object3 = this.getVariable(n3);
                                if (((SPSSVariable)object3).variableShortName.equalsIgnoreCase((String)entry.getKey())) {
                                    ((SPSSVariable)object3).variableName = (String)entry.getValue();
                                }
                                ++n3;
                            }
                            continue block17;
                        }
                        default: {
                            SPSSRecordType7 sPSSRecordType7 = new SPSSRecordType7();
                            sPSSRecordType7.read(this);
                            this.log(sPSSRecordType7.toString());
                            break;
                        }
                    }
                    continue block17;
                }
                case 999: {
                    this.log("\nRECORD TYPE 999 - START OF DATA");
                    this.log("location " + this.getFilePointer());
                    if (this.readSPSSInt() != 0) {
                        throw new SPSSFileException("Error reading record type 999: Non-zero value found.");
                    }
                    this.dataStartPosition = this.getFilePointer();
                    break;
                }
                default: {
                    throw new SPSSFileException("Read error: invalid record type [" + n2 + "]");
                }
            }
        } while (n2 != 999);
        this.isMetadataLoaded = true;
    }

    public void log(String string) {
        if (this.logFlag.booleanValue()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            string = "" + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + " " + string;
            if (this.logFile == null) {
                System.out.println(string);
            } else {
                try {
                    if (this.logWriter == null) {
                        this.logWriter = new BufferedWriter(new FileWriter(this.logFile));
                    }
                    this.logWriter.write(string + "\n");
                    this.logWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public double readSPSSDouble() throws IOException {
        byte[] byArray = new byte[8];
        if (this.isBigEndian) {
            for (int i = 7; i >= 0; --i) {
                byArray[i] = this.readByte();
            }
        } else {
            this.read(byArray);
        }
        return SPSSUtils.byte8ToDouble(byArray);
    }

    public int readSPSSInt() throws IOException {
        byte[] byArray = new byte[4];
        if (this.isBigEndian) {
            for (int i = 3; i >= 0; --i) {
                byArray[i] = this.readByte();
            }
        } else {
            this.read(byArray);
        }
        return SPSSUtils.byte4ToInt(byArray);
    }

    public String readSPSSString(int n) throws IOException {
        String string = "";
        byte[] byArray = new byte[n];
        this.read(byArray);
        string = this.charset != null ? new String(byArray, this.charset) : new String(byArray);
        return string;
    }

    public void setUniqueID(String string) {
        this.uniqueID = string;
    }
}

