/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class UserPermissions {
    private static final UserPermissions INSTANCE = new UserPermissions();
    private PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private String[] roles;

    private UserPermissions() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(name, listener);
    }

    public static UserPermissions getInstance() {
        return INSTANCE;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public boolean isUserInRole(String role) {
        if (this.roles != null) {
            int iter = 0;
            while (iter < this.roles.length) {
                if (this.roles[iter].equals(role)) {
                    return true;
                }
                ++iter;
            }
        }
        return false;
    }

    public boolean isUserInARole(String[] roles) {
        int iter = 0;
        while (iter < roles.length) {
            if (this.isUserInRole(roles[iter])) {
                return true;
            }
            ++iter;
        }
        return false;
    }

    public boolean isUserInRoles(String[] roles) {
        int iter = 0;
        while (iter < roles.length) {
            if (!this.isUserInRole(roles[iter])) {
                return false;
            }
            ++iter;
        }
        return true;
    }

    void setRoles(String[] roles) {
        String[] oldValue = this.roles;
        this.roles = roles;
        this.propertyChange.firePropertyChange("roles", oldValue, roles);
    }
}

