/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import org.jdesktop.beans.JavaBean;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;

@JavaBean
public class ImagePainter
extends AbstractAreaPainter<Object> {
    private static final Logger LOG = Logger.getLogger(ImagePainter.class.getName());
    private transient BufferedImage img;
    private boolean horizontalRepeat;
    private boolean verticalRepeat;
    private boolean scaleToFit = false;
    private ScaleType scaleType = ScaleType.InsideFit;
    private double imageScale = 1.0;

    static {
        $SWITCH_TABLE$org$jdesktop$swingx$painter$AbstractLayoutPainter$VerticalAlignment = ImagePainter.$SWITCH_TABLE$org$jdesktop$swingx$painter$AbstractLayoutPainter$VerticalAlignment();
        $SWITCH_TABLE$org$jdesktop$swingx$painter$AbstractLayoutPainter$HorizontalAlignment = ImagePainter.$SWITCH_TABLE$org$jdesktop$swingx$painter$AbstractLayoutPainter$HorizontalAlignment();
        $SWITCH_TABLE$org$jdesktop$swingx$painter$AbstractAreaPainter$Style = ImagePainter.$SWITCH_TABLE$org$jdesktop$swingx$painter$AbstractAreaPainter$Style();
    }

    public ImagePainter() {
        this((BufferedImage)null);
    }

    public ImagePainter(BufferedImage image) {
        this(image, AbstractLayoutPainter.HorizontalAlignment.CENTER, AbstractLayoutPainter.VerticalAlignment.CENTER);
    }

    public ImagePainter(BufferedImage image, AbstractLayoutPainter.HorizontalAlignment horizontal, AbstractLayoutPainter.VerticalAlignment vertical) {
        this.setCacheable(true);
        this.img = image;
        this.setVerticalAlignment(vertical);
        this.setHorizontalAlignment(horizontal);
        this.setFillPaint(null);
        this.setBorderPaint(null);
        this.setDirty(false);
    }

    public void setImage(BufferedImage image) {
        if (image != this.img) {
            BufferedImage oldImage = this.img;
            this.img = image;
            this.setDirty(true);
            this.firePropertyChange("image", oldImage, this.img);
        }
    }

    public BufferedImage getImage() {
        return this.img;
    }

    @Override
    protected void doPaint(Graphics2D g, Object component, int width, int height) {
        Shape shape = this.provideShape(g, component, width, height);
        switch (this.getStyle()) {
            case BOTH: {
                this.drawBackground(g, shape, width, height);
                this.drawBorder(g, shape, width, height);
                break;
            }
            case FILLED: {
                this.drawBackground(g, shape, width, height);
                break;
            }
            case OUTLINE: {
                this.drawBorder(g, shape, width, height);
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    private void drawBackground(Graphics2D g, Shape shape, int width, int height) {
        Paint p = this.getFillPaint();
        if (p != null) {
            if (this.isPaintStretched()) {
                p = this.calculateSnappedPaint(p, width, height);
            }
            g.setPaint(p);
            g.fill(shape);
        }
        if (this.getAreaEffects() != null) {
            AreaEffect[] areaEffectArray = this.getAreaEffects();
            int n = areaEffectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AreaEffect ef = areaEffectArray[n2];
                ef.apply(g, shape, width, height);
                ++n2;
            }
        }
        if (this.img != null) {
            int imgWidth = this.img.getWidth(null);
            int imgHeight = this.img.getHeight(null);
            if (imgWidth != -1 && imgHeight != -1) {
                Rectangle rect = shape.getBounds();
                if (this.verticalRepeat || this.horizontalRepeat) {
                    Shape oldClip = g.getClip();
                    Shape clip = g.getClip();
                    if (clip == null) {
                        clip = new Rectangle(0, 0, width, height);
                    }
                    Area area = new Area(clip);
                    Insets insets = this.getInsets();
                    area.intersect(new Area(new Rectangle(insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom)));
                    if (this.verticalRepeat && this.horizontalRepeat) {
                        area.intersect(new Area(new Rectangle(0, 0, width, height)));
                        g.setClip(area);
                    } else if (this.verticalRepeat) {
                        area.intersect(new Area(new Rectangle(rect.x, 0, rect.width, height)));
                        g.setClip(area);
                    } else {
                        area.intersect(new Area(new Rectangle(0, rect.y, width, rect.height)));
                        g.setClip(area);
                    }
                    TexturePaint tp = new TexturePaint(this.img, rect);
                    g.setPaint(tp);
                    g.fillRect(0, 0, width, height);
                    g.setClip(oldClip);
                } else if (this.scaleToFit) {
                    float scale;
                    int sw = imgWidth;
                    int sh = imgHeight;
                    if (this.scaleType == ScaleType.InsideFit) {
                        if (sw > width) {
                            scale = (float)width / (float)sw;
                            sw = (int)((float)sw * scale);
                            sh = (int)((float)sh * scale);
                        }
                        if (sh > height) {
                            scale = (float)height / (float)sh;
                            sw = (int)((float)sw * scale);
                            sh = (int)((float)sh * scale);
                        }
                    }
                    if (this.scaleType == ScaleType.OutsideFit) {
                        if (sw > width) {
                            scale = (float)width / (float)sw;
                            sw = (int)((float)sw * scale);
                            sh = (int)((float)sh * scale);
                        }
                        if (sh < height) {
                            scale = (float)height / (float)sh;
                            sw = (int)((float)sw * scale);
                            sh = (int)((float)sh * scale);
                        }
                    }
                    if (this.scaleType == ScaleType.Distort) {
                        sw = width;
                        sh = height;
                    }
                    int x = 0;
                    int y = 0;
                    switch (this.getHorizontalAlignment()) {
                        case CENTER: {
                            x = width / 2 - sw / 2;
                            break;
                        }
                        case RIGHT: {
                            x = width - sw;
                            break;
                        }
                        case LEFT: {
                            break;
                        }
                    }
                    switch (this.getVerticalAlignment()) {
                        case CENTER: {
                            y = height / 2 - sh / 2;
                            break;
                        }
                        case BOTTOM: {
                            y = height - sh;
                            break;
                        }
                        case TOP: {
                            break;
                        }
                    }
                    g.drawImage(this.img, x, y, sw, sh, null);
                } else {
                    int sw = rect.width;
                    int sh = rect.height;
                    if (this.imageScale != 1.0) {
                        sw = (int)((double)sw * this.imageScale);
                        sh = (int)((double)sh * this.imageScale);
                    }
                    g.drawImage(this.img, rect.x, rect.y, sw, sh, null);
                }
            }
        }
    }

    private void drawBorder(Graphics2D g, Shape shape, int width, int height) {
        if (this.getBorderPaint() != null) {
            g.setPaint(this.getBorderPaint());
            g.setStroke(new BasicStroke(this.getBorderWidth()));
            g.draw(shape);
        }
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void setScaleToFit(boolean scaleToFit) {
        boolean old = this.isScaleToFit();
        this.scaleToFit = scaleToFit;
        this.setDirty(true);
        this.firePropertyChange("scaleToFit", old, this.isScaleToFit());
    }

    public ScaleType getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(ScaleType scaleType) {
        ScaleType old = this.getScaleType();
        this.scaleType = scaleType;
        this.setDirty(true);
        this.firePropertyChange("scaleType", (Object)old, (Object)this.getScaleType());
    }

    public double getImageScale() {
        return this.imageScale;
    }

    public void setImageScale(double imageScale) {
        double old = this.getImageScale();
        this.imageScale = imageScale;
        this.setDirty(true);
        this.firePropertyChange("imageScale", old, this.imageScale);
    }

    public boolean isHorizontalRepeat() {
        return this.horizontalRepeat;
    }

    public void setHorizontalRepeat(boolean horizontalRepeat) {
        boolean old = this.isHorizontalRepeat();
        this.horizontalRepeat = horizontalRepeat;
        this.setDirty(true);
        this.firePropertyChange("horizontalRepeat", old, this.horizontalRepeat);
    }

    public boolean isVerticalRepeat() {
        return this.verticalRepeat;
    }

    public void setVerticalRepeat(boolean verticalRepeat) {
        boolean old = this.isVerticalRepeat();
        this.verticalRepeat = verticalRepeat;
        this.setDirty(true);
        this.firePropertyChange("verticalRepeat", old, this.verticalRepeat);
    }

    @Override
    protected Shape provideShape(Graphics2D g, Object comp, int width, int height) {
        if (this.getImage() != null) {
            BufferedImage bi = this.getImage();
            int imgWidth = bi.getWidth();
            int imgHeight = bi.getHeight();
            return this.calculateLayout(imgWidth, imgHeight, width, height);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[img=" + this.img + "]";
    }

    public static enum ScaleType {
        InsideFit,
        OutsideFit,
        Distort;

    }
}

