/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.docking.AttachAnchor;
import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.DockingAnchor;
import com.macrofocus.docking.DockingBar;
import com.macrofocus.docking.DockingPanel;
import com.macrofocus.docking.splitter.ThreeComponentsSplitter;
import com.macrofocus.docking.swing.DockingContainer;
import com.macrofocus.docking.swing.SwingDockable;
import com.macrofocus.docking.swing.SwingDockingBar;
import com.macrofocus.docking.swing.SwingNakedDockable;
import com.macrofocus.docking.swing.splitter.SwingThreeComponentsSplitter;
import com.macrofocus.helper.ComponentCleaner;
import com.macrofocus.helper.Disposable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;

public class SwingDockingPanel
extends JPanel
implements Disposable,
DockingPanel<JComponent> {
    private JLayeredPane g;
    private ThreeComponentsSplitter<JComponent> primarySplitter;
    private ThreeComponentsSplitter<JComponent> secondarySplitter;
    private SwingDockingBar westDockingBar;
    private SwingDockingBar eastDockingBar;
    private SwingDockingBar southDockingBar;
    private SwingDockingBar northDockingBar;
    private JPanel mainPanel;
    private boolean vertical;
    DockingContainer westContainerPanel;
    DockingContainer eastContainerPanel;
    DockingContainer southContainerPanel;
    DockingContainer northContainerPanel;

    public SwingDockingPanel() {
        this(true);
    }

    public SwingDockingPanel(boolean vertical) {
        this.vertical = vertical;
        this.$$$setupUI$$$();
        this.updateLayout();
    }

    @Override
    public void updateUI() {
        DockingBar[] dockingBars;
        if (this.getInnerComponent() != null) {
            SwingUtilities.updateComponentTreeUI(this.getInnerComponent());
        }
        super.updateUI();
        for (DockingBar dockingBar : dockingBars = new DockingBar[]{this.westDockingBar, this.eastDockingBar, this.southDockingBar, this.northDockingBar}) {
            if (dockingBar == null || dockingBar.getDockables() == null) continue;
            for (Dockable dockable : dockingBar.getDockables()) {
                JComponent container;
                JComponent component = (JComponent)dockable.getComponent();
                if (component != null) {
                    SwingUtilities.updateComponentTreeUI(component);
                }
                if ((container = (JComponent)dockable.getContainer()) == null) continue;
                SwingUtilities.updateComponentTreeUI(container);
            }
        }
    }

    private void createUIComponents() {
        this.mainPanel = new JPanel();
        this.westContainerPanel = new DockingContainer();
        this.eastContainerPanel = new DockingContainer();
        this.southContainerPanel = new DockingContainer();
        this.northContainerPanel = new DockingContainer();
        this.westDockingBar = new SwingDockingBar(this.westContainerPanel, DockingAnchor.LEFT);
        this.eastDockingBar = new SwingDockingBar(this.eastContainerPanel, DockingAnchor.RIGHT);
        this.southDockingBar = new SwingDockingBar(this.southContainerPanel, DockingAnchor.BOTTOM);
        this.northDockingBar = new SwingDockingBar(this.northContainerPanel, DockingAnchor.TOP);
        this.g = new MyLayeredPane();
        this.setLayout(new OverlayLayout(this));
        this.add(this.mainPanel);
        this.validate();
    }

    public void setOrientation(boolean vertical) {
        if (!this.vertical != vertical) {
            this.vertical = vertical;
            this.primarySplitter = null;
            this.secondarySplitter = null;
            this.updateLayout();
        }
    }

    public void updateLayout() {
        JComponent innerComponent = null;
        Boolean secondaryRelativeSize = null;
        Boolean primaryRelativeSize = null;
        Double secondaryFirstSize = null;
        Double secondaryLastSize = null;
        Double primaryFirstSize = null;
        Double primaryLastSize = null;
        if (this.secondarySplitter != null) {
            secondaryFirstSize = this.secondarySplitter.getFirstSize();
            secondaryLastSize = this.secondarySplitter.getLastSize();
            innerComponent = (JComponent)this.secondarySplitter.getInnerComponent();
            secondaryRelativeSize = this.secondarySplitter.isRelativeResize();
        } else {
            this.secondarySplitter = new SwingThreeComponentsSplitter(!this.vertical);
        }
        if (this.primarySplitter != null) {
            primaryFirstSize = this.primarySplitter.getFirstSize();
            primaryLastSize = this.primarySplitter.getLastSize();
            primaryRelativeSize = this.primarySplitter.isRelativeResize();
        } else {
            this.primarySplitter = new SwingThreeComponentsSplitter(this.vertical);
            ((MyLayeredPane)this.g).setComponent((JComponent)this.primarySplitter.getNativeComponent());
        }
        if (primaryRelativeSize != null) {
            this.primarySplitter.setRelativeResize(primaryRelativeSize.booleanValue());
        }
        if (secondaryRelativeSize != null) {
            this.secondarySplitter.setRelativeResize(secondaryRelativeSize.booleanValue());
        }
        if (primaryFirstSize != null) {
            this.primarySplitter.setFirstSize(primaryFirstSize.doubleValue());
        }
        if (primaryLastSize != null) {
            this.primarySplitter.setLastSize(primaryLastSize.doubleValue());
        }
        if (secondaryFirstSize != null) {
            this.secondarySplitter.setFirstSize(secondaryFirstSize.doubleValue());
        }
        if (secondaryLastSize != null) {
            this.secondarySplitter.setLastSize(secondaryLastSize.doubleValue());
        }
        if (this.vertical) {
            this.secondarySplitter.setFirstComponent((Object)this.westContainerPanel);
            this.secondarySplitter.setInnerComponent((Object)innerComponent);
            this.secondarySplitter.setLastComponent((Object)this.eastContainerPanel);
            this.primarySplitter.setFirstComponent((Object)this.northContainerPanel);
            this.primarySplitter.setInnerComponent((Object)((JComponent)this.secondarySplitter.getNativeComponent()));
            this.primarySplitter.setLastComponent((Object)this.southContainerPanel);
        } else {
            this.secondarySplitter.setFirstComponent((Object)this.northContainerPanel);
            this.secondarySplitter.setInnerComponent((Object)innerComponent);
            this.secondarySplitter.setLastComponent((Object)this.southContainerPanel);
            this.primarySplitter.setFirstComponent((Object)this.westContainerPanel);
            this.primarySplitter.setInnerComponent((Object)((JComponent)this.secondarySplitter.getNativeComponent()));
            this.primarySplitter.setLastComponent((Object)this.eastContainerPanel);
        }
        this.secondarySplitter.setShowDividerControls(true);
        this.primarySplitter.setShowDividerControls(true);
    }

    public double getHorizontalFirstDividerSize() {
        return this.getHorizontalSplitter().getFirstSizeIfVisible();
    }

    public double getHorizontalLastDividerSize() {
        return this.getHorizontalSplitter().getLastSizeIfVisible();
    }

    public double getVerticalFirstDividerSize() {
        return this.getVerticalSplitter().getFirstSizeIfVisible();
    }

    public double getVerticalLastDividerSize() {
        return this.getVerticalSplitter().getLastSizeIfVisible();
    }

    public void setHorizontalFirstDividerSize(double size) {
        this.getHorizontalSplitter().setFirstSize((double)((int)size));
    }

    public void setHorizontalLastDividerSize(double size) {
        this.getHorizontalSplitter().setLastSize((double)((int)size));
    }

    public void setVerticalFirstDividerSize(double size) {
        this.getVerticalSplitter().setFirstSize((double)((int)size));
    }

    public void setVerticalLastDividerSize(double size) {
        this.getVerticalSplitter().setLastSize((double)((int)size));
    }

    public void setHorizontalRelativeSize(boolean relativeResize) {
        this.getHorizontalSplitter().setRelativeResize(relativeResize);
    }

    public void setVerticalRelativeResize(boolean relativeResize) {
        this.getVerticalSplitter().setRelativeResize(relativeResize);
    }

    private ThreeComponentsSplitter<JComponent> getHorizontalSplitter() {
        if (!this.vertical) {
            return this.primarySplitter;
        }
        return this.secondarySplitter;
    }

    private ThreeComponentsSplitter<JComponent> getVerticalSplitter() {
        if (this.vertical) {
            return this.primarySplitter;
        }
        return this.secondarySplitter;
    }

    public DockingBar<JComponent> getWestDockingBar() {
        return this.westDockingBar;
    }

    public DockingBar<JComponent> getNorthDockingBar() {
        return this.northDockingBar;
    }

    public DockingBar<JComponent> getSouthDockingBar() {
        return this.southDockingBar;
    }

    public DockingBar<JComponent> getEastDockingBar() {
        return this.eastDockingBar;
    }

    public JComponent getInnerComponent() {
        return this.secondarySplitter != null ? (JComponent)this.secondarySplitter.getInnerComponent() : null;
    }

    public void setInnerComponent(JComponent component) {
        this.secondarySplitter.setInnerComponent((Object)component);
    }

    public JComponent getNativeComponent() {
        return this;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.setMaximumSize(new Dimension(10000, 10000));
        this.mainPanel.setMinimumSize(new Dimension(-1, -1));
        this.mainPanel.setOpaque(false);
        this.mainPanel.setPreferredSize(new Dimension(-1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel1.setOpaque(false);
        this.mainPanel.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.westDockingBar.setOpaque(false);
        panel1.add((Component)this.westDockingBar, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, new Dimension(-1, 0), null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel2.setOpaque(false);
        this.mainPanel.add((Component)panel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, new Dimension(0, 0), new Dimension(0, 0), null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel3.setOpaque(false);
        this.mainPanel.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel4.setOpaque(false);
        this.mainPanel.add((Component)panel4, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel4.add((Component)this.eastDockingBar, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, new Dimension(-1, 0), null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel4.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel5.setOpaque(false);
        this.mainPanel.add((Component)panel5, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel6.setOpaque(false);
        this.mainPanel.add((Component)panel6, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, new Dimension(0, 0), new Dimension(0, 0), null, 0, false));
        JPanel panel7 = new JPanel();
        panel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel7.setOpaque(false);
        this.mainPanel.add((Component)panel7, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel7.add((Component)this.southDockingBar, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, new Dimension(0, -1), null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel7.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.g.setAlignmentX(0.5f);
        this.mainPanel.add((Component)this.g, new GridConstraints(1, 1, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        JPanel panel8 = new JPanel();
        panel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel8.setOpaque(true);
        this.mainPanel.add((Component)panel8, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel8.add((Component)this.northDockingBar, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, new Dimension(0, -1), null, null, 0, false));
        Spacer spacer4 = new Spacer();
        panel8.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    final JComponent getMyLayeredPane() {
        return this.g;
    }

    public void dispose() {
        if (this.westDockingBar != null) {
            for (Dockable<JComponent> dockable : this.westDockingBar.getDockables()) {
                ComponentCleaner.cleanComponent((Component)((Component)dockable.getComponent()));
                dockable.dispose();
            }
            this.westDockingBar.dispose();
            this.westDockingBar = null;
        }
        if (this.eastDockingBar != null) {
            for (Dockable<JComponent> dockable : this.eastDockingBar.getDockables()) {
                ComponentCleaner.cleanComponent((Component)((Component)dockable.getComponent()));
                dockable.dispose();
            }
            this.eastDockingBar.dispose();
            this.eastDockingBar = null;
        }
        if (this.southDockingBar != null) {
            for (Dockable<JComponent> dockable : this.southDockingBar.getDockables()) {
                ComponentCleaner.cleanComponent((Component)((Component)dockable.getComponent()));
                dockable.dispose();
            }
            this.southDockingBar.dispose();
            this.southDockingBar = null;
        }
        if (this.northDockingBar != null) {
            for (Dockable<JComponent> dockable : this.northDockingBar.getDockables()) {
                ComponentCleaner.cleanComponent((Component)((Component)dockable.getComponent()));
                dockable.dispose();
            }
            this.northDockingBar.dispose();
            this.northDockingBar = null;
        }
        this.g = null;
        this.primarySplitter = null;
        this.secondarySplitter = null;
        this.mainPanel = null;
    }

    public Dockable<JComponent> createNakedDockable(JComponent component, String title) {
        return this.createNakedDockable(component, title, (ImageIcon)null);
    }

    public Dockable<JComponent> createNakedDockable(JComponent component, String title, String iconUrl) {
        return new SwingNakedDockable(component, title, iconUrl);
    }

    public Dockable<JComponent> createDecoratedDockable(JComponent component, String title) {
        return this.createDecoratedDockable(component, title, null);
    }

    public Dockable<JComponent> createDecoratedDockable(JComponent component, String shortTitle, String title, String description) {
        return this.createDecoratedDockable(component, shortTitle, title, description, null);
    }

    public Dockable<JComponent> createNakedDockable(JComponent component, String title, ImageIcon icon) {
        return new SwingNakedDockable(component, title, icon);
    }

    public Dockable<JComponent> createDecoratedDockable(JComponent component, String title, ImageIcon icon) {
        return new SwingDockable(component, title, icon);
    }

    public Dockable<JComponent> createDecoratedDockable(JComponent component, String shortTitle, String title, String description, ImageIcon icon) {
        return new SwingDockable(component, shortTitle, title, description, icon);
    }

    public void attach(Dockable<JComponent> dockable, AttachAnchor anchor) {
        switch (anchor) {
            case TOP: {
                this.getNorthDockingBar().attach(dockable);
                break;
            }
            case BOTTOM: {
                this.getSouthDockingBar().attach(dockable);
                break;
            }
            case LEFT: {
                this.getWestDockingBar().attach(dockable);
                break;
            }
            case RIGHT: {
                this.getEastDockingBar().attach(dockable);
                break;
            }
            case CENTER: {
                this.setInnerComponent((JComponent)dockable.getComponent());
            }
        }
    }

    private final class MyLayeredPane
    extends JLayeredPane {
        JComponent jComponent;

        @Override
        protected final void processComponentEvent(ComponentEvent componentevent) {
            if (101 == componentevent.getID()) {
                int i1 = this.getWidth();
                int j1 = this.getHeight();
                if (i1 < 0 || j1 < 0) {
                    return;
                }
                Component[] acomponent = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
                for (int k1 = 0; k1 < acomponent.length; ++k1) {
                    Component component = acomponent[k1];
                    component.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
                this.validate();
                this.repaint();
            } else {
                super.processComponentEvent(componentevent);
            }
        }

        public MyLayeredPane() {
            this.setOpaque(false);
            this.enableEvents(1L);
        }

        public void setComponent(JComponent jComponent) {
            if (this.jComponent != null) {
                this.remove(this.jComponent);
            }
            this.add((Component)jComponent, JLayeredPane.DEFAULT_LAYER);
            jComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.jComponent = jComponent;
            this.validate();
        }
    }
}

