/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing.plaf.metal;

import com.macrofocus.docking.DockingAnchor;
import com.macrofocus.docking.swing.DockingButton;
import com.macrofocus.docking.swing.plaf.basic.BasicDockingButtonUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MetalDockingButtonUI
extends BasicDockingButtonUI {
    private static final MetalDockingButtonUI metalDockingButtonUI = new MetalDockingButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private boolean defaults_initialized = false;
    private static final Rectangle b = new Rectangle();
    private static final Rectangle c = new Rectangle();
    private static final Rectangle d = new Rectangle();
    private static Insets e = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent b) {
        return metalDockingButtonUI;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    @Override
    public Dimension getPreferredSize(JComponent jcomponent) {
        DockingButton stripebutton = (DockingButton)jcomponent;
        Dimension dimension = super.getPreferredSize(stripebutton);
        dimension.width = (int)(4.0f + (float)dimension.width * 1.1f);
        dimension.height += 4;
        DockingAnchor toolwindowanchor = stripebutton.getOrientation();
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            return new Dimension(dimension.height, dimension.width);
        }
        return dimension;
    }

    @Override
    public void paint(Graphics g, JComponent jcomponent) {
        Icon icon;
        DockingButton stripebutton = (DockingButton)jcomponent;
        String s = stripebutton.getText();
        Icon icon2 = icon = stripebutton.isEnabled() ? stripebutton.getIcon() : stripebutton.getDisabledIcon();
        if (icon == null && s == null) {
            return;
        }
        FontMetrics fontmetrics = stripebutton.getFontMetrics(stripebutton.getFont());
        e = jcomponent.getInsets(e);
        MetalDockingButtonUI.d.x = MetalDockingButtonUI.e.left;
        MetalDockingButtonUI.d.y = MetalDockingButtonUI.e.top;
        DockingAnchor toolwindowanchor = stripebutton.getOrientation();
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            MetalDockingButtonUI.d.height = jcomponent.getWidth() - (MetalDockingButtonUI.e.left + MetalDockingButtonUI.e.right);
            MetalDockingButtonUI.d.width = jcomponent.getHeight() - (MetalDockingButtonUI.e.top + MetalDockingButtonUI.e.bottom);
        } else {
            MetalDockingButtonUI.d.height = jcomponent.getHeight() - (MetalDockingButtonUI.e.left + MetalDockingButtonUI.e.right);
            MetalDockingButtonUI.d.width = jcomponent.getWidth() - (MetalDockingButtonUI.e.top + MetalDockingButtonUI.e.bottom);
        }
        MetalDockingButtonUI.b.height = 0;
        MetalDockingButtonUI.b.width = 0;
        MetalDockingButtonUI.b.y = 0;
        MetalDockingButtonUI.b.x = 0;
        MetalDockingButtonUI.c.height = 0;
        MetalDockingButtonUI.c.width = 0;
        MetalDockingButtonUI.c.y = 0;
        MetalDockingButtonUI.c.x = 0;
        String s1 = SwingUtilities.layoutCompoundLabel(jcomponent, fontmetrics, s, icon, stripebutton.getVerticalAlignment(), stripebutton.getHorizontalAlignment(), stripebutton.getVerticalTextPosition(), stripebutton.getHorizontalTextPosition(), d, b, c, stripebutton.getText() != null ? stripebutton.getIconTextGap() : 0);
        Graphics2D graphics2d = (Graphics2D)g;
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ButtonModel buttonmodel = stripebutton.getModel();
        Color color = stripebutton.getBackground();
        boolean forPrint = false;
        try {
            forPrint = jcomponent.isPaintingForPrint();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (buttonmodel.isArmed() && buttonmodel.isPressed() || buttonmodel.isSelected()) {
            Graphics2D graphics2d1 = (Graphics2D)g;
            int w = stripebutton.getWidth() - 6;
            int h = stripebutton.getHeight() - 6;
            Paint gradientpaint = !forPrint ? (DockingAnchor.TOP == toolwindowanchor || DockingAnchor.BOTTOM == toolwindowanchor ? new GradientPaint(0.0f, 0.0f, color.darker(), 0.0f, stripebutton.getHeight(), color.brighter()) : new GradientPaint(0.0f, 0.0f, color.darker(), stripebutton.getWidth(), 0.0f, color.brighter())) : color.darker();
            graphics2d1.setPaint(gradientpaint);
            graphics2d1.fillRoundRect(3, 3, w, h, 5, 5);
            g.setColor(Color.black);
            g.drawRoundRect(3, 3, stripebutton.getWidth() - 6, stripebutton.getHeight() - 6, 5, 5);
        } else {
            g.setColor(color);
            g.fillRoundRect(3, 3, stripebutton.getWidth() - 6, stripebutton.getHeight() - 6, 5, 5);
            g.setColor(Color.GRAY);
            g.drawRoundRect(3, 3, stripebutton.getWidth() - 6, stripebutton.getHeight() - 6, 5, 5);
        }
        if (buttonmodel.isRollover()) {
            if (!(buttonmodel.isArmed() || buttonmodel.isPressed() || buttonmodel.isSelected())) {
                Graphics2D graphics2d2 = (Graphics2D)g;
                Paint gradientpaint1 = !forPrint ? (DockingAnchor.TOP == toolwindowanchor || DockingAnchor.BOTTOM == toolwindowanchor ? new GradientPaint(0.0f, 0.0f, color, 0.0f, stripebutton.getHeight(), Color.white) : new GradientPaint(0.0f, 0.0f, color, stripebutton.getWidth(), 0.0f, Color.white)) : color.darker();
                graphics2d2.setPaint(gradientpaint1);
                graphics2d2.fillRoundRect(3, 3, stripebutton.getWidth() - 6, stripebutton.getHeight() - 6, 5, 5);
            }
            g.setColor(Color.darkGray);
            g.drawRoundRect(3, 3, stripebutton.getWidth() - 6, stripebutton.getHeight() - 6, 5, 5);
        }
        AffineTransform affinetransform = null;
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            affinetransform = graphics2d.getTransform();
            if (DockingAnchor.RIGHT == toolwindowanchor) {
                if (icon != null) {
                    icon.paintIcon(jcomponent, graphics2d, MetalDockingButtonUI.b.y, MetalDockingButtonUI.b.x);
                }
                graphics2d.rotate(1.5707963267948966);
                graphics2d.translate(0, -jcomponent.getWidth());
            } else {
                if (icon != null) {
                    icon.paintIcon(jcomponent, graphics2d, MetalDockingButtonUI.b.y, jcomponent.getHeight() - MetalDockingButtonUI.b.x - icon.getIconHeight());
                }
                graphics2d.rotate(-1.5707963267948966);
                graphics2d.translate(-jcomponent.getHeight(), 0);
            }
        } else if (icon != null) {
            icon.paintIcon(jcomponent, graphics2d, MetalDockingButtonUI.b.x, MetalDockingButtonUI.b.y);
        }
        if (s != null) {
            if (buttonmodel.isEnabled()) {
                if (buttonmodel.isArmed() && buttonmodel.isPressed() || buttonmodel.isSelected()) {
                    g.setColor(color);
                } else {
                    g.setColor(stripebutton.getForeground());
                }
            } else {
                g.setColor(color.darker());
            }
            if (buttonmodel.isEnabled()) {
                g.setColor(stripebutton.getForeground());
                BasicGraphicsUtils.drawString(g, s1, stripebutton.getMnemonic2(), MetalDockingButtonUI.c.x, MetalDockingButtonUI.c.y + fontmetrics.getAscent());
            } else {
                if (buttonmodel.isSelected()) {
                    g.setColor(jcomponent.getBackground());
                } else {
                    g.setColor(this.getDisabledTextColor());
                }
                BasicGraphicsUtils.drawString(g, s1, stripebutton.getMnemonic2(), MetalDockingButtonUI.c.x, MetalDockingButtonUI.c.y + fontmetrics.getAscent());
            }
        }
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            graphics2d.setTransform(affinetransform);
        }
    }
}

