/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing.plaf.synth;

import com.macrofocus.docking.DockingAnchor;
import com.macrofocus.docking.swing.DockingButton;
import com.macrofocus.docking.swing.plaf.basic.BasicDockingButtonUI;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class SynthDockingButtonUI
extends BasicDockingButtonUI {
    private static final SynthDockingButtonUI synthDockingButtonUI = new SynthDockingButtonUI();
    private static final Rectangle r1 = new Rectangle();
    private static final Rectangle r2 = new Rectangle();
    private static final Rectangle r3 = new Rectangle();
    private static Insets inset = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent b) {
        return synthDockingButtonUI;
    }

    @Override
    public Dimension getPreferredSize(JComponent jcomponent) {
        DockingButton stripebutton = (DockingButton)jcomponent;
        Dimension dimension = super.getPreferredSize(stripebutton);
        DockingAnchor toolwindowanchor = stripebutton.getOrientation();
        dimension.width = DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor ? (int)(4.0f + (float)dimension.width * 1.0f) : (int)(4.0f + (float)dimension.width * 1.0f);
        dimension.height += 4;
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            return new Dimension(dimension.height, dimension.width);
        }
        return dimension;
    }

    @Override
    public void paint(Graphics g, JComponent view) {
        Icon icon;
        int height;
        int width;
        int angle;
        int side;
        Dimension d = view.getSize();
        DockingButton button = (DockingButton)view;
        DockingAnchor toolwindowanchor = button.getOrientation();
        ButtonModel buttonmodel = button.getModel();
        SyntheticaState localSyntheticaState = new SyntheticaState();
        if (buttonmodel.isPressed()) {
            localSyntheticaState.setState(SyntheticaState.State.PRESSED);
        }
        if (buttonmodel.isSelected()) {
            localSyntheticaState.setState(SyntheticaState.State.SELECTED);
        }
        if (buttonmodel.isArmed()) {
            localSyntheticaState.setState(SyntheticaState.State.ACTIVE);
        }
        if (!buttonmodel.isEnabled()) {
            localSyntheticaState.setState(SyntheticaState.State.DISABLED);
        }
        if (buttonmodel.isRollover()) {
            localSyntheticaState.setState(SyntheticaState.State.HOVER);
        }
        if (toolwindowanchor == DockingAnchor.LEFT) {
            side = 2;
            angle = -90;
            width = d.height;
            height = d.width;
        } else if (toolwindowanchor == DockingAnchor.RIGHT) {
            side = 4;
            angle = 90;
            width = d.height;
            height = d.width;
        } else if (toolwindowanchor == DockingAnchor.TOP) {
            side = 1;
            angle = 0;
            width = d.width;
            height = d.height;
        } else if (toolwindowanchor == DockingAnchor.BOTTOM) {
            side = 3;
            angle = 0;
            width = d.width;
            height = d.height;
        } else {
            side = 0;
            angle = 0;
            width = d.width;
            height = d.height;
        }
        this.paintTabbedPaneTab(view, localSyntheticaState, 0, side, 0, angle, g, 0, 0, width, height);
        String s = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && s == null) {
            return;
        }
        Font font = button.getFont();
        if (buttonmodel.isSelected()) {
            font = font.deriveFont(1);
        }
        g.setFont(font);
        FontMetrics fontmetrics = button.getFontMetrics(font);
        inset = view.getInsets(inset);
        SynthDockingButtonUI.r3.x = SynthDockingButtonUI.inset.left;
        SynthDockingButtonUI.r3.y = SynthDockingButtonUI.inset.top;
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            SynthDockingButtonUI.r3.height = view.getWidth() - (SynthDockingButtonUI.inset.left + SynthDockingButtonUI.inset.right);
            SynthDockingButtonUI.r3.width = view.getHeight() - (SynthDockingButtonUI.inset.top + SynthDockingButtonUI.inset.bottom);
        } else {
            SynthDockingButtonUI.r3.height = view.getHeight() - (SynthDockingButtonUI.inset.left + SynthDockingButtonUI.inset.right);
            SynthDockingButtonUI.r3.width = view.getWidth() - (SynthDockingButtonUI.inset.top + SynthDockingButtonUI.inset.bottom);
        }
        SynthDockingButtonUI.r1.height = 0;
        SynthDockingButtonUI.r1.width = 0;
        SynthDockingButtonUI.r1.y = 0;
        SynthDockingButtonUI.r1.x = 0;
        SynthDockingButtonUI.r2.height = 0;
        SynthDockingButtonUI.r2.width = 0;
        SynthDockingButtonUI.r2.y = 0;
        SynthDockingButtonUI.r2.x = 0;
        String s1 = SwingUtilities.layoutCompoundLabel(view, fontmetrics, s, icon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), r3, r1, r2, button.getText() != null ? button.getIconTextGap() : 0);
        Graphics2D graphics2d = (Graphics2D)g;
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Color color = button.getBackground();
        AffineTransform affinetransform = null;
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            affinetransform = graphics2d.getTransform();
            if (DockingAnchor.RIGHT == toolwindowanchor) {
                if (icon != null) {
                    icon.paintIcon(view, graphics2d, SynthDockingButtonUI.r1.y, SynthDockingButtonUI.r1.x);
                }
                graphics2d.rotate(1.5707963267948966);
                graphics2d.translate(-2, -view.getWidth());
            } else {
                if (icon != null) {
                    icon.paintIcon(view, graphics2d, SynthDockingButtonUI.r1.y, view.getHeight() - SynthDockingButtonUI.r1.x - icon.getIconHeight());
                }
                graphics2d.rotate(-1.5707963267948966);
                graphics2d.translate(-view.getHeight() - 2, 0);
            }
        } else if (icon != null) {
            icon.paintIcon(view, graphics2d, SynthDockingButtonUI.r1.x, SynthDockingButtonUI.r1.y);
        }
        if (s != null) {
            if (buttonmodel.isEnabled()) {
                if (buttonmodel.isArmed() && buttonmodel.isPressed() || buttonmodel.isSelected()) {
                    g.setColor(color);
                } else {
                    g.setColor(button.getForeground());
                }
            } else {
                g.setColor(color.darker());
            }
            if (buttonmodel.isEnabled()) {
                g.setColor(button.getForeground());
                BasicGraphicsUtils.drawString(g, s1, button.getMnemonic2(), SynthDockingButtonUI.r2.x, SynthDockingButtonUI.r2.y + fontmetrics.getAscent());
            } else if (buttonmodel.isSelected()) {
                g.setColor(view.getBackground());
            } else {
                BasicGraphicsUtils.drawString(g, s1, button.getMnemonic2(), SynthDockingButtonUI.r2.x, SynthDockingButtonUI.r2.y + fontmetrics.getAscent());
            }
        }
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            graphics2d.setTransform(affinetransform);
        }
    }

    public void paintTabbedPaneTab(JComponent c, SyntheticaState state, int tabIndex, int side, int paramInt3, int angle, Graphics g, int x, int y, int width, int height) {
        TabbedPanePainter.getInstance().paintTabbedPaneTab(c, state, tabIndex, side, paramInt3, angle, g, x, y, width, height);
    }
}

