/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.Aggregation;
import com.treemap.D;
import com.treemap.N;
import com.treemap.P;
import com.treemap.R;
import com.treemap.c;
import com.treemap.i;
import com.treemap.x;
import com.treemap.z;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AggregationFactory {
    public static final Aggregation NONE_AGGREGATION = new D();
    public static final Aggregation SUM_AGGREGATION = new R();
    public static final Aggregation SIZE_WEIGHTED_AGGREGATION = new N();
    public static final Aggregation AVERAGE_AGGREGATION = new c();
    public static final Aggregation COUNT_AGGREGATION = new i();
    public static final Aggregation MIN_AGGREGATION = new z();
    public static final Aggregation MAX_AGGREGATION = new x();
    public static final Aggregation STD_DEV_AGGREGATION = new P();
    private final List<Aggregation> a = new ArrayList<Aggregation>();
    private static final AggregationFactory b = new AggregationFactory(NONE_AGGREGATION, SUM_AGGREGATION, SIZE_WEIGHTED_AGGREGATION, AVERAGE_AGGREGATION, COUNT_AGGREGATION, MIN_AGGREGATION, MAX_AGGREGATION, STD_DEV_AGGREGATION);

    public AggregationFactory(Aggregation ... entries) {
        this.a.addAll(Arrays.asList(entries));
    }

    public static AggregationFactory getInstance() {
        return b;
    }

    public void add(Aggregation entry) {
        this.a.add(entry);
    }

    public Aggregation getDefault() {
        return SUM_AGGREGATION;
    }

    public List<Aggregation> getAggregations() {
        return this.a;
    }

    public Aggregation get(String name) {
        for (Aggregation aggregation : this.a) {
            if (!aggregation.toString().equals(name)) continue;
            return aggregation;
        }
        return this.getDefault();
    }

    public Aggregation find(String name) {
        for (Aggregation aggregation : this.a) {
            if (!aggregation.toString().equals(name)) continue;
            return aggregation;
        }
        return null;
    }
}

