/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.combobox.ColorExComboBox;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.ColorCellEditor;
import com.jidesoft.grid.ColorCellRenderer;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.SortableTable;
import com.macrofocus.colormap.ColorMapEvent;
import com.macrofocus.colormap.ColorMapListener;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.editor.AbstractCategoricalColorMapEditor;
import com.macrofocus.colormap.swing.ComboBoxCellEditor;
import com.macrofocus.combobox.MColorComboBox;
import com.macrofocus.combobox.MJYComboBox;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.util.swing.print.CopyAction;
import com.macrofocus.util.swing.print.ExportComponentAction;
import com.macrofocus.util.swing.print.PrintComponentAction;
import com.macrofocus.util.swing.spinner.EnhancedSlider;
import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.ColorComboBoxEditor;
import de.javasoft.combobox.controls.ColorComboBoxRenderer;
import de.javasoft.combobox.controls.ColorPopupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SwingCategoricalColorMapEditor
extends AbstractCategoricalColorMapEditor<JComponent, Color> {
    private static EditorContext editorContext = new EditorContext("CategoricalColorMapEditor");
    private JPanel mainPanel;
    private JButton generateColorsButton;
    private JTable table;
    private MColorComboBox missingValueColor;
    private JButton resetButton;
    private EnhancedSlider brightnessSlider;
    private EnhancedSlider saturationSlider;
    final ItemListener nullItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            SwingCategoricalColorMapEditor.this.colorMap.setNullColor((CPColor)new SwingColor(SwingCategoricalColorMapEditor.this.missingValueColor.getSelectedColor()));
        }
    };
    private static Method $$$cachedGetBundleMethod$$$ = null;

    public SwingCategoricalColorMapEditor(Action[] actions, boolean expertMode) {
        this.$$$setupUI$$$();
        this.brightnessSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingCategoricalColorMapEditor.this.colorMap.setBrightness(SwingCategoricalColorMapEditor.this.brightnessSlider.getValue());
            }
        });
        this.saturationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingCategoricalColorMapEditor.this.colorMap.setSaturation(SwingCategoricalColorMapEditor.this.saturationSlider.getValue());
            }
        });
        this.missingValueColor.addItemListener(this.nullItemListener);
        JPopupMenu popupMenu = new JPopupMenu();
        if (actions != null) {
            for (Action action : actions) {
                popupMenu.add(action);
            }
            popupMenu.add(new JSeparator());
        }
        popupMenu.add(new CopyAction("Copy Graphics", this.table));
        try {
            popupMenu.add(new ExportComponentAction("Export Graphics...", this.table, expertMode));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        popupMenu.add(new PrintComponentAction("Print...", this.table));
        this.table.setComponentPopupMenu(popupMenu);
        this.resetButton.setAction(new AbstractAction("Reset"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingCategoricalColorMapEditor.this.colorMap.resetAssignedValues();
            }
        });
    }

    public JPanel getNativeComponent() {
        return this.mainPanel;
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public JTable getLegend() {
        return this.table;
    }

    public void setColorMap(MutableColorMap<Color> colorMap, Class valueType) {
        this.colorMap = colorMap;
        if (colorMap != null) {
            this.brightnessSlider.setValue(colorMap.getBrightness());
            this.saturationSlider.setValue(colorMap.getSaturation());
            this.missingValueColor.setSelectedColor((Color)colorMap.getNullColor().getNativeColor());
            this.table.setModel(new ColorsTableModel(colorMap, valueType));
        }
    }

    private void createUIComponents() {
        this.table = new JTable();
        ColorCellRenderer colorCellRenderer = new ColorCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component instanceof ColorExComboBox) {
                    ((ColorExComboBox)component).setEditable(false);
                    ((ColorExComboBox)component).setColorIconVisible(true);
                    ((ColorExComboBox)component).setColorValueVisible(false);
                }
                return component;
            }
        };
        colorCellRenderer.setColorIconVisible(true);
        colorCellRenderer.setColorValueVisible(false);
        if (this.table instanceof SortableTable) {
            CellRendererManager.registerRenderer(Color.class, (TableCellRenderer)colorCellRenderer, (EditorContext)editorContext);
        } else {
            this.table.setDefaultRenderer(Color.class, (TableCellRenderer)colorCellRenderer);
        }
        if (this.table instanceof SortableTable) {
            CellEditorManager.registerEditor(Color.class, (CellEditorFactory)new CellEditorFactory(){

                public CellEditor create() {
                    ColorCellEditor editor = new ColorCellEditor(){

                        protected void customizeExComboBox() {
                            super.customizeExComboBox();
                            this.getComboBox().setEditable(false);
                            ((ColorExComboBox)this.getComboBox()).setColorIconVisible(true);
                            ((ColorExComboBox)this.getComboBox()).setColorValueVisible(false);
                        }
                    };
                    return editor;
                }
            }, (EditorContext)editorContext);
        } else {
            final MJYComboBox jyComboBox = new MJYComboBox();
            ColorPopupPanel colorPopup = new ColorPopupPanel((JYComboBox)jyComboBox);
            colorPopup.setNonColorButtonVisible(false);
            jyComboBox.setPopupComponent((JComponent)colorPopup);
            ColorComboBoxRenderer renderer = new ColorComboBoxRenderer(jyComboBox.getRenderer());
            jyComboBox.setRenderer((ListCellRenderer)renderer);
            jyComboBox.setEditor((ComboBoxEditor)new ColorComboBoxEditor(jyComboBox.getEditor(), null, true, false));
            this.table.setDefaultEditor(Color.class, (TableCellEditor)new ComboBoxCellEditor((JComboBox)((Object)jyComboBox)){

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    jyComboBox.setEditable(true);
                    Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    jyComboBox.setEditable(false);
                    return component;
                }
            });
        }
        this.brightnessSlider = new EnhancedSlider();
        this.brightnessSlider.setMinimum(-150);
        this.brightnessSlider.setMaximum(150);
        this.saturationSlider = new EnhancedSlider();
        this.saturationSlider.setMinimum(-150);
        this.saturationSlider.setMaximum(150);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.setOpaque(false);
        JScrollPane scrollPane1 = new JScrollPane();
        this.mainPanel.add((Component)scrollPane1, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, new Dimension(0, -1), null, null, 0, false));
        this.table.setPreferredScrollableViewportSize(new Dimension(450, 150));
        scrollPane1.setViewportView(this.table);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.setOpaque(false);
        this.mainPanel.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.generateColorsButton = new JButton();
        this.generateColorsButton.setEnabled(false);
        this.generateColorsButton.setText("Generate Colors...");
        this.generateColorsButton.setVisible(false);
        panel1.add((Component)this.generateColorsButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1));
        panel2.setOpaque(false);
        this.mainPanel.add((Component)panel2, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "missing.values.color"));
        panel2.add((Component)label1, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, new Dimension(0, -1), null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel2.add((Component)spacer2, new GridConstraints(2, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.missingValueColor = new MColorComboBox();
        panel2.add((Component)this.missingValueColor, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), null, null, 0, false));
        this.resetButton = new JButton();
        this.resetButton.setText("Reset");
        panel2.add((Component)this.resetButton, new GridConstraints(2, 3, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Brightness:");
        panel2.add((Component)label2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Saturation:");
        panel2.add((Component)label3, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.saturationSlider.setMaximum(150);
        this.saturationSlider.setMinimum(-150);
        this.saturationSlider.setValue(0);
        panel2.add((Component)this.saturationSlider, new GridConstraints(1, 1, 1, 3, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        this.brightnessSlider.setMaximum(150);
        this.brightnessSlider.setMinimum(-150);
        this.brightnessSlider.setValue(0);
        panel2.add((Component)this.brightnessSlider, new GridConstraints(0, 1, 1, 3, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
    }

    private String $$$getMessageFromBundle$$$(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            if ($$$cachedGetBundleMethod$$$ == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                $$$cachedGetBundleMethod$$$ = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)$$$cachedGetBundleMethod$$$.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static class ColorsTableModel
    extends AbstractTableModel
    implements ContextSensitiveTableModel {
        private final Class valueType;
        private MutableColorMap colorMap;
        final ColorMapListener listener = new ColorMapListener(){

            public void colorMapChanged(ColorMapEvent event) {
                this.fireTableStructureChanged();
            }
        };

        private ColorsTableModel(MutableColorMap colorMap, Class valueType) {
            this.colorMap = colorMap;
            this.valueType = valueType;
            colorMap.addWeakColorMapListener(this.listener);
        }

        @Override
        public int getRowCount() {
            return this.colorMap.getAssignedValues().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Value";
                }
                case 1: {
                    return "Color";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.valueType;
                }
                case 1: {
                    return Color.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.colorMap.getAssignedValues().toArray()[rowIndex];
                }
                case 1: {
                    return this.colorMap.getColor(this.colorMap.getAssignedValues().toArray()[rowIndex]).getNativeColor();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    this.colorMap.setColor(this.colorMap.getAssignedValues().toArray()[rowIndex], (CPColor)new SwingColor((Color)aValue));
                }
            }
        }

        public ConverterContext getConverterContextAt(int i, int i1) {
            return null;
        }

        public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
            return editorContext;
        }

        public Class<?> getCellClassAt(int rowIndex, int columnIndex) {
            return this.getColumnClass(columnIndex);
        }
    }
}

