/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.range;

import com.macrofocus.helper.SwingHelper;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderController;
import com.macrofocus.slider.SliderView;
import com.macrofocus.util.awt.LightweightBubble;
import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.JLayeredPane;
import javax.swing.Timer;

public class BubbleRangeSliderController
implements SliderController {
    final SliderView sliderView;
    private RangeSliderModel sliderModel;
    private Timer tooltipTimer;
    private final Format format;
    private LightweightBubble bubbleMax;
    private LightweightBubble bubbleMin;
    private LightweightBubble bubbleRangeMax;
    private LightweightBubble bubbleRangeMin;
    private boolean isIn = false;
    private boolean dragging = false;
    private final RenderingHintsModel renderingHintsModel;
    final RangeSliderListener rangeSliderListener = new RangeSliderListener(){

        public void sliderChanged(RangeSliderEvent e) {
            BubbleRangeSliderController.this.updateSliderValues();
        }

        public void sliderScaleChanged(RangeSliderEvent e) {
            BubbleRangeSliderController.this.updateSliderValues();
        }
    };
    final MouseMotionAdapter mouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent e) {
            BubbleRangeSliderController.this.dragging = true;
        }
    };
    final MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            BubbleRangeSliderController.this.isIn = true;
            BubbleRangeSliderController.this.tooltipTimer.start();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!BubbleRangeSliderController.this.isIn && BubbleRangeSliderController.this.dragging) {
                BubbleRangeSliderController.this.hideSliderValues();
            }
            BubbleRangeSliderController.this.dragging = false;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BubbleRangeSliderController.this.isIn = false;
            if (!BubbleRangeSliderController.this.dragging) {
                BubbleRangeSliderController.this.tooltipTimer.stop();
                BubbleRangeSliderController.this.hideSliderValues();
            }
        }
    };

    public BubbleRangeSliderController(SliderView sliderView, RenderingHintsModel renderingHintsModel) {
        this.sliderView = sliderView;
        this.sliderModel = sliderView.getRangeSliderModel();
        this.renderingHintsModel = renderingHintsModel;
        JLayeredPane layeredPane = SwingHelper.getTopLayeredPane((Component)sliderView.getComponent());
        this.format = NumberFormat.getInstance();
        this.tooltipTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BubbleRangeSliderController.this.showSliderValues();
            }
        });
        this.tooltipTimer.setRepeats(false);
        sliderView.addMouseListener((MouseListener)this.mouseListener);
        sliderView.addMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        this.sliderModel.addSliderListener(this.rangeSliderListener);
    }

    private void disposeSliderValues() {
        JLayeredPane layeredPane = SwingHelper.getTopLayeredPane((Component)this.sliderView.getComponent());
        if (this.bubbleMax != null) {
            layeredPane.remove(this.bubbleMax);
            this.bubbleMax = null;
        }
        if (this.bubbleMin != null) {
            layeredPane.remove(this.bubbleMin);
            this.bubbleMin = null;
        }
        if (this.bubbleRangeMax != null) {
            layeredPane.remove(this.bubbleRangeMax);
            this.bubbleRangeMax = null;
        }
        if (this.bubbleRangeMin != null) {
            layeredPane.remove(this.bubbleRangeMin);
            this.bubbleRangeMin = null;
        }
    }

    private void hideSliderValues() {
        if (this.bubbleMax != null && this.bubbleMax.isShowing()) {
            this.bubbleMax.setVisible(false);
        }
        if (this.bubbleMin != null && this.bubbleMin.isShowing()) {
            this.bubbleMin.setVisible(false);
        }
        if (this.bubbleRangeMax != null && this.bubbleRangeMax.isShowing()) {
            this.bubbleRangeMax.setVisible(false);
        }
        if (this.bubbleRangeMin != null && this.bubbleRangeMin.isShowing()) {
            this.bubbleRangeMin.setVisible(false);
        }
    }

    private void showSliderValues() {
        JLayeredPane layeredPane = SwingHelper.getTopLayeredPane((Component)this.sliderView.getComponent());
        if (layeredPane != null) {
            if (this.bubbleMax == null) {
                this.bubbleMax = this.createBubble(this.sliderModel.getMaximum());
                layeredPane.add(this.bubbleMax, JLayeredPane.POPUP_LAYER, 0);
            }
            if (this.bubbleMin == null) {
                this.bubbleMin = this.createBubble(this.sliderModel.getMinimum());
                layeredPane.add(this.bubbleMin, JLayeredPane.POPUP_LAYER, 0);
            }
            if (this.bubbleRangeMax == null) {
                this.bubbleRangeMax = this.createBubble(this.sliderModel.getCurrentMaximum());
                layeredPane.add(this.bubbleRangeMax, JLayeredPane.POPUP_LAYER, 0);
            }
            if (this.bubbleRangeMin == null) {
                this.bubbleRangeMin = this.createBubble(this.sliderModel.getCurrentMinimum());
                layeredPane.add(this.bubbleRangeMin, JLayeredPane.POPUP_LAYER, 0);
            }
            this.updateSliderValues();
            this.bubbleMax.setVisible(true);
            this.bubbleMin.setVisible(true);
            this.bubbleRangeMax.setVisible(true);
            this.bubbleRangeMin.setVisible(true);
        }
    }

    private LightweightBubble createBubble(double value) {
        LightweightBubble bubble = new LightweightBubble(this.format.format(value), this.renderingHintsModel);
        bubble.setBackground(new Color(50, 50, 225));
        bubble.setForeground(Color.yellow);
        bubble.setAlpha(AlphaComposite.getInstance(3, 0.2f));
        return bubble;
    }

    private void updateSliderValues() {
        if (this.sliderView.getComponent().isShowing()) {
            Point p;
            Dimension size;
            JLayeredPane layeredPane = SwingHelper.getTopLayeredPane((Component)this.sliderView.getComponent());
            Point scrnLoc = this.sliderView.getComponent().getLocationOnScreen();
            if (this.bubbleMax != null) {
                this.bubbleMax.setText(this.format.format(this.sliderModel.getMaximum()));
                this.bubbleMax.setLocation(BubbleRangeSliderController.getNorthEastPoint(this.bubbleMax, this.sliderView));
                this.bubbleMax.setSize(this.bubbleMax.getPreferredSize());
            }
            if (this.bubbleMin != null) {
                this.bubbleMin.setText(this.format.format(this.sliderModel.getMinimum()));
                size = this.bubbleMin.getPreferredSize();
                this.bubbleMin.setLocation(BubbleRangeSliderController.getNorthWestPoint(this.bubbleMin, this.sliderView));
                this.bubbleMin.setSize(size);
            }
            if (this.bubbleRangeMax != null) {
                this.bubbleRangeMax.setText(this.format.format(this.sliderModel.getCurrentMaximum()));
                size = this.bubbleRangeMax.getPreferredSize();
                p = SwingHelper.convertScreenLocationToParent((Container)this.bubbleRangeMax.getParent(), (int)(scrnLoc.x + this.sliderView.getComponent().getWidth()), (int)(scrnLoc.y + this.sliderView.getMaxBounds().y));
                this.bubbleRangeMax.setLocation(BubbleRangeSliderController.getSouthEastPoint(this.bubbleRangeMax, this.sliderView));
                this.bubbleRangeMax.setSize(size);
            }
            if (this.bubbleRangeMin != null) {
                this.bubbleRangeMin.setText(this.format.format(this.sliderModel.getCurrentMinimum()));
                size = this.bubbleRangeMin.getPreferredSize();
                p = SwingHelper.convertScreenLocationToParent((Container)this.bubbleRangeMin.getParent(), (int)(scrnLoc.x + this.sliderView.getComponent().getWidth()), (int)(scrnLoc.y + this.sliderView.getMinBounds().y + this.sliderView.getMinBounds().height - size.height));
                this.bubbleRangeMin.setLocation(BubbleRangeSliderController.getSouthWestPoint(this.bubbleRangeMin, this.sliderView));
                this.bubbleRangeMin.setSize(size);
            }
        }
    }

    public static Point getNorthWestPoint(LightweightBubble bubble, SliderView sliderView) {
        Point scrnLoc = sliderView.getComponent().getLocationOnScreen();
        Dimension size = bubble.getPreferredSize();
        int x = scrnLoc.x;
        int y = scrnLoc.y - size.height;
        Point p = SwingHelper.convertScreenLocationToParent((Container)bubble.getParent(), (int)x, (int)y);
        return p;
    }

    public static Point getNorthEastPoint(LightweightBubble bubble, SliderView sliderView) {
        Point scrnLoc = sliderView.getComponent().getLocationOnScreen();
        Dimension size = bubble.getPreferredSize();
        int x = scrnLoc.x + sliderView.getComponent().getWidth() - size.width;
        int y = scrnLoc.y - size.height;
        Point p = SwingHelper.convertScreenLocationToParent((Container)bubble.getParent(), (int)x, (int)y);
        return p;
    }

    public static Point getSouthWestPoint(LightweightBubble bubble, SliderView sliderView) {
        Point scrnLoc = sliderView.getComponent().getLocationOnScreen();
        Dimension size = bubble.getPreferredSize();
        int x = scrnLoc.x;
        int y = scrnLoc.y + sliderView.getComponent().getHeight();
        Point p = SwingHelper.convertScreenLocationToParent((Container)bubble.getParent(), (int)x, (int)y);
        return p;
    }

    public static Point getSouthEastPoint(LightweightBubble bubble, SliderView sliderView) {
        Point scrnLoc = sliderView.getComponent().getLocationOnScreen();
        Dimension size = bubble.getPreferredSize();
        int x = scrnLoc.x + sliderView.getComponent().getWidth() - size.width;
        int y = scrnLoc.y + sliderView.getComponent().getHeight();
        Point p = SwingHelper.convertScreenLocationToParent((Container)bubble.getParent(), (int)x, (int)y);
        return p;
    }
}

