/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.file;

import com.macrofocus.layoutmanager.HorizontalProportionalLayoutManager;
import com.macrofocus.layoutmanager.RelativeProportionalConstraint;
import com.macrofocus.util.file.FileSelectionModel;
import com.macrofocus.util.file.FileSelectionView;
import com.macrofocus.util.swing.MFileChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class MultipleFileSelectionView
extends FileSelectionView {
    private FileSelectionModel fileSelectionModel;
    private final JFileChooser fileChooser;

    public MultipleFileSelectionView(FileSelectionModel fileSelectionModel) {
        this(fileSelectionModel, 0);
    }

    public MultipleFileSelectionView(FileSelectionModel fileSelectionModel, int mode) {
        FileFilter fileFilter;
        this.fileSelectionModel = fileSelectionModel;
        this.fileChooser = new MFileChooser(new File(System.getProperty("user.dir")));
        this.fileChooser.setFileSelectionMode(mode);
        this.fileChooser.setMultiSelectionEnabled(true);
        File[] files = fileSelectionModel.getFiles();
        if (files != null) {
            this.setDefaultFiles(files);
        }
        if ((fileFilter = fileSelectionModel.getFileFilter()) != null) {
            this.setDefaultFileFilter(fileFilter);
        }
        this.setLayout((LayoutManager)new HorizontalProportionalLayoutManager());
        this.add((Component)this.fileChooser, new RelativeProportionalConstraint());
        this.validate();
    }

    @Override
    public void addFileFilter(FileFilter fileFilter) {
        this.fileChooser.addChoosableFileFilter(fileFilter);
    }

    @Override
    public void setDefaultFile(File file) {
        this.fileChooser.setSelectedFile(file);
    }

    public void setDefaultFiles(File ... files) {
        this.fileChooser.setSelectedFiles(files);
    }

    @Override
    public void setDefaultFileFilter(FileFilter fileFilter) {
        this.fileChooser.setFileFilter(fileFilter);
    }

    @Override
    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    @Override
    public void setAccessory(JComponent accessory) {
        this.fileChooser.setAccessory(accessory);
        this.fileChooser.validate();
    }
}

