/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.util.geometry.PointModel;
import com.macrofocus.util.geometry.SegmentModel;
import com.macrofocus.util.geometry.ShapeModel;
import java.util.Vector;

public class LayersModel {
    private Vector[] layers;

    public LayersModel(int count) {
        this.layers = new Vector[count];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new Vector();
        }
    }

    public int getLayersCount() {
        return this.layers.length;
    }

    public ShapeModel getShape(int layer, int index) {
        return (ShapeModel)this.layers[layer].elementAt(index);
    }

    public int getShapeCount(int layer) {
        return this.layers[layer].size();
    }

    public void add(ShapeModel shapeModel, int layer) {
        this.layers[layer].addElement(shapeModel);
    }

    public void add(PointModel p1, PointModel p2, int layer) {
        this.layers[layer].addElement(new SegmentModel(p1, p2));
    }

    public void moveCleanLayer(int l, int m) {
        this.layers[m] = this.layers[l];
        this.cleanLayer(l);
    }

    public void cleanLayer(int l) {
        this.layers[l] = new Vector();
    }
}

