/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.dnd;

import com.macrofocus.util.swing.dnd.GhostedDragImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SwingDragImages {
    private static boolean useImages = true;

    static class GlobalImageProvider
    implements DragSourceListener,
    DragSourceMotionListener {
        private GhostedDragImage ghost;

        public GlobalImageProvider() {
            DragSource.getDefaultDragSource().addDragSourceListener(this);
            DragSource.getDefaultDragSource().addDragSourceMotionListener(this);
        }

        private void check(DragSourceDragEvent e) {
            Component src = e.getDragSourceContext().getComponent();
            if (this.ghost == null && src instanceof JComponent) {
                JColorChooser chooser;
                JComponent c = (JComponent)src;
                Point screen = e.getLocation();
                Point origin = c.getLocationOnScreen();
                Point imageOffset = new Point(origin.x - screen.x, origin.y - screen.y);
                SelectionIcon icon = null;
                boolean opaque = false;
                if (src instanceof JTree) {
                    JTree tree = (JTree)c;
                    if (tree.getDragEnabled()) {
                        icon = new TreeSelectionIcon(tree);
                    }
                } else if (src instanceof JTable) {
                    JTable table = (JTable)c;
                    if (table.getDragEnabled()) {
                        icon = new TableSelectionIcon(table);
                    }
                } else if (src instanceof JList) {
                    JList list = (JList)c;
                    if (list.getDragEnabled()) {
                        icon = new ListSelectionIcon(list);
                    }
                } else if (src instanceof JTextComponent) {
                    JTextComponent text = (JTextComponent)c;
                    if (text.getDragEnabled()) {
                        icon = new TextSelectionIcon(text);
                    }
                } else if (src instanceof JColorChooser && (chooser = (JColorChooser)c).getDragEnabled()) {
                    icon = new ColorSelectionIcon(chooser);
                    imageOffset.x = -icon.getIconWidth() / 2;
                    imageOffset.y = -icon.getIconHeight() / 2;
                    opaque = true;
                }
                if (icon != null) {
                    this.ghost = new GhostedDragImage(c, e.getLocation(), icon, imageOffset);
                    if (opaque) {
                        this.ghost.setAlpha(1.0f);
                    }
                }
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
            this.check(e);
            if (this.ghost != null) {
                this.ghost.move(e.getLocation());
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
            this.check(e);
            if (this.ghost != null) {
                this.ghost.move(e.getLocation());
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
            this.check(e);
            if (this.ghost != null) {
                this.ghost.move(e.getLocation());
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            if (this.ghost != null) {
                if (e.getDropSuccess()) {
                    this.ghost.dispose();
                } else {
                    this.ghost.returnToOrigin();
                }
                this.ghost = null;
            }
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragMouseMoved(DragSourceDragEvent e) {
            this.check(e);
            if (this.ghost != null) {
                this.ghost.move(e.getLocation());
            }
        }
    }

    static class TreeSelectionIcon
    extends SelectionIcon {
        public TreeSelectionIcon(JTree tree) {
            super(tree);
        }

        @Override
        protected Area getClip(Component c) {
            JTree tree = (JTree)c;
            int[] indices = tree.getSelectionRows();
            Arrays.sort(indices);
            Area clip = new Area();
            for (int i = 0; i < indices.length; ++i) {
                Rectangle r = tree.getRowBounds(indices[i]);
                clip.add(new Area(r));
            }
            return clip;
        }
    }

    static class TextSelectionIcon
    extends SelectionIcon {
        public TextSelectionIcon(JTextComponent text) {
            super(text);
        }

        @Override
        protected Area getClip(Component c) {
            JTextComponent text = (JTextComponent)c;
            int start = Math.min(text.getSelectionStart(), text.getSelectionEnd());
            int end = Math.max(text.getSelectionStart(), text.getSelectionEnd());
            Area clip = new Area(new Rectangle(0, 0, text.getWidth(), text.getHeight()));
            try {
                clip = new Area();
                Rectangle block = text.modelToView(start);
                for (int i = start + 1; i <= end; ++i) {
                    Rectangle next = text.modelToView(i);
                    if (next.x > block.x + block.width) {
                        int dx = next.x - block.x - block.width;
                        next.x -= dx;
                        next.width += dx;
                    } else {
                        next.width += next.x;
                        next.x = 0;
                    }
                    clip.add(new Area(next));
                    next = block;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return clip;
        }
    }

    static class ListSelectionIcon
    extends SelectionIcon {
        public ListSelectionIcon(JList list) {
            super(list);
        }

        @Override
        protected Area getClip(Component c) {
            JList list = (JList)c;
            Area clip = new Area();
            int[] selected = list.getSelectedIndices();
            for (int i = 0; i < selected.length; ++i) {
                int idx = selected[i];
                clip.add(new Area(list.getCellBounds(idx, idx)));
            }
            return clip;
        }
    }

    static class TableSelectionIcon
    extends SelectionIcon {
        public TableSelectionIcon(JTable table) {
            super(table);
        }

        @Override
        protected Area getClip(Component c) {
            JTable table = (JTable)c;
            Area clip = new Area();
            for (int row = 0; row < table.getRowCount(); ++row) {
                for (int col = 0; col < table.getColumnCount(); ++col) {
                    if (!table.isCellSelected(row, col)) continue;
                    clip.add(new Area(table.getCellRect(row, col, true)));
                }
            }
            return clip;
        }
    }

    static class ColorSelectionIcon
    extends SelectionIcon {
        private Color color;

        public ColorSelectionIcon(JColorChooser chooser) {
            super(chooser);
        }

        @Override
        protected Area getClip(Component c) {
            this.color = ((JColorChooser)c).getColor();
            return super.getClip(c);
        }

        @Override
        protected void paint(Graphics g, int x, int y) {
            g = g.create(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(this.color);
            g.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    static abstract class SelectionIcon
    implements Icon {
        private Image image;
        protected Area clip;
        protected JComponent component;

        protected SelectionIcon(JComponent c) {
            this.component = c;
            this.clip = this.getClip(c);
            if (useImages) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.paint(this.image.getGraphics(), 0, 0);
            }
        }

        protected Area getClip(Component c) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paint(Graphics g, int x, int y) {
            g = g.create();
            g.translate(x, y);
            g.setClip(this.clip);
            try {
                this.component.setDoubleBuffered(false);
                this.component.paint(g);
            }
            finally {
                this.component.setDoubleBuffered(true);
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image != null) {
                g.drawImage(this.image, x, y, null);
            } else {
                this.paint(g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.component.getWidth();
        }

        @Override
        public int getIconHeight() {
            return this.component.getHeight();
        }
    }
}

