/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf.action;

import com.incors.plaf.kunststoff.GradientTheme;
import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.macrofocus.util.swing.plaf.MacrofocusLightKunststoffMetalTheme;
import com.macrofocus.util.swing.plaf.MacrofocusLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class MacrofocusLightKunststoffLookAndFeelAction
extends AbstractAction {
    private final Component frame;

    public MacrofocusLightKunststoffLookAndFeelAction(Component frame) {
        super("Macrofocus Light Kunststoff");
        this.frame = frame;
        this.putValue("ShortDescription", "Macrofocus Light Kunstoff Look and Feel");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        MacrofocusLookAndFeel.initLookAndFeel(true, true);
        try {
            KunststoffLookAndFeel newLookAndFeel = new KunststoffLookAndFeel();
            MacrofocusLightKunststoffMetalTheme theme = new MacrofocusLightKunststoffMetalTheme();
            KunststoffLookAndFeel.setCurrentTheme((MetalTheme)theme);
            KunststoffLookAndFeel.setCurrentGradientTheme((GradientTheme)theme);
            MetalLookAndFeel.setCurrentTheme(theme);
            UIManager.put("ScrollBar.width", 13);
            Color thumbColor = new Color(66, 106, 178);
            UIManager.put("ScrollBar.thumb", thumbColor);
            UIManager.put("ScrollBar.thumbHighlight", thumbColor.brighter());
            UIManager.put("ScrollBar.thumbShadow", thumbColor.darker());
            UIManager.setLookAndFeel((LookAndFeel)newLookAndFeel);
            if (this.frame != null) {
                SwingUtilities.updateComponentTreeUI(this.frame);
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't load Macrofocus Light Kunstoff L&F " + String.valueOf(e));
        }
    }
}

