/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.spinner;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeListener;

public class SliderWithSpinnerModel {
    private BoundedRangeModel boundedRangeModel;
    private SpinnerModel spinnerModel = new SpinnerModelImpl();

    public SliderWithSpinnerModel(BoundedRangeModel boundedRangeModel) {
        this.boundedRangeModel = boundedRangeModel;
    }

    public SliderWithSpinnerModel(int value, int minimum, int maximum) {
        assert (minimum <= value && value <= maximum);
        this.boundedRangeModel = new DefaultBoundedRangeModel(value, 0, minimum, maximum);
    }

    SpinnerModel getSpinnerModel() {
        return this.spinnerModel;
    }

    BoundedRangeModel getBoundedRangeModel() {
        return this.boundedRangeModel;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        this.boundedRangeModel = boundedRangeModel;
    }

    public int getValue() {
        return this.boundedRangeModel.getValue();
    }

    private final class SpinnerModelImpl
    implements SpinnerModel {
        private SpinnerModelImpl() {
        }

        @Override
        public Object getValue() {
            return SliderWithSpinnerModel.this.boundedRangeModel.getValue();
        }

        @Override
        public void setValue(Object value) {
            SliderWithSpinnerModel.this.boundedRangeModel.setValue((Integer)value);
        }

        @Override
        public Object getNextValue() {
            return SliderWithSpinnerModel.this.boundedRangeModel.getValue() + 1;
        }

        @Override
        public Object getPreviousValue() {
            return SliderWithSpinnerModel.this.boundedRangeModel.getValue() - 1;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            SliderWithSpinnerModel.this.boundedRangeModel.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            SliderWithSpinnerModel.this.boundedRangeModel.removeChangeListener(l);
        }
    }
}

