/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.wizard;

import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.layoutmanager.HorizontalProportionalLayoutManager;
import com.macrofocus.layoutmanager.PreferredProportionalConstraint;
import com.macrofocus.layoutmanager.RelativeProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.FileSelectionEvent;
import com.macrofocus.util.file.FileSelectionListener;
import com.macrofocus.util.file.FileSelectionView;
import com.macrofocus.util.file.SaveFileSelectionController;
import com.macrofocus.util.file.SimpleSingleFileSelectionModel;
import com.macrofocus.util.file.SingleFileSelectionModel;
import com.macrofocus.util.file.SingleFileSelectionView;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.wizard.SaveFileSelectionTaskModel;
import com.macrofocus.util.wizard.TaskEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class DialogSaveFileSelectionTaskModel
extends SaveFileSelectionTaskModel {
    private final WeakActionListeners actionListeners = new WeakActionListeners();
    private JButton nextButton;
    private JButton previousButton;
    private JButton saveButton;
    private boolean combined = true;
    private FileSelectionView fileSelectionView;
    private final SingleFileSelectionModel fileSelectionModel = new SimpleSingleFileSelectionModel();
    private JTextField textField;
    private File defaultFile;
    private FileFilter defaultFileFilter;
    private List<FileFilter> fileFilters = new ArrayList<FileFilter>();

    public DialogSaveFileSelectionTaskModel(final Component parent) {
        this.textField = new JTextField(40);
        this.textField.setEditable(false);
        if (this.fileSelectionModel.getFile() != null) {
            this.textField.setText(this.fileSelectionModel.getFile().getAbsolutePath());
        }
        this.saveButton = new JButton("Select...");
        this.saveButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = DialogSaveFileSelectionTaskModel.this.getFileSelectionView().getFileChooser();
                fileChooser.rescanCurrentDirectory();
                int returnVal = fileChooser.showSaveDialog(parent);
                if (returnVal == 0) {
                    File file = FileHelper.replaceSuffix((File)fileChooser.getSelectedFile(), (String)((AbstractFileFilter)fileChooser.getFileFilter()).getDefaultExtension());
                    DialogSaveFileSelectionTaskModel.this.textField.setText(file.getAbsolutePath());
                    DialogSaveFileSelectionTaskModel.this.fileSelectionModel.setFile(fileChooser.getFileFilter(), file);
                }
            }
        }, (Object)this.saveButton));
        JPanel horizontalContainer = new JPanel((LayoutManager)new HorizontalProportionalLayoutManager());
        horizontalContainer.add((Component)new JPanel(), new RelativeProportionalConstraint());
        horizontalContainer.add((Component)new JLabel("Filename:"), new PreferredProportionalConstraint(0, 0, 0, 6));
        horizontalContainer.add((Component)this.textField, new PreferredProportionalConstraint());
        horizontalContainer.add((Component)this.saveButton, new PreferredProportionalConstraint(0, 6, 0, 0));
        horizontalContainer.add((Component)new JPanel(), new RelativeProportionalConstraint());
        JPanel verticalContainer = new JPanel((LayoutManager)new VerticalProportionalLayoutManager());
        verticalContainer.add((Component)new JPanel(), new RelativeProportionalConstraint());
        verticalContainer.add((Component)horizontalContainer, new PreferredProportionalConstraint());
        verticalContainer.add((Component)new JPanel(), new RelativeProportionalConstraint());
        this.setComponent(verticalContainer);
        this.nextButton = new JButton("Next >");
        this.nextButton.setEnabled(this.fileSelectionModel.getFile() != null);
        this.previousButton = new JButton("< Previous");
        this.addButton(this.previousButton);
        this.addButton(this.nextButton);
        this.fileSelectionModel.addSelectionListener(new FileSelectionListener(){

            public void selectionChanged(FileSelectionEvent event) {
                DialogSaveFileSelectionTaskModel.this.nextButton.setEnabled(DialogSaveFileSelectionTaskModel.this.fileSelectionModel.getFile() != null);
            }
        });
        this.nextButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DialogSaveFileSelectionTaskModel.this.notifyTaskCompleted(new TaskEvent(this, DialogSaveFileSelectionTaskModel.this.getSelf()));
            }
        }, (Object)this.nextButton));
        this.previousButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DialogSaveFileSelectionTaskModel.this.notifyTaskAborted(new TaskEvent(this, DialogSaveFileSelectionTaskModel.this.getSelf()));
            }
        }, (Object)this.previousButton));
    }

    public void next() {
        this.nextButton.doClick();
    }

    @Override
    public boolean isCombined() {
        return this.combined;
    }

    @Override
    public void addFileFilter(FileFilter fileFilter) {
        if (this.fileSelectionView != null) {
            this.fileSelectionView.addFileFilter(fileFilter);
        } else {
            this.fileFilters.add(fileFilter);
        }
    }

    @Override
    public void setDefaultFile(File defaultFile, FileFilter fileFilter) {
        this.fileSelectionModel.setFile(fileFilter, defaultFile);
        if (this.fileSelectionView != null) {
            this.fileSelectionView.setDefaultFile(defaultFile);
        } else {
            this.defaultFile = defaultFile;
            this.defaultFileFilter = fileFilter;
        }
        if (this.fileSelectionModel.getFile() != null) {
            this.textField.setText(this.fileSelectionModel.getFile().getAbsolutePath());
        }
    }

    @Override
    public File getFile() {
        return this.fileSelectionModel.getFile();
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileSelectionModel.getFileFilter();
    }

    public void setDefaultFileFilter(FileFilter defaultFileFilter) {
        if (this.fileSelectionView != null) {
            this.fileSelectionView.setDefaultFileFilter(defaultFileFilter);
        } else {
            this.defaultFileFilter = defaultFileFilter;
        }
    }

    @Override
    public void setCombined(boolean combined) {
        this.combined = combined;
    }

    public FileSelectionView getFileSelectionView() {
        if (this.fileSelectionView == null) {
            this.fileSelectionView = new SingleFileSelectionView(this.fileSelectionModel);
            new SaveFileSelectionController(this.fileSelectionModel, this.fileSelectionView);
            this.fileSelectionView.getFileChooser().setControlButtonsAreShown(true);
            this.fileSelectionView.setDefaultFile(this.defaultFile);
            for (FileFilter fileFilter : this.fileFilters) {
                this.fileSelectionView.addFileFilter(fileFilter);
            }
            this.fileSelectionView.setDefaultFileFilter(this.defaultFileFilter);
        }
        return this.fileSelectionView;
    }
}

