/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.math.histogram;

public class Range {
    private double a = Double.NaN;
    private double b = Double.NaN;

    public double getMin() {
        return this.a;
    }

    public double getMax() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public void setMin(double minimum) {
        void var1_1;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMax(double maximum) {
        void var1_1;
        this.b = var1_1;
    }

    public String toString() {
        return "[" + this.a + ", " + this.b + "]";
    }

    public double getRange() {
        if (Double.isInfinite(this.b - this.a)) {
            return Double.NaN;
        }
        return this.b - this.a;
    }

    /*
     * WARNING - void declaration
     */
    public Range(double min, double max) {
        if (min <= max) {
            void var3_2;
            void var1_1;
            this.a = var1_1;
            this.b = var3_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Range(Range roleModel) {
        void var1_1;
        this.a = roleModel.getMin();
        this.b = var1_1.getMax();
    }

    public Range(Range[] ranges) {
        if (ranges.length > 0) {
            this.a = ranges[0].getMin();
            this.b = ranges[0].getMax();
            for (int i = 1; i < ranges.length; ++i) {
                this.a = Math.min(this.a, ranges[i].getMin());
                this.b = Math.max(this.b, ranges[i].getMax());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Range(double[] data) {
        void var1_1;
        this.widen((double[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Range(double[] data, int[] valids) {
        void var2_2;
        void var1_1;
        this.widen((double[])var1_1, (int[])var2_2);
    }

    public Range(double[][] data) {
        for (int i = 0; i < data.length; ++i) {
            this.widen(data[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Range scale(double scale) {
        void var1_1;
        return new Range(this.a * scale, this.b * var1_1);
    }

    public Range log() {
        return new Range(Math.log(this.a), Math.log(this.b));
    }

    public Range[] getSubRanges(int count) {
        Range[] rangeArray = new Range[count];
        double d = this.getMin();
        double d2 = this.getRange();
        for (int i = 0; i < rangeArray.length; ++i) {
            rangeArray[i] = new Range(d + d2 * (double)i / (double)rangeArray.length, d + d2 * (double)(i + 1) / (double)rangeArray.length);
        }
        return rangeArray;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(double value) {
        void var1_1;
        return value >= this.a && var1_1 <= this.b;
    }

    /*
     * WARNING - void declaration
     */
    public double getClippedValue(double value) {
        void var1_1;
        return Math.min(this.b, Math.max(this.a, (double)var1_1));
    }

    public Range makeSymmetrical() {
        double d = Math.max(-this.a, this.b);
        return new Range(-d, d);
    }

    public Range ensureWidth(double width) {
        double d;
        double d2 = (width - this.getRange()) / 2.0;
        if (d <= 0.0) {
            return this;
        }
        return new Range(this.a - d2, this.b + d2);
    }

    /*
     * WARNING - void declaration
     */
    public Range widenAbsolute(double extent) {
        void var1_1;
        return new Range(this.a - extent, this.b + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Range widenRelative(double ratio) {
        void var1_1;
        double d = (this.b - this.a) * var1_1;
        return this.widenAbsolute(d);
    }

    public void widen(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.a = Math.min(data[i], this.a);
            this.b = Math.max(data[i], this.b);
        }
    }

    public void widen(double[] data, int[] valids) {
        for (int i = 0; i < valids.length; ++i) {
            this.a = Math.min(data[valids[i]], this.a);
            this.b = Math.max(data[valids[i]], this.b);
        }
    }

    public double[] toDoubleArray() {
        return new double[]{this.a, this.b};
    }
}

