/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.color;

import com.macrofocus.color.ColormapModel;
import java.awt.Color;

public abstract class AbstractColormapModel
implements ColormapModel {
    private Color belowColor;
    private Color aboveColor;

    @Override
    public Color getColor(int entry) {
        if (entry < 0) {
            return this.getBelowColor();
        }
        if (entry >= this.getColorCount()) {
            return this.getAboveColor();
        }
        if (this.getColorModel(entry) != null) {
            return this.getColorModel(entry).getColor();
        }
        return null;
    }

    @Override
    public Color getBelowColor() {
        if (this.belowColor != null) {
            return this.belowColor;
        }
        return this.getColor(0);
    }

    @Override
    public Color getAboveColor() {
        if (this.aboveColor != null) {
            return this.aboveColor;
        }
        return this.getColor(this.getColorCount() - 1);
    }

    public void setAboveColor(Color aboveColor) {
        this.aboveColor = aboveColor;
    }

    @Override
    public String printRGBValues() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getColorCount(); ++i) {
            sb.append(this.getColor(i).getRGB());
            sb.append(", ");
        }
        return sb.toString();
    }
}

