/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.AutoTypeDataModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.SimpleDataModel;
import com.macrofocus.data.reader.BinaryDataReader;
import com.macrofocus.data.reader.CsvDataReader;
import com.macrofocus.data.reader.DataReader;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TabDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.writer.CsvDataWriter;
import com.macrofocus.data.writer.GenericDataWriter;
import com.macrofocus.data.writer.TabDataWriter;
import com.macrofocus.util.file.CharsetToolkit;
import com.macrofocus.util.file.filter.MacrofocusCommaDelimitedFileFilter;
import com.macrofocus.util.file.filter.MacrofocusTabDelimitedFileFilter;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DataHelper {
    public void save(DataModel dataModel, String filename) {
        DataHelper.saveTxt(dataModel, filename);
    }

    public static DataModel loadTxt(String filename) {
        return DataHelper.loadTxt(new File(filename));
    }

    public static DataModel loadTxt(InputStream is) {
        try {
            BufferedInputStream bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
            PerfectDataReader dataReader = new PerfectDataReader(new CharsetToolkit(bis).getReader(), TokenizerFactory.getTabDelimitedInstance(), true, false, "String");
            DataModel dataModel = DataHelper.load(dataReader);
            if (!dataReader.isHasClassHeader()) {
                dataModel = new SimpleDataModel(new AutoTypeDataModel(dataModel));
            }
            return dataModel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DataModel loadTxt(File file) {
        try {
            PerfectDataReader dataReader = new PerfectDataReader(new CharsetToolkit(file).getReader(), TokenizerFactory.getTabDelimitedInstance(), true, false, "String");
            DataModel dataModel = DataHelper.load(dataReader);
            if (!dataReader.isHasClassHeader()) {
                dataModel = new SimpleDataModel(new AutoTypeDataModel(dataModel));
            }
            return dataModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file " + String.valueOf(file));
        }
    }

    public static DataModel loadTxt(File file, Charset charset) {
        try {
            PerfectDataReader dataReader = new PerfectDataReader(new CharsetToolkit(file, charset).getReader(), TokenizerFactory.getTabDelimitedInstance(), true, false, "String");
            DataModel dataModel = DataHelper.load(dataReader);
            if (!dataReader.isHasClassHeader()) {
                dataModel = new SimpleDataModel(new AutoTypeDataModel(dataModel));
            }
            return dataModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file " + String.valueOf(file));
        }
    }

    public static DataModel loadTxt(URL url, String charsetName) {
        try {
            InputStream in = url.openStream();
            DataModel dataModel = DataHelper.loadTxt(new InputStreamReader(in, charsetName));
            in.close();
            return dataModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read URL " + String.valueOf(url));
        }
    }

    public static DataModel loadTxt(URL url) {
        return DataHelper.loadTxt(url, "Cp1252");
    }

    public static DataModel loadTxt(Class context, String filename) {
        try {
            InputStream in = context.getResourceAsStream(filename);
            DataModel dataModel = DataHelper.loadTxt(new InputStreamReader(in, "Cp1252"));
            in.close();
            return dataModel;
        }
        catch (Exception e) {
            return DataHelper.loadTxt(filename);
        }
    }

    public static DataModel loadTxt(Reader reader) {
        return DataHelper.loadTxt(new BufferedReader(reader));
    }

    public static DataModel loadTxt(BufferedReader reader) {
        return DataHelper.load(new TabDataReader(reader));
    }

    public static DataModel loadCsv(File file) {
        try {
            return DataHelper.loadCsv(new FileReader(file));
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return null;
        }
    }

    public static DataModel loadCsv(Reader reader) {
        return DataHelper.loadCsv(new BufferedReader(reader));
    }

    public static DataModel loadCsv(BufferedReader reader) {
        return DataHelper.load(new CsvDataReader(reader));
    }

    public static DataModel loadCompressedBinary(String filename) {
        try {
            return DataHelper.loadBinary(new BufferedInputStream(new GZIPInputStream(new FileInputStream(filename))));
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return null;
        }
    }

    public static DataModel loadCompressedBinary(File file) {
        try {
            return DataHelper.loadBinary(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return null;
        }
    }

    public static DataModel loadBinary(String filename) {
        return DataHelper.loadBinary(new File(filename));
    }

    public static DataModel loadBinary(File file) {
        try {
            return DataHelper.loadBinary(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return null;
        }
    }

    public static DataModel loadBinary(InputStream stream) {
        return DataHelper.loadBinary(new DataInputStream(stream));
    }

    public static DataModel loadBinary(DataInputStream stream) {
        return DataHelper.load(new BinaryDataReader(stream));
    }

    public static DataModel load(DataReader reader) {
        SimpleDataModel dataModel = new SimpleDataModel(reader);
        reader.close();
        return dataModel;
    }

    public static void saveTxt(DataModel dataModel, String filename) {
        DataHelper.saveTxt(dataModel, new File(filename));
    }

    public static void saveTxt(DataModel dataModel, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            DataHelper.saveTxt(dataModel, writer);
            writer.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveTxt(DataModel dataModel, Writer writer) {
        DataHelper.saveTxt(dataModel, new BufferedWriter(writer));
    }

    public static void saveTxt(DataModel dataModel, BufferedWriter writer) {
        TabDataWriter dataWriter = new TabDataWriter(writer);
        dataWriter.write(dataModel);
        try {
            writer.flush();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveCsv(DataModel dataModel, String filename) {
        DataHelper.saveCsv(dataModel, new File(filename));
    }

    public static void saveCsv(DataModel dataModel, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            DataHelper.saveCsv(dataModel, writer);
            writer.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveCsv(DataModel dataModel, Writer writer) {
        DataHelper.saveCsv(dataModel, new BufferedWriter(writer));
    }

    public static void saveCsv(DataModel dataModel, BufferedWriter writer) {
        CsvDataWriter dataWriter = new CsvDataWriter(writer);
        dataWriter.write(dataModel);
        try {
            writer.flush();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveCustom(DataModel dataModel, String filename, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing) {
        DataHelper.saveCustom(dataModel, new File(filename), delim, hasColumnHeader, hasClassHeader, missing);
    }

    public static void saveCustom(DataModel dataModel, File file, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing) {
        try {
            FileWriter writer = new FileWriter(file);
            DataHelper.saveCustom(dataModel, writer, delim, hasColumnHeader, hasClassHeader, missing);
            writer.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveCustom(DataModel dataModel, Writer writer, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing) {
        DataHelper.saveCustom(dataModel, new BufferedWriter(writer), delim, hasColumnHeader, hasClassHeader, missing);
    }

    public static void saveCustom(DataModel dataModel, BufferedWriter writer, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing) {
        GenericDataWriter dataWriter = new GenericDataWriter(writer, delim, hasColumnHeader, hasClassHeader, missing);
        dataWriter.write(dataModel);
        try {
            writer.flush();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveCustomToClipboard(DataModel dataModel, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing) {
        int column;
        StringBuffer sbf = new StringBuffer();
        if (hasColumnHeader) {
            for (column = 0; column < dataModel.getColumnCount(); ++column) {
                sbf.append(dataModel.getColumnName(column));
                if (column >= dataModel.getColumnCount() - 1) continue;
                sbf.append(delim);
            }
            sbf.append("\n");
        }
        if (hasClassHeader) {
            for (column = 0; column < dataModel.getColumnCount(); ++column) {
                String className = dataModel.getColumnClass(column).getName();
                if (className.startsWith("java.lang.")) {
                    className = className.substring("java.lang.".length());
                } else if (className.equals("java.net.URL")) {
                    className = "URL";
                }
                sbf.append(className);
                if (column >= dataModel.getColumnCount() - 1) continue;
                sbf.append(delim);
            }
            sbf.append("\n");
        }
        for (int row = 0; row < dataModel.getRowCount(); ++row) {
            for (int column2 = 0; column2 < dataModel.getColumnCount(); ++column2) {
                if (dataModel.isAvailable(row, column2)) {
                    sbf.append(dataModel.getValueAt(row, column2));
                } else {
                    sbf.append(missing);
                }
                if (column2 >= dataModel.getColumnCount() - 1) continue;
                sbf.append(delim);
            }
            sbf.append("\n");
        }
        StringSelection stsel = new StringSelection(sbf.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stsel, stsel);
    }

    public static void saveTxtToClipboard(DataModel dataModel) {
        DataHelper.saveCustomToClipboard(dataModel, "\t", true, true, "");
    }

    public static void save(Component component, DataModel dataModel, File defaultFile) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(new MacrofocusCommaDelimitedFileFilter());
        fileChooser.setFileFilter(new MacrofocusTabDelimitedFileFilter());
        fileChooser.setSelectedFile(defaultFile);
        int result = fileChooser.showSaveDialog(component);
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            FileFilter fileFilter = fileChooser.getFileFilter();
            if (fileFilter instanceof MacrofocusTabDelimitedFileFilter) {
                DataHelper.saveTxt(dataModel, file);
            } else if (fileFilter instanceof MacrofocusCommaDelimitedFileFilter) {
                DataHelper.saveCsv(dataModel, file);
            }
        }
    }
}

