/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.format;

import com.macrofocus.data.format.AbstractFileURLDataFormat;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.ExcelDataSource;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.MicrosoftExcelFileFilter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import nu.xom.Element;

public class ExcelDataFormat
extends AbstractFileURLDataFormat {
    static final String type = "Excel";
    static final AbstractFileFilter fileFilter = new MicrosoftExcelFileFilter();

    @Override
    public DataSource getDataSource(Element element) throws IOException {
        File file;
        File file2;
        String type = element.getAttributeValue("type");
        String sheetName = element.getAttributeValue("sheet");
        String url = element.getAttributeValue("url");
        if (url != null) {
            return this.getDataSource(new URL(url), sheetName);
        }
        String relativePath = element.getAttributeValue("relativePath");
        if (relativePath != null && (file2 = new File(relativePath)).exists()) {
            return this.getDataSource(file2, sheetName);
        }
        String absolutePath = element.getAttributeValue("absolutePath");
        if (absolutePath != null && (file = new File(absolutePath)).exists()) {
            return this.getDataSource(file, sheetName);
        }
        String path = element.getAttributeValue("path");
        File file3 = new File(path);
        return this.getDataSource(file3, sheetName);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public AbstractFileFilter getFileFilter() {
        return fileFilter;
    }

    @Override
    public DataSource getDataSource(File file) {
        return new ExcelDataSource(file);
    }

    @Override
    public DataSource getDataSource(URL url) {
        return new ExcelDataSource(url);
    }

    public DataSource getDataSource(File file, String sheetName) {
        return new ExcelDataSource(file, sheetName);
    }

    public DataSource getDataSource(URL url, String sheetName) {
        return new ExcelDataSource(url, sheetName);
    }
}

