/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix;

import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.stat.MinMaxMatrixModel;

public final class CalibratedMatrixModel
extends AbstractMatrixModel {
    private MatrixModel _dataset;
    private MinMaxMatrixModel _minmax;
    private double calibration;

    public CalibratedMatrixModel(MatrixModel dataset, double fraction, double bounds) {
        this._dataset = dataset;
        double sum = 0.0;
        long count = 0L;
        for (int row = 0; row < dataset.getRowCount(); ++row) {
            for (int column = 0; column < dataset.getColumnCount(); ++column) {
                double d;
                if (!dataset.isAvailable(row, column) || Double.isNaN(d = dataset.getDouble(row, column)) || Double.isNaN(d)) continue;
                sum += d;
                ++count;
            }
        }
        double average = sum / (double)count;
        this.calibration = bounds * fraction / average;
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this._dataset.isAvailable(row, column);
    }

    @Override
    public int getRowCount() {
        return this._dataset.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._dataset.getColumnCount();
    }

    @Override
    public double getDouble(int row, int column) {
        return this._dataset.getDouble(row, column) * this.calibration;
    }

    @Override
    public Object getColumnName(int column) {
        return this._dataset.getColumnName(column);
    }
}

