/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.data.table.TreeMapTableModel;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.util.file.CharsetToolkit;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.SQLException;
import javax.swing.table.TableModel;

public class CommaDelimitedDataSource
extends FileURLDataSource {
    static final String type = "CommaDelimited";
    private final String defaultCharset;

    public CommaDelimitedDataSource(File file, String defaultCharset) {
        super(file);
        this.defaultCharset = defaultCharset;
    }

    public CommaDelimitedDataSource(URL url, String defaultCharset) {
        super(url);
        this.defaultCharset = defaultCharset;
    }

    public CommaDelimitedDataSource(File file) {
        this(file, "UTF-8");
    }

    public CommaDelimitedDataSource(URL url) {
        this(url, "UTF-8");
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        TableModel tableModel = this.load(contentPane, true, true);
        return tableModel;
    }

    public TableModel load(Component contentPane, boolean autoConvert, boolean treemap) throws IOException, SQLException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        PerfectDataReader dataReader = new PerfectDataReader(new CharsetToolkit(bis, Charset.forName(this.defaultCharset)).getReader(), TokenizerFactory.getCommaDelimitedInstance(), true, false, "String");
        dataReader.setFileLoader(this.getFileLoader());
        RowMajorTableModel tableModel = new RowMajorTableModel(dataReader, autoConvert);
        bis.close();
        if (treemap && TreeMapTableModel.containsEmptyColumn(tableModel)) {
            return new TreeMapTableModel(tableModel);
        }
        return tableModel;
    }

    @Override
    public MutableDataFrame<Integer, String, Object> loadDataFrame(Component contentPane) throws IOException, SQLException {
        TableModel tableModel = this.load(contentPane, false, false);
        return new DefaultDataFrame<Object>(tableModel, true);
    }
}

