/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.data.table.DirectoryStructureTableModel;
import com.macrofocus.data.table.NIODirectoryStructureTableModel;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.util.file.FileHelper;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Node;

public class DirectoryDataSource
extends AbstractDataSource {
    static final String type = "Directory";
    private final File file;

    public DirectoryDataSource(File file) {
        this.file = file;
    }

    public DirectoryDataSource(nu.xom.Element element) {
        File file;
        File file2;
        String relativePath = element.getAttributeValue("relativePath");
        if (relativePath != null && (file2 = new File(relativePath)).exists()) {
            this.file = file2;
            return;
        }
        String absolutePath = element.getAttributeValue("absolutePath");
        if (absolutePath != null && (file = new File(absolutePath)).exists()) {
            this.file = file;
            return;
        }
        String path = element.getAttributeValue("path");
        this.file = new File(path);
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        dataSource.addAttribute(factory.newAttribute("path", this.file.getPath()));
        dataSource.addAttribute(factory.newAttribute("absolutePath", this.file.getAbsolutePath()));
        try {
            dataSource.addAttribute(factory.newAttribute("relativePath", FileHelper.getRelativePath(this.file.getAbsolutePath(), file.getAbsolutePath(), File.separator)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataSource;
    }

    String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        ProgressMonitor progressMonitor = null;
        if (!GraphicsEnvironment.isHeadless() && !SwingUtilities.isEventDispatchThread()) {
            try {
                progressMonitor = new ProgressMonitor(contentPane, "Scanning file system", "", 0, Integer.MAX_VALUE);
                progressMonitor.setMillisToDecideToPopup(50);
                progressMonitor.setMillisToPopup(50);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        try {
            return new NIODirectoryStructureTableModel(this.file, progressMonitor);
        }
        catch (NoClassDefFoundError e) {
            return new DirectoryStructureTableModel(this.file, progressMonitor);
        }
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        nu.xom.Element root = new nu.xom.Element("TreeMap");
        nu.xom.Element layout = new nu.xom.Element("Layout");
        root.appendChild((Node)layout);
        nu.xom.Element algorithm = new nu.xom.Element("Labeling");
        algorithm.addAttribute(new Attribute("name", "None"));
        layout.appendChild((Node)algorithm);
        Document doc = new Document(root);
        return doc;
    }
}

