/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.reader.FileLoader;
import com.macrofocus.data.reader.FileObjectResourceLoader;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.ProgressMonitorInputStream;
import nu.xom.Document;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public abstract class FileObjectDataSource
extends AbstractDataSource {
    protected final FileObject fileObject;

    FileObjectDataSource(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        try {
            Element dataSource = factory.newElement("DataSource");
            dataSource.addAttribute(factory.newAttribute("type", this.getType()));
            dataSource.addAttribute(factory.newAttribute("url", this.fileObject.getURL().toExternalForm()));
            return dataSource;
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract String getType();

    InputStream getInputStream() throws IOException {
        InputStream is = this.fileObject.getURL().openStream();
        return new BufferedInputStream(is);
    }

    BufferedInputStream getInputStream(Component contentPane) throws IOException {
        InputStream inputStream = this.getInputStream();
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                ProgressMonitorInputStream monitorInputStream = new ProgressMonitorInputStream(contentPane, "Reading " + this.getName(), inputStream);
                monitorInputStream.getProgressMonitor().setMillisToDecideToPopup(50);
                monitorInputStream.getProgressMonitor().setMillisToPopup(50);
                inputStream = monitorInputStream;
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        if (this.fileObject.getName().getBaseName().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        return bufferedInputStream;
    }

    String getName() {
        return this.fileObject.getName().getBaseName();
    }

    FileLoader getFileLoader() {
        return new FileObjectResourceLoader(this.fileObject);
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }
}

