/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.SimpleDataModel;
import com.macrofocus.data.reader.DataReader;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.CrosstabTableModel;
import com.macrofocus.data.table.InMemoryDatabase;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.data.table.SimpleTableModel;
import com.macrofocus.data.writer.TableModelDataModel;
import com.macrofocus.util.file.CharsetToolkit;
import com.macrofocus.util.file.FileHelper;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.table.TableModel;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;

public class LipperDataSource
extends FileURLDataSource {
    static final String type = "Lipper";

    public LipperDataSource(File file) {
        super(file);
    }

    public LipperDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        ZipInputStream zin = new ZipInputStream(bis);
        TableModel tableModel = LipperDataSource.load(zin, zin.getNextEntry());
        zin.close();
        return tableModel;
    }

    static TableModel load(ZipInputStream zin, ZipEntry entry) throws IOException {
        HashMap<String, 1> tables = new HashMap<String, 1>();
        HashSet<String> necessaryTables = new HashSet<String>(Arrays.asList("Asset.txt", "AssetStat.txt", "Fund.txt", "FundCompany.txt", "GlobalClass.txt", "LocalClass.txt", "Company.txt", "Domicile.txt"));
        try {
            do {
                if (entry.isDirectory() || !necessaryTables.contains(entry.getName())) continue;
                System.out.print("Processing " + String.valueOf(entry));
                PerfectDataReader dataReader = new PerfectDataReader(new CharsetToolkit(new BufferedInputStream(zin), Charset.forName("ISO-8859-1")).getReader(), TokenizerFactory.getTabDelimitedInstance(), true, false, "String");
                final String tableName = FileHelper.removeSuffix(entry.getName());
                RowMajorTableModel tableModel = new RowMajorTableModel((DataReader)dataReader){

                    public String toString() {
                        return tableName;
                    }
                };
                System.out.println("... loaded " + tableModel.getRowCount() + "x" + tableModel.getColumnCount());
                tables.put(tableName, tableModel);
            } while ((entry = zin.getNextEntry()) != null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InMemoryDatabase db = new InMemoryDatabase();
        TableModel asset = (TableModel)tables.get("Asset");
        TableModel assetStat = (TableModel)tables.get("AssetStat");
        TableModel fund = (TableModel)tables.get("Fund");
        TableModel fundCompany = (TableModel)tables.get("FundCompany");
        TableModel globalClass = (TableModel)tables.get("GlobalClass");
        TableModel localClass = (TableModel)tables.get("LocalClass");
        CrosstabTableModel main = new CrosstabTableModel(assetStat, 0, 1, 7);
        Column lipperIdFund = db.getColumn(fund, "LipperId");
        Column globalClassCodeFund = db.getColumn(fund, "GlobalClassCode");
        Column globalClassCode = db.getColumn(globalClass, "GlobalClassCode");
        Column localClassCodeFund = db.getColumn(fund, "LocalClassCode");
        Column localClassCode = db.getColumn(localClass, "LocalClassCode");
        InMemoryDatabase.Relation[] relations = new InMemoryDatabase.Relation[]{new InMemoryDatabase.Relation(db.getColumn(asset, "LipperId"), db.getColumn(fund, "LipperId")), new InMemoryDatabase.Relation(db.getColumn(fundCompany, "LipperId"), db.getColumn(fund, "LipperId")), new InMemoryDatabase.Relation(globalClassCode, globalClassCodeFund), new InMemoryDatabase.Relation(localClassCode, localClassCodeFund), new InMemoryDatabase.Relation(db.getColumn(main, "LipperId"), db.getColumn(fund, "LipperId"))};
        TableModel firstJoin = db.leftOuterSemiJoin(fund, relations, lipperIdFund, db.getColumn(fundCompany, "CompanyCode"), db.getColumn(asset, "Name"), db.getColumn(asset, "ShortName"), new Column(db.getColumn(globalClass, "Name"), "Global Classification"), new Column(db.getColumn(localClass, "Name"), "Local Classification"), db.getColumn(fund, "DomicileCode"), new Column(db.getColumn(fund, "TNAValue"), "Total Net Assets"), db.getColumn(main, "ACR1M"), db.getColumn(main, "ACR3M"), db.getColumn(main, "ACR6M"), db.getColumn(main, "ACR1Y"), db.getColumn(main, "ACR3Y"), db.getColumn(main, "ACR5Y"), db.getColumn(main, "ACR10Y"), db.getColumn(main, "ASTD3Y"), db.getColumn(main, "ASTD5Y"), db.getColumn(main, "ASTD10Y"), db.getColumn(main, "STD6M"), db.getColumn(main, "STD1Y"), db.getColumn(main, "STD3Y"), db.getColumn(main, "STD5Y"), db.getColumn(main, "STD10Y"), db.getColumn(main, "PCT1YT0"), db.getColumn(main, "PCT1YT1"), db.getColumn(main, "PCT1YT2"), db.getColumn(main, "PCT1YT3"), db.getColumn(main, "PCT1YT4"), db.getColumn(main, "PCT1M"), db.getColumn(main, "PCT3M"), db.getColumn(main, "PCT6M"), db.getColumn(main, "PCT1Y"), db.getColumn(main, "PCT3Y"), db.getColumn(main, "PCT5Y"), db.getColumn(main, "PCT10Y"), db.getColumn(main, "RPA1K1M"), db.getColumn(main, "RPA1K3M"), db.getColumn(main, "RPA1K6M"), db.getColumn(main, "RPA1K9M"), db.getColumn(main, "RPA1K1Y"), db.getColumn(main, "RPA1K2Y"), db.getColumn(main, "RPA1K3Y"), db.getColumn(main, "RPA1K4Y"), db.getColumn(main, "RPA1K5Y"), db.getColumn(main, "RPA1K7Y"), db.getColumn(main, "RPA1K10Y"));
        InMemoryDatabase db2 = new InMemoryDatabase();
        TableModel main2 = firstJoin;
        TableModel company = (TableModel)tables.get("Company");
        TableModel domicile = (TableModel)tables.get("Domicile");
        InMemoryDatabase.Relation[] relations2 = new InMemoryDatabase.Relation[]{new InMemoryDatabase.Relation(db2.getColumn(company, "CompanyCode"), db2.getColumn(main2, "CompanyCode")), new InMemoryDatabase.Relation(db2.getColumn(domicile, "DomicileCode"), db2.getColumn(main2, "DomicileCode"))};
        TableModel secondJoin = db2.leftOuterSemiJoin(main2, relations2, db2.getColumn(main2, "LipperId"), new Column(db2.getColumn(company, "Name"), "Company"), db2.getColumn(main2, "Name"), db2.getColumn(main2, "Global Classification"), db2.getColumn(main2, "Local Classification"), new Column(db2.getColumn(domicile, "Name"), "Domicile"), db2.getColumn(main2, "Total Net Assets"), db2.getColumn(main2, "ACR1M"), db2.getColumn(main2, "ACR3M"), db2.getColumn(main2, "ACR6M"), db2.getColumn(main2, "ACR1Y"), db2.getColumn(main2, "ACR3Y"), db2.getColumn(main2, "ACR5Y"), db2.getColumn(main2, "ACR10Y"), db2.getColumn(main2, "ASTD3Y"), db2.getColumn(main2, "ASTD5Y"), db2.getColumn(main2, "ASTD10Y"), db2.getColumn(main2, "STD6M"), db2.getColumn(main2, "STD1Y"), db2.getColumn(main2, "STD3Y"), db2.getColumn(main2, "STD5Y"), db2.getColumn(main2, "STD10Y"), db2.getColumn(main2, "PCT1YT0"), db2.getColumn(main2, "PCT1YT1"), db2.getColumn(main2, "PCT1YT2"), db2.getColumn(main2, "PCT1YT3"), db2.getColumn(main2, "PCT1YT4"), db2.getColumn(main2, "PCT1M"), db2.getColumn(main2, "PCT3M"), db2.getColumn(main2, "PCT6M"), db2.getColumn(main2, "PCT1Y"), db2.getColumn(main2, "PCT3Y"), db2.getColumn(main2, "PCT5Y"), db2.getColumn(main2, "PCT10Y"), db2.getColumn(main2, "RPA1K1M"), db2.getColumn(main2, "RPA1K3M"), db2.getColumn(main2, "RPA1K6M"), db2.getColumn(main2, "RPA1K9M"), db2.getColumn(main2, "RPA1K1Y"), db2.getColumn(main2, "RPA1K2Y"), db2.getColumn(main2, "RPA1K3Y"), db2.getColumn(main2, "RPA1K4Y"), db2.getColumn(main2, "RPA1K5Y"), db2.getColumn(main2, "RPA1K7Y"), db2.getColumn(main2, "RPA1K10Y"));
        InMemoryDatabase.print(secondJoin, 10);
        return new SimpleTableModel(secondJoin);
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return LipperDataSource.getDefaultDocument(applicationModel);
    }

    static Document getDefaultDocument(ApplicationModel applicationModel) {
        if (applicationModel == ApplicationModelFactory.HIGHD_V1) {
            Element root = new Element("High-D");
            Element variables = new Element("Variables");
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("Total Net Assets", false, 0.0, null, null));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR10Y", false, 0.038461538461538464, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR5Y", false, 0.11538461538461539, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR3Y", false, 0.19230769230769232, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR1Y", false, 0.2692307692307692, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR6M", false, 0.4, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR3M", false, 0.42307692307692313, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR1M", false, 0.5769230769230769, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD6M", false, 0.6538461538461539, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD1Y", false, 0.7307692307692308, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD3Y", false, 0.8076923076923077, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD5Y", false, 0.8846153846153847, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD10Y", false, 0.9615384615384615, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACRYTM", true, 0.34615384615384615, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("LipperId", true, 0.34615384615384615, 6.0000008E7, 6.8150415E7));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCTYTM", true, 0.34615384615384615, -30.83035, 99.17137));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSAYTM", true, 0.34615384615384615, 6916.965, 19917.14));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA1M", true, 0.34615384615384615, 7313.21, 17812.22));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA3M", true, 0.34615384615384615, 6916.965, 19917.14));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA6M", true, 0.34615384615384615, 5517.592, 20005.42));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA3Y", true, 0.34615384615384615, 4073.135, 76500.66));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1M", true, 0.34615384615384615, -26.8679, 78.12224));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA1Y", true, 0.34615384615384615, 2436.075, 19114.33));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT3M", true, 0.34615384615384615, -30.83035, 99.17137));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT6M", true, 0.34615384615384615, -44.82408, 100.0542));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1Y", true, 0.34615384615384615, -75.63925, 91.14333));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT3Y", true, 0.34615384615384615, -59.26865, 665.0067));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT5Y", true, 0.34615384615384615, -69.31401, 159.17));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA5Y", true, 0.34615384615384615, 3068.599, 25917.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT10Y", true, 0.34615384615384615, -27.70844, 776.6918));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA10Y", true, 0.34615384615384615, 7229.156, 87669.18));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT0", true, 0.34615384615384615, -75.63925, 91.14333));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT1", true, 0.34615384615384615, -32.88097, 141.5042));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT2", true, 0.34615384615384615, -36.04, 287.1027));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT3", true, 0.34615384615384615, -89.69628, 26.64832));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT4", true, 0.34615384615384615, -40.46625, 86.73238));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1KYTM", true, 0.34615384615384615, 9738.523, 24579.04));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K1M", true, 0.34615384615384615, 8313.21, 18812.22));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K3M", true, 0.34615384615384615, 9738.523, 24579.04));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K6M", true, 0.34615384615384615, 10473.27, 30447.48));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K9M", true, 0.34615384615384615, 9779.204, 33663.39));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K1Y", true, 0.34615384615384615, 10123.36, 40021.33));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K2Y", true, 0.34615384615384615, 13999.14, 64266.57));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K3Y", true, 0.34615384615384615, 18673.79, 159561.3));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K4Y", true, 0.34615384615384615, 28712.31, 155476.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K5Y", true, 0.34615384615384615, 44190.47, 168797.3));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K7Y", true, 0.34615384615384615, 64884.79, 235429.2));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K10Y", true, 0.34615384615384615, 97138.28, 517438.2));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ASTD3Y", true, 1.0384615384615385, 0.0, 55.65538));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ASTD5Y", true, 1.0384615384615385, 0.010933, 53.14069));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ASTD10Y", true, 1.0384615384615385, 0.447034, 41.20946));
            root.appendChild((Node)variables);
            Document doc = new Document(root);
            return doc;
        }
        if (applicationModel == ApplicationModelFactory.HIGHD_V1) {
            Element root = new Element("ProfilePlot");
            Element variables = new Element("Variables");
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("Total Net Assets", false, 0.0, null, null));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR10Y", false, 0.038461538461538464, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR5Y", false, 0.11538461538461539, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR3Y", false, 0.19230769230769232, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR1Y", false, 0.2692307692307692, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR6M", false, 0.4, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR3M", false, 0.42307692307692313, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACR1M", false, 0.5769230769230769, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD6M", false, 0.6538461538461539, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD1Y", false, 0.7307692307692308, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD3Y", false, 0.8076923076923077, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD5Y", false, 0.8846153846153847, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("STD10Y", false, 0.9615384615384615, 0.0, 20.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ACRYTM", true, 0.34615384615384615, -100.0, 150.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("LipperId", true, 0.34615384615384615, 6.0000008E7, 6.8150415E7));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCTYTM", true, 0.34615384615384615, -30.83035, 99.17137));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSAYTM", true, 0.34615384615384615, 6916.965, 19917.14));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA1M", true, 0.34615384615384615, 7313.21, 17812.22));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA3M", true, 0.34615384615384615, 6916.965, 19917.14));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA6M", true, 0.34615384615384615, 5517.592, 20005.42));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA3Y", true, 0.34615384615384615, 4073.135, 76500.66));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1M", true, 0.34615384615384615, -26.8679, 78.12224));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA1Y", true, 0.34615384615384615, 2436.075, 19114.33));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT3M", true, 0.34615384615384615, -30.83035, 99.17137));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT6M", true, 0.34615384615384615, -44.82408, 100.0542));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1Y", true, 0.34615384615384615, -75.63925, 91.14333));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT3Y", true, 0.34615384615384615, -59.26865, 665.0067));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT5Y", true, 0.34615384615384615, -69.31401, 159.17));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA5Y", true, 0.34615384615384615, 3068.599, 25917.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT10Y", true, 0.34615384615384615, -27.70844, 776.6918));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("SSA10Y", true, 0.34615384615384615, 7229.156, 87669.18));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT0", true, 0.34615384615384615, -75.63925, 91.14333));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT1", true, 0.34615384615384615, -32.88097, 141.5042));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT2", true, 0.34615384615384615, -36.04, 287.1027));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT3", true, 0.34615384615384615, -89.69628, 26.64832));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("PCT1YT4", true, 0.34615384615384615, -40.46625, 86.73238));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1KYTM", true, 0.34615384615384615, 9738.523, 24579.04));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K1M", true, 0.34615384615384615, 8313.21, 18812.22));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K3M", true, 0.34615384615384615, 9738.523, 24579.04));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K6M", true, 0.34615384615384615, 10473.27, 30447.48));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K9M", true, 0.34615384615384615, 9779.204, 33663.39));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K1Y", true, 0.34615384615384615, 10123.36, 40021.33));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K2Y", true, 0.34615384615384615, 13999.14, 64266.57));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K3Y", true, 0.34615384615384615, 18673.79, 159561.3));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K4Y", true, 0.34615384615384615, 28712.31, 155476.0));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K5Y", true, 0.34615384615384615, 44190.47, 168797.3));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K7Y", true, 0.34615384615384615, 64884.79, 235429.2));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("RPA1K10Y", true, 0.34615384615384615, 97138.28, 517438.2));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ASTD3Y", true, 1.0384615384615385, 0.0, 55.65538));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ASTD5Y", true, 1.0384615384615385, 0.010933, 53.14069));
            variables.appendChild((Node)LipperDataSource.createLLCoordsVariable("ASTD10Y", true, 1.0384615384615385, 0.447034, 41.20946));
            root.appendChild((Node)variables);
            Document doc = new Document(root);
            return doc;
        }
        if (applicationModel == ApplicationModelFactory.TREEMAP_V2 || applicationModel == ApplicationModelFactory.TREEMAP_V3) {
            Element root = new Element("TreeMap");
            Element variables = new Element("Variables");
            root.appendChild((Node)variables);
            variables.appendChild((Node)LipperDataSource.createTreeMapCategoricalVariable("LipperId", "None", true, true));
            variables.appendChild((Node)LipperDataSource.createTreeMapCategoricalVariable("Local Classification", null, false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapCategoricalVariable("Global Classification", null, false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ACR1M", "-25", "25", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ACR3M", "-25", "25", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ACR6M", "-25", "25", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ACR1Y", "-25", "25", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ACR3Y", "-25", "25", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ACR5Y", "-25", "25", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ACR10Y", "-25", "25", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ASTD3Y", "0", "10", true, true));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ASTD5Y", "0", "10", true, true));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("ASTD10Y", "0", "10", true, true));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("STD6M", "0", "10", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("STD1Y", "0", "10", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("STD3Y", "0", "10", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("STD5Y", "0", "10", false, false));
            variables.appendChild((Node)LipperDataSource.createTreeMapNumericVariable("STD10Y", "0", "10", false, false));
            Element configuration = new Element("Configuration");
            root.appendChild((Node)configuration);
            Element groupBy = new Element("GroupBy");
            configuration.appendChild((Node)groupBy);
            Element globalClassification = new Element("Variable");
            globalClassification.addAttribute(new Attribute("name", "Global Classification"));
            groupBy.appendChild((Node)globalClassification);
            Element size = new Element("Size");
            size.addAttribute(new Attribute("variableName", "Total Net Assets"));
            configuration.appendChild((Node)size);
            Element color = new Element("Color");
            color.addAttribute(new Attribute("variableName", "ACR6M"));
            configuration.appendChild((Node)color);
            Element label = new Element("Label");
            configuration.appendChild((Node)label);
            Element name = new Element("Variable");
            name.addAttribute(new Attribute("name", "Name"));
            label.appendChild((Node)name);
            Document doc = new Document(root);
            return doc;
        }
        return null;
    }

    private static Element createTreeMapNumericVariable(String name, String min, String max, boolean showPopup, boolean showLabel) {
        Element variable = new Element("Variable");
        variable.addAttribute(new Attribute("name", name));
        variable.addAttribute(new Attribute("colorMin", min));
        variable.addAttribute(new Attribute("colorMax", max));
        variable.addAttribute(new Attribute("showPopup", Boolean.toString(showPopup)));
        variable.addAttribute(new Attribute("showLabel", Boolean.toString(showLabel)));
        return variable;
    }

    private static Element createTreeMapCategoricalVariable(String name, String agg, boolean showPopup, boolean showLabel) {
        Element variable = new Element("Variable");
        variable.addAttribute(new Attribute("name", name));
        if (agg != null) {
            variable.addAttribute(new Attribute("aggregation", agg));
        }
        variable.addAttribute(new Attribute("showPopup", Boolean.toString(showPopup)));
        variable.addAttribute(new Attribute("showLabel", Boolean.toString(showLabel)));
        return variable;
    }

    private static Element createLLCoordsVariable(String name, boolean hidden, Double location, Double min, Double max) {
        Element variable = new Element("Variable");
        variable.addAttribute(new Attribute("name", name));
        variable.addAttribute(new Attribute("hidden", Boolean.toString(hidden)));
        if (location != null) {
            variable.addAttribute(new Attribute("location", Double.toString(location)));
        }
        if (min != null) {
            variable.addAttribute(new Attribute("min", Double.toString(min)));
        }
        if (max != null) {
            variable.addAttribute(new Attribute("max", Double.toString(max)));
        }
        return variable;
    }

    private void createH2Table(Connection conn, TableModel tableModel, String tableName) throws SQLException {
        conn.prepareStatement("SET LOG 0").execute();
        conn.prepareStatement("SET LOCK_MODE 0").execute();
        conn.prepareStatement("SET UNDO_LOG 0").execute();
        String createTable = "CREATE TABLE " + tableName + " (";
        for (int c = 0; c < tableModel.getColumnCount(); ++c) {
            createTable = createTable + tableModel.getColumnName(c);
            Class<?> cl = tableModel.getColumnClass(c);
            if (cl == String.class) {
                createTable = createTable + " VARCHAR";
            } else if (cl == Integer.class) {
                createTable = createTable + " INT";
            } else if (cl == Double.class) {
                createTable = createTable + " DOUBLE";
            } else if (cl == java.util.Date.class) {
                createTable = createTable + " DATE";
            } else if (cl == Date.class) {
                createTable = createTable + " DATE";
            } else {
                throw new UnsupportedOperationException("Unknown type " + String.valueOf(cl));
            }
            if (c >= tableModel.getColumnCount() - 1) continue;
            createTable = createTable + ", ";
        }
        createTable = createTable + ")";
        System.out.println(createTable);
        conn.prepareStatement(createTable).execute();
        for (int r = 0; r < tableModel.getRowCount(); ++r) {
            String insert = "INSERT INTO " + tableName + " VALUES (";
            for (int c = 0; c < tableModel.getColumnCount(); ++c) {
                Object value = tableModel.getValueAt(r, c);
                Class<?> cl = tableModel.getColumnClass(c);
                if (cl == String.class) {
                    insert = insert + "?";
                } else if (cl == Integer.class) {
                    insert = insert + "?";
                } else if (cl == Double.class) {
                    insert = insert + "?";
                } else if (cl == java.util.Date.class) {
                    insert = insert + "?";
                } else if (cl == Date.class) {
                    insert = insert + "?";
                } else {
                    throw new UnsupportedOperationException("Unknown type " + String.valueOf(cl));
                }
                if (c >= tableModel.getColumnCount() - 1) continue;
                insert = insert + ", ";
            }
            insert = insert + ")";
            PreparedStatement st = conn.prepareStatement(insert);
            for (int c = 0; c < tableModel.getColumnCount(); ++c) {
                Object value = tableModel.getValueAt(r, c);
                Class<?> cl = tableModel.getColumnClass(c);
                if (cl == String.class) {
                    st.setString(c + 1, (String)value);
                } else if (cl == Integer.class) {
                    st.setObject(c + 1, value);
                } else if (cl == Double.class) {
                    st.setObject(c + 1, value);
                } else if (cl == java.util.Date.class) {
                    st.setDate(c + 1, new Date(((java.util.Date)value).getTime()));
                } else if (cl == Date.class) {
                    st.setDate(c + 1, (Date)value);
                } else {
                    throw new UnsupportedOperationException("Unknown type " + String.valueOf(cl));
                }
                if (c >= tableModel.getColumnCount() - 1) continue;
                insert = insert + ", ";
            }
            st.execute();
        }
    }

    public static void main(String[] args) {
        try {
            long now = System.currentTimeMillis();
            LipperDataSource dataSource = new LipperDataSource(new File("/Users/luc/macrofocus/dataset/profileplot/Ch120417.zip"));
            TableModel tableModel = dataSource.load(null);
            Document doc = dataSource.getDocument(null);
            try {
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File("/Users/luc/macrofocus/dataset/profileplot/Ch120417.mpc"))));
                zos.putNextEntry(new ZipEntry("datasource.ser"));
                SimpleDataModel dataModel = new SimpleDataModel(new TableModelDataModel(tableModel));
                ObjectOutputStream oout = new ObjectOutputStream(zos);
                oout.writeObject(dataModel);
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry("profileplot.xml"));
                Serializer serializer = new Serializer((OutputStream)zos, "UTF-8");
                serializer.setIndent(4);
                serializer.write(doc);
                zos.closeEntry();
                zos.close();
            }
            catch (IOException e) {
                Logging.getInstance().process((Throwable)e);
            }
            catch (Exception e) {
                Logging.getInstance().process((Throwable)e);
            }
            System.out.println("Processed in " + (System.currentTimeMillis() - now) / 1000L + " seconds");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

