/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.Database;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;

public class InMemoryDatabase
implements Database {
    private Map<Column, Map<Object, Integer>> indices = new WeakHashMap<Column, Map<Object, Integer>>();

    public TableModel leftOuterSemiJoin(TableModel from, Relation[] relations, Column ... select) {
        return new LeftOuterSemiJoinTableModel(from, relations, select);
    }

    Integer lookup(Column column, Object value) {
        return this.getIndex(column).get(value);
    }

    int lookup(TableModel model, int column, Object value) {
        return this.getIndex(model, column).get(value);
    }

    public Column getColumn(TableModel tableModel, String name) {
        for (int c = 0; c < tableModel.getColumnCount(); ++c) {
            if (!name.equals(tableModel.getColumnName(c))) continue;
            return new Column(tableModel, c);
        }
        return null;
    }

    private Map<Object, Integer> getIndex(TableModel model, int columnIndex) {
        Column column = new Column(model, columnIndex);
        return this.getIndex(column);
    }

    private Map<Object, Integer> getIndex(Column column) {
        if (!this.indices.containsKey(column) || this.indices.get(column) == null) {
            HashMap<Object, Integer> index = new HashMap<Object, Integer>();
            this.indices.put(column, index);
            TableModel model = column.getTableModel();
            int columnIndex = column.getColumn();
            for (int r = 0; r < model.getRowCount(); ++r) {
                Object key = model.getValueAt(r, columnIndex);
                if (index.containsKey(key)) {
                    throw new UnsupportedOperationException("Key " + key.toString() + "is not unique");
                }
                index.put(key, r);
            }
            return index;
        }
        return this.indices.get(column);
    }

    public static void print(TableModel tableModel, int maxRow) {
        String s;
        String o;
        int i;
        int cols = tableModel.getColumnCount();
        for (i = 0; i < cols; ++i) {
            o = tableModel.getColumnName(i);
            s = o != null ? o : "n.a.";
            System.out.printf("%20s", StringUtils.abbreviate((String)s, (int)19));
        }
        System.out.println();
        for (i = 0; i < cols; ++i) {
            o = tableModel.getColumnClass(i).getSimpleName();
            s = o != null ? o : "n.a.";
            System.out.printf("%20s", StringUtils.abbreviate((String)s, (int)19));
        }
        System.out.println();
        for (int row = 0; row < tableModel.getRowCount() && row < maxRow; ++row) {
            for (int i2 = 0; i2 < cols; ++i2) {
                Object o2 = tableModel.getValueAt(row, i2);
                String s2 = o2 != null ? o2.toString() : "n.a.";
                System.out.printf("%20s", StringUtils.abbreviate((String)s2, (int)19));
            }
            System.out.println();
        }
    }

    private class LeftOuterSemiJoinTableModel
    extends AbstractTableModel {
        private TableModel from;
        private Map<TableModel, Relation> primary = new HashMap<TableModel, Relation>();
        private Column[] columns;

        LeftOuterSemiJoinTableModel(TableModel from, Relation[] relations, Column ... select) {
            for (int i = 0; i < relations.length; ++i) {
                Relation relation = relations[i];
                Column column = relation.getPrimary();
                this.primary.put(column.getTableModel(), relation);
            }
            this.from = from;
            this.columns = select;
        }

        @Override
        public int getRowCount() {
            return this.from.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            Column column = this.columns[columnIndex];
            return column.getName();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Column column = this.columns[columnIndex];
            TableModel tableModel = column.getTableModel();
            return tableModel.getColumnClass(column.getColumn());
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Column column = this.columns[columnIndex];
            if (column.getTableModel() == this.from) {
                return column.getValueAt(rowIndex);
            }
            Relation relation = this.primary.get(column.getTableModel());
            Object value = relation.getSecondary().getValueAt(rowIndex);
            if (value != null) {
                Column c = relation.getPrimary();
                Integer index = InMemoryDatabase.this.lookup(c, value);
                if (index != null) {
                    return column.getValueAt(index.intValue());
                }
                System.err.println("Could not find value " + String.valueOf(value) + " in " + String.valueOf(c));
                return null;
            }
            return null;
        }
    }

    public static class Relation {
        private Column primary;
        private Column secondary;

        public Relation(Column primary, Column secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        public Column getPrimary() {
            return this.primary;
        }

        public Column getSecondary() {
            return this.secondary;
        }
    }
}

