/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.io.File;
import java.io.IOException;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSNumericVariable;
import org.opendatafoundation.data.spss.SPSSVariable;
import org.opendatafoundation.data.spss.SPSSVariableCategory;

public class SPSSTableModel
extends AbstractTableModel {
    private SPSSFile file;

    public SPSSTableModel(File shapeURL) throws IOException {
        this.file = new SPSSFile(shapeURL);
        try {
            this.file.loadMetadata();
            this.file.loadData();
        }
        catch (SPSSFileException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.file.getVariable(column).getName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        SPSSVariable variable = this.file.getVariable(columnIndex);
        if (variable instanceof SPSSNumericVariable && !variable.hasValueLabels()) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.file.getRecordCount();
    }

    @Override
    public int getColumnCount() {
        return this.file.getVariableCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            SPSSVariable variable = this.file.getVariable(columnIndex);
            if (variable instanceof SPSSNumericVariable) {
                if (!variable.hasValueLabels()) {
                    SPSSNumericVariable numericVariable = (SPSSNumericVariable)variable;
                    Double v = (Double)numericVariable.data.get(rowIndex);
                    if (v.isNaN()) {
                        return null;
                    }
                    return v;
                }
                SPSSNumericVariable numericVariable = (SPSSNumericVariable)variable;
                Double v = (Double)numericVariable.data.get(rowIndex);
                if (v.isNaN()) {
                    return null;
                }
                SPSSVariableCategory category = numericVariable.getCategory(v.doubleValue());
                return category != null ? category.label : null;
            }
            return variable.getValueAsString(rowIndex, new FileFormatInfo());
        }
        catch (SPSSFileException e) {
            e.printStackTrace();
            return null;
        }
    }
}

