/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.util.file.FileHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

public class ZipTableModel
extends AbstractTableModel {
    private final List<ZipEntry> list = new ArrayList<ZipEntry>();
    private final List<String[]> paths = new ArrayList<String[]>();

    public ZipTableModel(ZipInputStream zin, ZipEntry entry) {
        try {
            if (entry != null) {
                do {
                    if (entry.isDirectory()) continue;
                    this.list.add(entry);
                    StrTokenizer tokenizer = new StrTokenizer(entry.getName(), StrMatcher.charSetMatcher((String)"\\/"));
                    String[] path = tokenizer.getTokenArray();
                    String[] copy = new String[path.length - 1];
                    for (int i = 0; i < path.length - 1; ++i) {
                        String s;
                        copy[i] = s = path[i];
                    }
                    this.paths.add(copy);
                } while ((entry = zin.getNextEntry()) != null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ZipEntry entry = this.list.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.paths.get(rowIndex);
            }
            case 1: {
                return FileHelper.getName(entry.getName());
            }
            case 2: {
                return FileHelper.getSuffix(entry.getName());
            }
            case 3: {
                return new Date(entry.getTime());
            }
            case 4: {
                return entry.getSize();
            }
            case 5: {
                return (double)(entry.getSize() - entry.getCompressedSize()) / ((double)entry.getSize() / 100.0);
            }
            case 6: {
                return entry.getCompressedSize();
            }
            case 7: {
                return entry.getCrc();
            }
            case 8: {
                return FileHelper.getPath(entry.getName());
            }
            case 9: {
                return entry.getMethod();
            }
            case 10: {
                return entry.getComment();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Path";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Modified";
            }
            case 4: {
                return "Size";
            }
            case 5: {
                return "Ratio";
            }
            case 6: {
                return "Packed";
            }
            case 7: {
                return "CRC";
            }
            case 8: {
                return "Directory";
            }
            case 9: {
                return "Method";
            }
            case 10: {
                return "Comment";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String[].class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Date.class;
            }
            case 4: {
                return Long.class;
            }
            case 5: {
                return Double.class;
            }
            case 6: {
                return Long.class;
            }
            case 7: {
                return Long.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return Integer.class;
            }
            case 10: {
                return String.class;
            }
        }
        return null;
    }
}

