/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type;

public class ScaledNumber<T extends Number>
extends Number
implements Comparable {
    private static final long serialVersionUID = -6667383645641637133L;
    protected T value;
    protected T min;
    protected T max;

    public ScaledNumber() {
    }

    public ScaledNumber(T value, T min, T max) {
        this.value = value;
        this.min = min;
        this.max = max;
    }

    @Override
    public int intValue() {
        return ((Number)this.value).intValue();
    }

    @Override
    public long longValue() {
        return ((Number)this.value).longValue();
    }

    @Override
    public float floatValue() {
        if (this.value != null) {
            return ((Number)this.value).floatValue();
        }
        return Float.NaN;
    }

    @Override
    public double doubleValue() {
        if (this.value != null) {
            return ((Number)this.value).doubleValue();
        }
        return Double.NaN;
    }

    public T getValue() {
        return this.value;
    }

    public double getScaledValue() {
        if (this.min != null && this.max != null) {
            return (this.doubleValue() - ((Number)this.min).doubleValue()) / (((Number)this.max).doubleValue() - ((Number)this.min).doubleValue());
        }
        return ((Number)this.value).doubleValue();
    }

    public int compareTo(Object o) {
        return Double.compare(this.doubleValue(), ((Number)o).doubleValue());
    }

    public String toString() {
        return this.value.toString();
    }
}

