/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.DuplicableNumericalTimeSeries;
import com.macrofocus.data.type.timeseries.NumericalTimeSeries;

public class IrregularNumericalTimeSeries<T extends Number>
implements DuplicableNumericalTimeSeries<T> {
    private T[] values;
    private Long[] times;
    private Long min = Long.MAX_VALUE;
    private Long max = Long.MIN_VALUE;
    private T minValue;
    private T maxValue;
    private Class<? extends T> type;

    public IrregularNumericalTimeSeries(Class<? extends T> type, Long[] times) {
        assert (Number.class.isAssignableFrom(type)) : "Invalid type " + String.valueOf(type);
        this.times = times;
        for (Long time : times) {
            if (time < this.min) {
                this.min = time;
            }
            if (time <= this.max) continue;
            this.max = time;
        }
        this.type = type;
    }

    @Override
    public NumericalTimeSeries<T> duplicate(T[] values) {
        IrregularNumericalTimeSeries<? extends T> timeSeries = new IrregularNumericalTimeSeries<T>(this.type, this.times);
        timeSeries.setValues((Number[])values);
        return timeSeries;
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public long getTime(int index) {
        return this.times[index];
    }

    @Override
    public T getValue(int index) {
        return this.values[index];
    }

    @Override
    public int getItemCount() {
        return this.values.length;
    }

    @Override
    public long getMinTime() {
        return this.min;
    }

    @Override
    public long getMaxTime() {
        return this.max;
    }

    public void setValues(T[] values) {
        this.values = values;
        for (int i = 0; i < values.length; ++i) {
            T value = values[i];
            if (this.minValue == null || ((Number)value).doubleValue() < ((Number)this.minValue).doubleValue()) {
                this.minValue = value;
            }
            if (this.maxValue != null && !(((Number)value).doubleValue() > ((Number)this.maxValue).doubleValue())) continue;
            this.maxValue = value;
        }
    }

    @Override
    public T getMinValue() {
        return this.minValue;
    }

    @Override
    public T getMaxValue() {
        return this.maxValue;
    }
}

