/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.NumericalTimeSeries;
import com.macrofocus.data.type.timeseries.SavitzkyGolay;
import com.macrofocus.data.type.timeseries.SimpleNumericalTimeSeries;

public class SavitzkyGolayTimeSeries
extends SimpleNumericalTimeSeries<Double> {
    public SavitzkyGolayTimeSeries(NumericalTimeSeries<Number> timeSeries, int windowWidth, int degree) {
        super(Double.class);
        int i;
        int nl = windowWidth;
        int nr = windowWidth;
        float[] coeffs = new float[nl + nr + 1];
        int m = degree;
        boolean ld = false;
        float[] sg_coeffs = new float[nl + nr + 2];
        SavitzkyGolay.savgol(sg_coeffs, nl + nr + 1, nl, nr, 0, m);
        coeffs[nl] = sg_coeffs[1];
        for (i = 0; i < nl; ++i) {
            coeffs[i] = sg_coeffs[nl + 1 - i];
        }
        System.arraycopy(sg_coeffs, 2, coeffs, nl + 1, nr);
        for (i = nl; i < timeSeries.getItemCount() - nr; ++i) {
            double yValue = 0.0;
            for (int j = 0; j < nl + nr + 1; ++j) {
                Number previousObservation = (Number)timeSeries.getValue(i - nl + j);
                if (previousObservation == null) continue;
                yValue += (double)coeffs[j] * previousObservation.doubleValue();
            }
            this.addValue(timeSeries.getTime(i), yValue);
        }
    }
}

