/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.typemap;

import com.macrofocus.data.array.ArrayModel;
import com.macrofocus.data.array.SimpleArrayModel;
import com.macrofocus.data.reader.FileLoader;
import com.macrofocus.data.type.DataFile;
import com.macrofocus.data.type.DataURL;
import com.macrofocus.data.type.HierarchyElement;
import com.macrofocus.data.type.HighLowDouble;
import com.macrofocus.data.type.HtmlString;
import com.macrofocus.data.type.ScaledDouble;
import com.macrofocus.data.type.StringColor;
import com.macrofocus.data.type.StringDouble;
import com.macrofocus.data.type.TypeHelper;
import com.macrofocus.data.type.series.DoubleSeries;
import com.macrofocus.data.typemap.InvalidValueException;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.hierarchy.Hierarchy;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.DataFormatException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class DefaultTypemapModel
implements TypemapModel {
    private static DefaultTypemapModel ourInstance = new DefaultTypemapModel();
    private static final Map<String, TypemapModel.BuilderFactory> nameBuilderFactoryMap;
    private static final Map<Class, TypemapModel.BuilderFactory> classBuilderFactoryMap;
    private static final TypemapModel.BuilderFactory[] factories;

    public static DefaultTypemapModel getInstance() {
        return ourInstance;
    }

    @Override
    public TypemapModel.Builder getBuilder(String type) throws Exception {
        TypemapModel.BuilderFactory factory;
        String format = null;
        if (type != null && !type.contains("[]") && type.contains("[")) {
            int start = type.indexOf("[");
            format = type.substring(start + 1, type.length() - 1);
            type = type.substring(0, start);
        }
        if ((factory = nameBuilderFactoryMap.get(type)) != null) {
            return factory.create(format);
        }
        factory = new ReflectionBuilderFactory(type);
        return factory.create(format);
    }

    public TypemapModel.Builder getBuilder(Class cl) {
        return classBuilderFactoryMap.get(cl).create(null);
    }

    @Override
    public TypemapModel.Builder findBuilder(String type) {
        try {
            return this.getBuilder(type);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void addMapping(String type, Class cl) {
        System.err.println("Unsupported operation");
    }

    @Override
    public Class getClass(String type) throws Exception {
        return this.getBuilder(type).getType();
    }

    @Override
    public String getType(Class cl) {
        for (Map.Entry<String, TypemapModel.BuilderFactory> entry : nameBuilderFactoryMap.entrySet()) {
            if (!entry.getValue().getType().equals(cl)) continue;
            return entry.getValue().getName();
        }
        for (Map.Entry<String, TypemapModel.BuilderFactory> entry : nameBuilderFactoryMap.entrySet()) {
            if (!entry.getValue().getType().isAssignableFrom(cl)) continue;
            return entry.getValue().getName();
        }
        return cl.getName();
    }

    @Override
    public String getType(int index) {
        return factories[index].getName();
    }

    @Override
    public int getTypeCount() {
        return factories.length;
    }

    static {
        factories = new TypemapModel.BuilderFactory[]{new DoubleBuilderFactory(), new FloatBuilderFactory(), new LongBuilderFactory(), new IntegerBuilderFactory(), new ShortBuilderFactory(), new ByteBuilderFactory(), new BigDecimalBuilderFactory(), new BooleanBuilderFactory(), new StringBuilderFactory(), new StringBufferBuilderFactory(), new DateBuilderFactory(), new VectorBuilderFactory(), new ColorBuilderFactory(), new HtmlStringBuilderFactory(), new IconBuilderFactory(), new ImageBuilderFactory(), new DoubleSeriesBuilderFactory(), new HierarchyBuilderFactory(), new HighLowDoubleBuilderFactory(), new URLBuilderFactory(), new FileBuilderFactory(), new DataURLBuilderFactory(), new DataFileBuilderFactory(), new StringPathBuilderFactory(), new StringDoubleBuilderFactory(), new ScaledDoubleBuilderFactory(), new ByteArrayBuilderFactory(), new GeometryBuilderFactory()};
        nameBuilderFactoryMap = new TreeMap<String, TypemapModel.BuilderFactory>(String.CASE_INSENSITIVE_ORDER);
        classBuilderFactoryMap = new HashMap<Class, TypemapModel.BuilderFactory>();
        for (int i = 0; i < factories.length; ++i) {
            try {
                TypemapModel.BuilderFactory factory = factories[i];
                String name = factory.getName();
                Class type = factory.getType();
                nameBuilderFactoryMap.put(name, factory);
                classBuilderFactoryMap.put(type, factory);
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private static class ReflectionBuilderFactory
    implements TypemapModel.BuilderFactory<Object> {
        private Class type;
        private Constructor constructor = null;

        private ReflectionBuilderFactory(String type) throws Exception {
            Class<?> cl;
            try {
                cl = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                try {
                    cl = Class.forName("java.lang." + type);
                }
                catch (ClassNotFoundException e1) {
                    throw new ClassNotFoundException("Invalid class " + type, e);
                }
            }
            if (cl != null) {
                this.constructor = cl.getConstructor(String.class);
                this.type = cl;
            }
        }

        @Override
        public TypemapModel.Builder<Object> create(String pattern) {
            return new ReflectionBuilder(this.constructor, this.type, pattern);
        }

        @Override
        public String getName() {
            return "Reflection";
        }

        @Override
        public Class getType() {
            return this.type;
        }

        private static class ReflectionBuilder
        implements TypemapModel.Builder<Object> {
            private Constructor constructor;
            private Class type;

            private ReflectionBuilder(Constructor constructor, Class cl, String pattern) {
                this.constructor = constructor;
                this.type = cl;
            }

            @Override
            public Object create(String value) throws InvalidValueException {
                Object[] initargs = new Object[]{value};
                try {
                    return this.constructor.newInstance(initargs);
                }
                catch (InstantiationException e) {
                    throw new InvalidValueException("Invalid " + this.type.getName() + " value " + value, e);
                }
                catch (IllegalAccessException e) {
                    throw new InvalidValueException("Invalid " + this.type.getName() + " value " + value, e);
                }
                catch (InvocationTargetException e) {
                    throw new InvalidValueException("Invalid " + this.type.getName() + " value " + value, e);
                }
            }

            @Override
            public String getName() {
                return this.type.getSimpleName();
            }

            @Override
            public Class getType() {
                return this.type;
            }
        }
    }

    private static class DoubleBuilderFactory
    implements TypemapModel.BuilderFactory<Double> {
        private DoubleBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Double> create(String pattern) {
            return new DoubleBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Double";
        }

        @Override
        public Class getType() {
            return Double.class;
        }

        private static class DoubleBuilder
        implements TypemapModel.Builder<Double> {
            NumberFormat format;

            private DoubleBuilder(String pattern) {
                if (pattern != null) {
                    this.format = new DecimalFormat(pattern);
                }
            }

            @Override
            public Double create(String value) throws InvalidValueException {
                String string = value = value != null ? value.trim() : null;
                if (!(value == null || value.equals("") || value.equals("n.a.") || value.equals("k.A.") || value.equals("-"))) {
                    if (this.format != null) {
                        try {
                            return this.format.parse(value).doubleValue();
                        }
                        catch (ParseException e) {
                            throw new InvalidValueException("Invalid double value " + value, e);
                        }
                    }
                    return Double.parseDouble(value);
                }
                return null;
            }

            @Override
            public String getName() {
                return "Double";
            }

            @Override
            public Class getType() {
                return Double.class;
            }
        }
    }

    private static class FloatBuilderFactory
    implements TypemapModel.BuilderFactory<Float> {
        private FloatBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Float> create(String pattern) {
            return new FloatBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Float";
        }

        @Override
        public Class getType() {
            return Float.class;
        }

        private static class FloatBuilder
        implements TypemapModel.Builder<Float> {
            NumberFormat format;

            private FloatBuilder(String pattern) {
                if (pattern != null) {
                    this.format = new DecimalFormat(pattern);
                }
            }

            @Override
            public Float create(String value) throws InvalidValueException {
                String string = value = value != null ? value.trim() : null;
                if (!(value == null || value.equals("") || value.equals("n.a.") || value.equals("k.A."))) {
                    if (this.format != null) {
                        try {
                            return Float.valueOf(this.format.parse(value).floatValue());
                        }
                        catch (ParseException e) {
                            throw new InvalidValueException("Invalid float value " + value, e);
                        }
                    }
                    return Float.valueOf(Float.parseFloat(value));
                }
                return null;
            }

            @Override
            public String getName() {
                return "Float";
            }

            @Override
            public Class getType() {
                return Float.class;
            }
        }
    }

    private static class LongBuilderFactory
    implements TypemapModel.BuilderFactory<Long> {
        private LongBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Long> create(String pattern) {
            return new LongBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Long";
        }

        @Override
        public Class getType() {
            return Long.class;
        }

        private static class LongBuilder
        implements TypemapModel.Builder<Long> {
            NumberFormat format;

            private LongBuilder(String pattern) {
                if (pattern != null) {
                    this.format = new DecimalFormat(pattern);
                }
            }

            @Override
            public Long create(String value) throws InvalidValueException {
                String string = value = value != null ? value.trim() : null;
                if (!(value == null || value.equals("") || value.equals("n.a.") || value.equals("k.A."))) {
                    if (this.format != null) {
                        try {
                            return this.format.parse(value).longValue();
                        }
                        catch (ParseException e) {
                            throw new InvalidValueException("Invalid long value " + value, e);
                        }
                    }
                    return Long.parseLong(value);
                }
                return null;
            }

            @Override
            public String getName() {
                return "Long";
            }

            @Override
            public Class getType() {
                return Long.class;
            }
        }
    }

    private static class IntegerBuilderFactory
    implements TypemapModel.BuilderFactory<Integer> {
        private IntegerBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Integer> create(String pattern) {
            return new IntegerBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Integer";
        }

        @Override
        public Class getType() {
            return Integer.class;
        }

        private static class IntegerBuilder
        implements TypemapModel.Builder<Integer> {
            NumberFormat format;

            private IntegerBuilder(String pattern) {
                if (pattern != null) {
                    this.format = new DecimalFormat(pattern);
                }
            }

            @Override
            public Integer create(String value) throws InvalidValueException {
                String string = value = value != null ? value.trim() : null;
                if (!(value == null || value.equals("") || value.equals("n.a.") || value.equals("k.A.") || value.equals("-"))) {
                    if (this.format != null) {
                        try {
                            return this.format.parse(value).intValue();
                        }
                        catch (ParseException e) {
                            throw new InvalidValueException("Invalid integer value " + value, e);
                        }
                    }
                    if (value != null && value.contains(".")) {
                        value = value.substring(0, value.indexOf("."));
                    }
                    return Integer.parseInt(value);
                }
                return null;
            }

            @Override
            public String getName() {
                return "Integer";
            }

            @Override
            public Class getType() {
                return Integer.class;
            }
        }
    }

    private static class ShortBuilderFactory
    implements TypemapModel.BuilderFactory<Short> {
        private ShortBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Short> create(String pattern) {
            return new ShortBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Short";
        }

        @Override
        public Class getType() {
            return Short.class;
        }

        private static class ShortBuilder
        implements TypemapModel.Builder<Short> {
            NumberFormat format;

            private ShortBuilder(String pattern) {
                if (pattern != null) {
                    this.format = new DecimalFormat(pattern);
                }
            }

            @Override
            public Short create(String value) throws InvalidValueException {
                String string = value = value != null ? value.trim() : null;
                if (this.format != null) {
                    try {
                        return this.format.parse(value).shortValue();
                    }
                    catch (ParseException e) {
                        throw new InvalidValueException("Invalid short value " + value, e);
                    }
                }
                return Short.parseShort(value);
            }

            @Override
            public String getName() {
                return "Short";
            }

            @Override
            public Class getType() {
                return Short.class;
            }
        }
    }

    private static class ByteBuilderFactory
    implements TypemapModel.BuilderFactory<Byte> {
        private ByteBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Byte> create(String pattern) {
            return new ByteBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Byte";
        }

        @Override
        public Class getType() {
            return Byte.class;
        }

        private static class ByteBuilder
        implements TypemapModel.Builder<Byte> {
            NumberFormat format;

            private ByteBuilder(String pattern) {
                if (pattern != null) {
                    this.format = new DecimalFormat(pattern);
                }
            }

            @Override
            public Byte create(String value) throws InvalidValueException {
                String string = value = value != null ? value.trim() : null;
                if (this.format != null) {
                    try {
                        return this.format.parse(value).byteValue();
                    }
                    catch (ParseException e) {
                        throw new InvalidValueException("Invalid byte value " + value, e);
                    }
                }
                return Byte.parseByte(value);
            }

            @Override
            public String getName() {
                return "Byte";
            }

            @Override
            public Class getType() {
                return Byte.class;
            }
        }
    }

    private static class BigDecimalBuilderFactory
    implements TypemapModel.BuilderFactory<BigDecimal> {
        private BigDecimalBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<BigDecimal> create(String pattern) {
            return new BigDecimalBuilder(pattern);
        }

        @Override
        public String getName() {
            return "BigDecimal";
        }

        @Override
        public Class getType() {
            return BigDecimal.class;
        }

        private static class BigDecimalBuilder
        implements TypemapModel.Builder<BigDecimal> {
            private BigDecimalBuilder(String pattern) {
            }

            @Override
            public BigDecimal create(String value) throws InvalidValueException {
                String string = value = value != null ? value.trim() : null;
                if (value != null) {
                    return new BigDecimal(value);
                }
                return null;
            }

            @Override
            public String getName() {
                return "BigDecimal";
            }

            @Override
            public Class getType() {
                return BigDecimal.class;
            }
        }
    }

    private static class BooleanBuilderFactory
    implements TypemapModel.BuilderFactory<Boolean> {
        private BooleanBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Boolean> create(String pattern) {
            return new BooleanBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Boolean";
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }

        private static class BooleanBuilder
        implements TypemapModel.Builder<Boolean> {
            private BooleanBuilder(String pattern) {
            }

            @Override
            public Boolean create(String value) throws InvalidValueException {
                value = value != null ? value.trim() : null;
                return Boolean.parseBoolean(value);
            }

            @Override
            public String getName() {
                return "Boolean";
            }

            @Override
            public Class getType() {
                return Boolean.class;
            }
        }
    }

    private static class StringBuilderFactory
    implements TypemapModel.BuilderFactory<String> {
        private StringBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<String> create(String pattern) {
            return new StringBuilder(pattern);
        }

        @Override
        public String getName() {
            return "String";
        }

        @Override
        public Class getType() {
            return String.class;
        }

        private static class StringBuilder
        implements TypemapModel.Builder<String> {
            private StringBuilder(String pattern) {
            }

            @Override
            public String create(String value) throws InvalidValueException {
                if (value != null && value.equals("n.a.")) {
                    return null;
                }
                return value;
            }

            @Override
            public String getName() {
                return "String";
            }

            @Override
            public Class getType() {
                return String.class;
            }
        }
    }

    private static class StringBufferBuilderFactory
    implements TypemapModel.BuilderFactory<StringBuffer> {
        private StringBufferBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<StringBuffer> create(String pattern) {
            return new StringBufferBuilder(pattern);
        }

        @Override
        public String getName() {
            return "StringBuffer";
        }

        @Override
        public Class getType() {
            return StringBuffer.class;
        }

        private static class StringBufferBuilder
        implements TypemapModel.Builder<StringBuffer> {
            private StringBufferBuilder(String pattern) {
            }

            @Override
            public StringBuffer create(String value) throws InvalidValueException {
                return new StringBuffer(value);
            }

            @Override
            public String getName() {
                return "StringBuffer";
            }

            @Override
            public Class getType() {
                return StringBuffer.class;
            }
        }
    }

    private static class DateBuilderFactory
    implements TypemapModel.BuilderFactory {
        private DateBuilderFactory() {
        }

        public TypemapModel.Builder create(String pattern) {
            return new DateBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Date";
        }

        @Override
        public Class getType() {
            return Date.class;
        }

        private static class DateBuilder
        implements TypemapModel.Builder {
            DateFormat format;

            private DateBuilder(String pattern) {
                this.format = pattern != null ? new SimpleDateFormat(pattern) : new SimpleDateFormat();
            }

            public Object create(String value) throws InvalidValueException {
                value = value != null ? value.trim() : null;
                try {
                    return this.format.parse(value);
                }
                catch (ParseException e) {
                    throw new InvalidValueException("Invalid date value " + value, e);
                }
            }

            @Override
            public String getName() {
                return "Date";
            }

            @Override
            public Class getType() {
                return Date.class;
            }
        }
    }

    private static class VectorBuilderFactory
    implements TypemapModel.BuilderFactory<ArrayModel> {
        private VectorBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<ArrayModel> create(String pattern) {
            return new VectorBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Vector";
        }

        @Override
        public Class getType() {
            return Vector.class;
        }

        private static class VectorBuilder
        implements TypemapModel.Builder<ArrayModel> {
            private VectorBuilder(String pattern) {
            }

            @Override
            public ArrayModel create(String value) throws InvalidValueException {
                if (value != null && value.equals("n.a.")) {
                    return null;
                }
                return new SimpleArrayModel(value);
            }

            @Override
            public String getName() {
                return "Vector";
            }

            @Override
            public Class getType() {
                return Vector.class;
            }
        }
    }

    private static class ColorBuilderFactory
    implements TypemapModel.BuilderFactory<Color> {
        private ColorBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Color> create(String pattern) {
            return new ColorBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Color";
        }

        @Override
        public Class getType() {
            return Color.class;
        }

        private static class ColorBuilder
        implements TypemapModel.Builder<Color> {
            private ColorBuilder(String pattern) {
            }

            @Override
            public Color create(String value) throws InvalidValueException {
                return new StringColor(value);
            }

            @Override
            public String getName() {
                return "Color";
            }

            @Override
            public Class getType() {
                return Color.class;
            }
        }
    }

    private static class HtmlStringBuilderFactory
    implements TypemapModel.BuilderFactory<HtmlString> {
        private HtmlStringBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<HtmlString> create(String pattern) {
            return new HtmlStringBuilder(pattern);
        }

        @Override
        public String getName() {
            return "HtmlString";
        }

        @Override
        public Class getType() {
            return HtmlString.class;
        }

        private static class HtmlStringBuilder
        implements TypemapModel.Builder<HtmlString> {
            private HtmlStringBuilder(String pattern) {
            }

            @Override
            public HtmlString create(String value) throws InvalidValueException {
                return new HtmlString(value);
            }

            @Override
            public String getName() {
                return "HtmlString";
            }

            @Override
            public Class getType() {
                return HtmlString.class;
            }
        }
    }

    private static class IconBuilderFactory
    implements TypemapModel.BuilderFactory<Icon> {
        private IconBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<Icon> create(String pattern) {
            return new IconBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Icon";
        }

        @Override
        public Class getType() {
            return Icon.class;
        }

        private static class IconBuilder
        implements TypemapModel.Builder<Icon> {
            private IconBuilder(String pattern) {
            }

            @Override
            public Icon create(String value) throws InvalidValueException {
                return new ImageIcon(value);
            }

            @Override
            public String getName() {
                return "Icon";
            }

            @Override
            public Class getType() {
                return Icon.class;
            }
        }
    }

    public static class ImageBuilderFactory
    implements TypemapModel.BuilderFactory<Image> {
        @Override
        public TypemapModel.Builder<Image> create(String pattern) {
            return new ImageBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Image";
        }

        @Override
        public Class getType() {
            return BufferedImage.class;
        }

        public static class ImageBuilder
        implements TypemapModel.Builder<Image> {
            private FileLoader fileLoader = null;
            private final boolean ignoreerrors;

            private ImageBuilder(String pattern) {
                this.ignoreerrors = pattern != null && pattern.startsWith("ignoreerrors");
            }

            public void setFileLoader(FileLoader fileLoader) {
                this.fileLoader = fileLoader;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Image create(String value) throws InvalidValueException {
                BufferedImage image = null;
                if (value == null) return image;
                if (this.fileLoader != null) {
                    try {
                        return ImageIO.read(this.fileLoader.load(value));
                    }
                    catch (Exception e) {
                        try {
                            return ImageIO.read(new File(value));
                        }
                        catch (Exception e1) {
                            try {
                                return ImageIO.read(new URL(value));
                            }
                            catch (Exception e2) {
                                if (this.ignoreerrors) return image;
                                throw new InvalidValueException("Invalid image value " + value, e2);
                            }
                        }
                    }
                }
                try {
                    return ImageIO.read(new File(value));
                }
                catch (Exception e1) {
                    try {
                        return ImageIO.read(new URL(value));
                    }
                    catch (Exception e2) {
                        if (this.ignoreerrors) return image;
                        throw new InvalidValueException("Invalid image value " + value, e2);
                    }
                }
            }

            @Override
            public String getName() {
                return "Image";
            }

            @Override
            public Class getType() {
                return BufferedImage.class;
            }
        }
    }

    private static class DoubleSeriesBuilderFactory
    implements TypemapModel.BuilderFactory<DoubleSeries> {
        private DoubleSeriesBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<DoubleSeries> create(String pattern) {
            return new DoubleSeriesBuilder(pattern);
        }

        @Override
        public String getName() {
            return "DoubleSeries";
        }

        @Override
        public Class getType() {
            return DoubleSeries.class;
        }

        private static class DoubleSeriesBuilder
        implements TypemapModel.Builder<DoubleSeries> {
            private DoubleSeriesBuilder(String pattern) {
            }

            @Override
            public DoubleSeries create(String value) throws InvalidValueException {
                return new DoubleSeries(value);
            }

            @Override
            public String getName() {
                return "DoubleSeries";
            }

            @Override
            public Class getType() {
                return DoubleSeries.class;
            }
        }
    }

    private static class HierarchyBuilderFactory
    implements TypemapModel.BuilderFactory<HierarchyElement> {
        private HierarchyBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<HierarchyElement> create(String pattern) {
            return new HierarchyBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Hierarchy";
        }

        @Override
        public Class getType() {
            return Hierarchy.class;
        }

        private static class HierarchyBuilder
        implements TypemapModel.Builder<HierarchyElement> {
            private HierarchyBuilder(String pattern) {
            }

            @Override
            public HierarchyElement create(String value) throws InvalidValueException {
                return new HierarchyElement(value);
            }

            @Override
            public String getName() {
                return "Hierarchy";
            }

            @Override
            public Class getType() {
                return Hierarchy.class;
            }
        }
    }

    private static class HighLowDoubleBuilderFactory
    implements TypemapModel.BuilderFactory<HighLowDouble> {
        private HighLowDoubleBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<HighLowDouble> create(String pattern) {
            return new HighLowDoubleBuilder(pattern);
        }

        @Override
        public String getName() {
            return "HighLowDouble";
        }

        @Override
        public Class getType() {
            return HighLowDouble.class;
        }

        private static class HighLowDoubleBuilder
        implements TypemapModel.Builder<HighLowDouble> {
            private HighLowDoubleBuilder(String pattern) {
            }

            @Override
            public HighLowDouble create(String value) throws InvalidValueException {
                return new HighLowDouble(value);
            }

            @Override
            public String getName() {
                return "HighLowDouble";
            }

            @Override
            public Class getType() {
                return HighLowDouble.class;
            }
        }
    }

    private static class URLBuilderFactory
    implements TypemapModel.BuilderFactory<URL> {
        private URLBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<URL> create(String pattern) {
            return new URLBuilder(pattern);
        }

        @Override
        public String getName() {
            return "URL";
        }

        @Override
        public Class getType() {
            return URL.class;
        }

        private static class URLBuilder
        implements TypemapModel.Builder<URL> {
            private URLBuilder(String pattern) {
            }

            @Override
            public URL create(String value) throws InvalidValueException {
                try {
                    return new URL(value);
                }
                catch (MalformedURLException e) {
                    throw new InvalidValueException("Invalid URL value " + value, e);
                }
            }

            @Override
            public String getName() {
                return "URL";
            }

            @Override
            public Class getType() {
                return URL.class;
            }
        }
    }

    private static class FileBuilderFactory
    implements TypemapModel.BuilderFactory<File> {
        private FileBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<File> create(String pattern) {
            return new FileBuilder(pattern);
        }

        @Override
        public String getName() {
            return "File";
        }

        @Override
        public Class getType() {
            return File.class;
        }

        private static class FileBuilder
        implements TypemapModel.Builder<File> {
            private FileBuilder(String pattern) {
            }

            @Override
            public File create(String value) throws InvalidValueException {
                return new File(value);
            }

            @Override
            public String getName() {
                return "File";
            }

            @Override
            public Class getType() {
                return File.class;
            }
        }
    }

    private static class DataURLBuilderFactory
    implements TypemapModel.BuilderFactory<DataURL> {
        private DataURLBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<DataURL> create(String pattern) {
            return new URLBuilder(pattern);
        }

        @Override
        public String getName() {
            return "DataURL";
        }

        @Override
        public Class getType() {
            return DataURL.class;
        }

        private static class URLBuilder
        implements TypemapModel.Builder<DataURL> {
            private URLBuilder(String pattern) {
            }

            @Override
            public DataURL create(String value) throws InvalidValueException {
                try {
                    return new DataURL(new URL(value));
                }
                catch (MalformedURLException e) {
                    throw new InvalidValueException("Invalid url value " + value, e);
                }
            }

            @Override
            public String getName() {
                return "DataURL";
            }

            @Override
            public Class getType() {
                return DataURL.class;
            }
        }
    }

    private static class DataFileBuilderFactory
    implements TypemapModel.BuilderFactory<DataFile> {
        private DataFileBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<DataFile> create(String pattern) {
            return new FileBuilder(pattern);
        }

        @Override
        public String getName() {
            return "DataFile";
        }

        @Override
        public Class getType() {
            return DataFile.class;
        }

        private static class FileBuilder
        implements TypemapModel.Builder<DataFile> {
            private FileBuilder(String pattern) {
            }

            @Override
            public DataFile create(String value) throws InvalidValueException {
                return new DataFile(new File(value));
            }

            @Override
            public String getName() {
                return "DataFile";
            }

            @Override
            public Class getType() {
                return DataFile.class;
            }
        }
    }

    private static class StringPathBuilderFactory
    implements TypemapModel.BuilderFactory<String[]> {
        private StringPathBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<String[]> create(String pattern) {
            return new StringPathBuilder(pattern);
        }

        @Override
        public String getName() {
            return "StringPath";
        }

        @Override
        public Class getType() {
            return String[].class;
        }

        private static class StringPathBuilder
        implements TypemapModel.Builder<String[]> {
            private char delimiter = (char)44;

            private StringPathBuilder(String pattern) {
                if (pattern != null) {
                    int start;
                    String delimiterKeyword = "delimiter=";
                    if (pattern.contains("delimiter=") && (start = pattern.indexOf("delimiter=") + "delimiter=".length()) < pattern.length()) {
                        this.delimiter = pattern.charAt(start);
                    }
                }
            }

            @Override
            public String[] create(String value) throws InvalidValueException {
                if (value != null) {
                    StrTokenizer tokenizer = new StrTokenizer(value, StrMatcher.charMatcher((char)this.delimiter));
                    String[] path = tokenizer.getTokenArray();
                    return path;
                }
                return new String[0];
            }

            @Override
            public String getName() {
                return "StringPath";
            }

            @Override
            public Class getType() {
                return String[].class;
            }
        }
    }

    private static class StringDoubleBuilderFactory
    implements TypemapModel.BuilderFactory<StringDouble> {
        private StringDoubleBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<StringDouble> create(String pattern) {
            return new StringDoubleBuilder(pattern);
        }

        @Override
        public String getName() {
            return "StringDouble";
        }

        @Override
        public Class getType() {
            return StringDouble.class;
        }

        private static class StringDoubleBuilder
        implements TypemapModel.Builder<StringDouble> {
            private StringDoubleBuilder(String pattern) {
            }

            @Override
            public StringDouble create(String value) throws InvalidValueException {
                return new StringDouble(value);
            }

            @Override
            public String getName() {
                return "StringDouble";
            }

            @Override
            public Class getType() {
                return StringDouble.class;
            }
        }
    }

    private static class ScaledDoubleBuilderFactory
    implements TypemapModel.BuilderFactory<ScaledDouble> {
        private ScaledDoubleBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<ScaledDouble> create(String pattern) {
            return new ScaledDoubleBuilder(pattern);
        }

        @Override
        public String getName() {
            return "ScaledDouble";
        }

        @Override
        public Class getType() {
            return ScaledDouble.class;
        }

        private static class ScaledDoubleBuilder
        implements TypemapModel.Builder<ScaledDouble> {
            private Double min;
            private Double max;

            private ScaledDoubleBuilder(String pattern) {
                if (pattern != null) {
                    StrTokenizer tokenizer = new StrTokenizer(pattern, StrMatcher.charMatcher((char)','));
                    String[] minMax = tokenizer.getTokenArray();
                    this.min = Double.parseDouble(minMax[0]);
                    this.max = Double.parseDouble(minMax[1]);
                } else {
                    this.min = null;
                    this.max = null;
                }
            }

            @Override
            public ScaledDouble create(String value) throws InvalidValueException {
                if (value != null && !value.equals("")) {
                    return new ScaledDouble(Double.parseDouble(value), this.min, this.max);
                }
                return null;
            }

            @Override
            public String getName() {
                return "ScaledDouble";
            }

            @Override
            public Class getType() {
                return ScaledDouble.class;
            }
        }
    }

    private static class ByteArrayBuilderFactory
    implements TypemapModel.BuilderFactory<byte[]> {
        private ByteArrayBuilderFactory() {
        }

        @Override
        public TypemapModel.Builder<byte[]> create(String pattern) {
            return new ByteArrayBuilder(pattern);
        }

        @Override
        public String getName() {
            return "byte[]";
        }

        @Override
        public Class getType() {
            return byte[].class;
        }

        private static class ByteArrayBuilder
        implements TypemapModel.Builder<byte[]> {
            private ByteArrayBuilder(String pattern) {
            }

            @Override
            public byte[] create(String value) throws InvalidValueException {
                try {
                    return TypeHelper.parseBase64CompressedBinary((String)value);
                }
                catch (DataFormatException e) {
                    throw new InvalidValueException("Invalid byte array format", e);
                }
            }

            @Override
            public String getName() {
                return "byte[]";
            }

            @Override
            public Class getType() {
                return byte[].class;
            }
        }
    }

    private static class GeometryBuilderFactory
    implements TypemapModel.BuilderFactory<Geometry> {
        private GeometryBuilderFactory() {
        }

        public GeometryBuilder create(String pattern) {
            return new GeometryBuilder(pattern);
        }

        @Override
        public String getName() {
            return "Geometry";
        }

        @Override
        public Class getType() {
            return Geometry.class;
        }

        private static class GeometryBuilder
        implements TypemapModel.Builder<Geometry> {
            private GeometryBuilder(String pattern) {
            }

            @Override
            public Geometry create(String value) throws InvalidValueException {
                Geometry geometry = null;
                try {
                    WKTReader reader = new WKTReader();
                    geometry = reader.read(value);
                    return geometry;
                }
                catch (org.locationtech.jts.io.ParseException e) {
                    throw new InvalidValueException("Invalid geometry format", e);
                }
            }

            @Override
            public String getName() {
                return "Geometry";
            }

            @Override
            public Class getType() {
                return Geometry.class;
            }
        }
    }
}

