/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.file.filter;

import com.macrofocus.util.file.filter.AbstractFileFilter;

public class TabDelimitedFileFilter
extends AbstractFileFilter {
    private static String[] extensions = new String[]{"txt", "tsv", "tab", "raw", "txt.gz", "tsv.gz"};

    public TabDelimitedFileFilter() {
    }

    public TabDelimitedFileFilter(boolean allowDirectories) {
        super(allowDirectories);
    }

    @Override
    public String getDefaultExtension() {
        return extensions[0];
    }

    @Override
    public String[] getExtensions() {
        return extensions;
    }

    @Override
    public String getName() {
        return "Text (Tab delimited)";
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    @Override
    public boolean acceptContentType(String contentType) {
        return "text/tab-separated-values".equalsIgnoreCase(contentType);
    }
}

