/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.ole.biff.sheet;

import com.macrofocus.util.ole.biff.sheet.SheetModel;
import java.util.Hashtable;

public class SimpleSheetModel
implements SheetModel {
    private Hashtable index = new Hashtable();
    private int columnCount = 0;
    private int rowCount = 0;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getObject(int row, int column) {
        return this.index.get(this.getKey(row, column));
    }

    @Override
    public void setObject(int row, int column, Object value) {
        this.set(row, column);
        this.index.put(this.getKey(row, column), value);
    }

    @Override
    public void setString(int row, int column, String value) {
        if (value != null) {
            this.set(row, column);
            this.index.put(this.getKey(row, column), value);
        }
    }

    @Override
    public String getString(int row, int column) {
        return (String)this.index.get(this.getKey(row, column));
    }

    @Override
    public double getNumber(int row, int column) {
        return (Double)this.index.get(this.getKey(row, column));
    }

    @Override
    public void setNumber(int row, int column, double value) {
        this.set(row, column);
        this.index.put(this.getKey(row, column), value);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",rowCount=" + this.rowCount + ",columnCount=" + this.columnCount + "]";
    }

    private Long getKey(int row, int column) {
        return ((long)row << 32) + (long)column;
    }

    private void set(int row, int column) {
        if (row > this.rowCount - 1) {
            this.rowCount = row + 1;
        }
        if (column > this.columnCount - 1) {
            this.columnCount = column + 1;
        }
    }
}

