/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions.swing;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingCanvas;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.high_d.distributions.AbstractDistributionsComponent;
import com.macrofocus.high_d.distributions.DistributionsView;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class SwingDistributionsComponent<Row, Column, Value, Bin>
extends AbstractDistributionsComponent<JComponent, Color, Row, Column, Value, Bin> {
    private final CPCanvas<JComponent> nativeComponent;

    public SwingDistributionsComponent(final DistributionsView<JLayeredPane, Color, Row, Column, Value, Bin> view) {
        super(view, (CPFactory)new SwingFactory(){

            public SwingCanvas createCanvas() {
                return new SwingCanvas(){

                    public void updateColorTheme() {
                        super.updateColorTheme();
                        ColorTheme colorTheme = (ColorTheme)view.getColorTheme().getValue();
                        if (colorTheme != null && this.getNativeComponent() != null) {
                            Color background = this.getNativeComponent().getBackground();
                            colorTheme.setBackground(SwingFactory.getInstance().createRGBAColor(background.getRed(), background.getGreen(), background.getBlue(), background.getAlpha()));
                            this.getNativeComponent().setBackground((Color)colorTheme.getBackground().getNativeColor());
                            this.getNativeComponent().setForeground((Color)colorTheme.getForeground().getNativeColor());
                        }
                    }
                };
            }
        });
        this.nativeComponent = this.canvas;
        ((JComponent)this.nativeComponent.getNativeComponent()).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingDistributionsComponent.this.scheduleUpdate();
                }
            }
        });
        this.setModel(view.getModel());
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public Dimension getPreferredSize() {
        int count = this.model.getAxisGroupModel().getAxisOrder().size();
        return new Dimension(count * 45, 0);
    }

    protected void refresh() {
        super.refresh();
        this.nativeComponent.refresh();
    }

    public void scheduleUpdate() {
        if (((JComponent)this.nativeComponent.getNativeComponent()).isShowing()) {
            this.timer.restart();
            this.repaint();
        }
    }

    public int getWidth() {
        return ((JComponent)this.nativeComponent.getNativeComponent()).getWidth();
    }

    public int getHeight() {
        return ((JComponent)this.nativeComponent.getNativeComponent()).getHeight();
    }

    public void repaint() {
        this.nativeComponent.repaint();
    }

    public JComponent getNativeComponent() {
        return (JComponent)this.nativeComponent.getNativeComponent();
    }
}

