/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.swing;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.format.CPFormat;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.AxisView;
import com.macrofocus.high_d.parallelcoordinates.AxisComponents;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class SwingAxisComponents
implements AxisComponents {
    private static boolean AVOID_INFINITE_REEENTRANT_CALLS_USING_EPSILON = false;
    private static double EPSILON = 1.0E-10;
    private AxisView axisView;
    private final JFormattedTextField maxLabel;
    private final JFormattedTextField minLabel;
    private final JButton label;
    private final AxisListener axisListener = new AxisListener(){

        public void axisChanged() {
            SwingAxisComponents.this.updateMinMaxLabels();
        }
    };

    public SwingAxisComponents(JButton label) {
        this.minLabel = this.createMinLabel();
        this.maxLabel = this.createMaxLabel();
        this.label = label;
    }

    public AxisView<JComponent> getAxisView() {
        return this.axisView;
    }

    public void setAxisView(AxisView axisView) {
        if (this.axisView != axisView) {
            if (this.axisView != null) {
                this.axisView.getModel().removeAxisListener(this.axisListener);
            }
            this.axisView = axisView;
            if (this.axisView != null) {
                this.axisView.getModel().addAxisListener(this.axisListener);
            }
            this.updateMinMaxLabels();
        }
    }

    private void updateMinMaxLabels() {
        final AxisModel axisModel = this.axisView.getModel();
        this.maxLabel.setValue(axisModel.isNumerical() ? Double.valueOf(axisModel.getMaximum()) : axisModel.getFormattedMaximum());
        this.minLabel.setValue(axisModel.isNumerical() ? Double.valueOf(axisModel.getMinimum()) : axisModel.getFormattedMinimum());
        if (axisModel.isNumerical()) {
            JFormattedTextField.AbstractFormatterFactory tf = axisModel.getFormat() != null ? new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    return new JFormattedTextField.AbstractFormatter(){

                        @Override
                        public Object stringToValue(String text) throws ParseException {
                            try {
                                return axisModel.getFormat().parse(text);
                            }
                            catch (CPFormat.ParsingException e) {
                                throw new ParseException(e.getMessage(), e.getErrorOffset());
                            }
                        }

                        @Override
                        public String valueToString(Object value) throws ParseException {
                            return axisModel.getFormat().formatHtml(value, false);
                        }
                    };
                }
            } : new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    return new JFormattedTextField.AbstractFormatter(){

                        @Override
                        public Object stringToValue(String text) throws ParseException {
                            return NumberFormat.getNumberInstance().parse(text);
                        }

                        @Override
                        public String valueToString(Object value) throws ParseException {
                            return NumberFormat.getNumberInstance().format(value);
                        }
                    };
                }
            };
            this.maxLabel.setFormatterFactory(tf);
            this.minLabel.setFormatterFactory(tf);
        }
        this.maxLabel.setEditable(axisModel.isNumerical());
        this.minLabel.setEditable(axisModel.isNumerical());
    }

    public JButton getLabel() {
        return this.label;
    }

    public JComponent getMinLabel() {
        return this.minLabel;
    }

    public JComponent getMaxLabel() {
        return this.maxLabel;
    }

    private JFormattedTextField createMaxLabel() {
        final JFormattedTextField field = new JFormattedTextField(){

            @Override
            public void updateUI() {
                this.setFont(null);
                super.updateUI();
                Font font = this.getFont();
                this.setFont(font.deriveFont(font.getSize2D() - 2.0f));
                this.setOpaque(false);
                this.setBorder(null);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, SwingAxisComponents.this.axisView.getBeforeTrackGap());
            }
        };
        field.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        field.putClientProperty("Synthetica.background.alpha", Float.valueOf(0.5f));
        field.addPropertyChangeListener("value", new PropertyChangeListener(){
            private boolean updating = false;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!this.updating) {
                    this.updating = true;
                    Object value = field.getValue();
                    if (value instanceof Number) {
                        double max = ((Number)value).doubleValue();
                        MutableBoundedInterval rangeSliderModel = SwingAxisComponents.this.axisView.getModel().getInterval();
                        if (!AVOID_INFINITE_REEENTRANT_CALLS_USING_EPSILON) {
                            if (rangeSliderModel.getEnd() > max) {
                                rangeSliderModel.setValue(rangeSliderModel.getStart(), max - rangeSliderModel.getStart());
                            }
                        } else {
                            if (rangeSliderModel.getEnd() > max && Math.abs(rangeSliderModel.getEnd() - max) > EPSILON) {
                                rangeSliderModel.setValue(rangeSliderModel.getStart(), max - rangeSliderModel.getStart());
                            }
                            SwingAxisComponents.this.axisView.getModel().setMaximum(max);
                        }
                    }
                    this.updating = false;
                }
            }
        });
        return field;
    }

    private JFormattedTextField createMinLabel() {
        final JFormattedTextField field = new JFormattedTextField(){

            @Override
            public void updateUI() {
                this.setFont(null);
                super.updateUI();
                Font font = this.getFont();
                this.setFont(font.deriveFont(font.getSize2D() - 2.0f));
                this.setOpaque(false);
                this.setBorder(null);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, SwingAxisComponents.this.axisView.getAfterTrackGap());
            }
        };
        field.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        field.putClientProperty("Synthetica.background.alpha", Float.valueOf(0.5f));
        field.addPropertyChangeListener("value", new PropertyChangeListener(){
            private boolean updating = false;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!this.updating) {
                    this.updating = true;
                    Object value = field.getValue();
                    if (value instanceof Number) {
                        double min = ((Number)value).doubleValue();
                        MutableBoundedInterval rangeSliderModel = SwingAxisComponents.this.axisView.getModel().getInterval();
                        if (!AVOID_INFINITE_REEENTRANT_CALLS_USING_EPSILON) {
                            if (rangeSliderModel.getStart() < min) {
                                rangeSliderModel.setValue(min, rangeSliderModel.getEnd() - min);
                            }
                        } else if (rangeSliderModel.getStart() < min && Math.abs(rangeSliderModel.getStart() - min) > EPSILON) {
                            rangeSliderModel.setValue(min, rangeSliderModel.getEnd() - min);
                        }
                        SwingAxisComponents.this.axisView.getModel().setMinimum(min);
                    }
                    this.updating = false;
                }
            }
        });
        return field;
    }
}

