/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinatesmatrix.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.helper.TableHelper;
import com.macrofocus.high_d.parallelcoordinatesmatrix.DefaultParallelCoordinatesMatrixModel;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ParallelCoordinatesMatrix;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ParallelCoordinatesMatrixController;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ParallelCoordinatesMatrixModel;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ParallelCoordinatesMatrixView;
import com.macrofocus.high_d.parallelcoordinatesmatrix.swing.SwingParallelCoordinatesMatrixController;
import com.macrofocus.high_d.parallelcoordinatesmatrix.swing.SwingParallelCoordinatesMatrixView;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.DarkColorTheme;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.java.TableModelDataFrame;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class SwingParallelCoordinatesMatrix<R, C>
extends JComponent
implements ParallelCoordinatesMatrix<JComponent, Color, R, C> {
    private ParallelCoordinatesMatrixView<JComponent, Color> view;
    private ParallelCoordinatesMatrixModel model;
    private ParallelCoordinatesMatrixController controller;
    private static LicenseModel licenseModel;

    public SwingParallelCoordinatesMatrix() {
        this.setLayout(new OverlayLayout(this));
        this.view = this.createView();
        this.view.setLicenseModel(licenseModel);
        this.controller = this.createController(this.view);
        this.add((Component)this.view.getNativeComponent());
        this.validate();
    }

    public SwingParallelCoordinatesMatrix(ParallelCoordinatesMatrixModel model) {
        this();
        this.setModel(model);
    }

    public SwingParallelCoordinatesMatrix(DataFrame<R, C, ?> dataFrame) {
        this();
        this.load(dataFrame);
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key);
    }

    void load(DataFrame<R, C, ?> dataFrame) {
        this.setModel(this.createParallelCoordinatesMatrixModel(dataFrame));
    }

    public ParallelCoordinatesMatrixModel getModel() {
        return this.model;
    }

    public void setModel(ParallelCoordinatesMatrixModel model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    public ParallelCoordinatesMatrixView getView() {
        return this.view;
    }

    public void setView(ParallelCoordinatesMatrixView view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    public ParallelCoordinatesMatrixController getController() {
        return this.controller;
    }

    public void setController(ParallelCoordinatesMatrixController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected ParallelCoordinatesMatrixModel createParallelCoordinatesMatrixModel(DataFrame<R, C, ?> dataFrame) {
        return new DefaultParallelCoordinatesMatrixModel(dataFrame, (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPFactory)SwingFactory.getInstance());
    }

    protected ParallelCoordinatesMatrixView createView() {
        SwingParallelCoordinatesMatrixView view = new SwingParallelCoordinatesMatrixView();
        return view;
    }

    protected ParallelCoordinatesMatrixController createController(ParallelCoordinatesMatrixView view) {
        return new SwingParallelCoordinatesMatrixController(view);
    }

    public JComponent getNativeComponent() {
        return this;
    }

    public static void main(String[] args) {
        SwingParallelCoordinatesMatrix.setLicenseKey("Macrofocus GmbH", "3RCD9-DMQDM-AAEMV-LGN5S-76384-FE5WA");
        final TableModel tableModel = TableHelper.createRandomTableModel((int)3, (int)10000, (int)10);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingParallelCoordinatesMatrix parallelCoordinatesMatrix = new SwingParallelCoordinatesMatrix(new TableModelDataFrame(tableModel));
                ParallelCoordinatesMatrixModel model = parallelCoordinatesMatrix.getModel();
                parallelCoordinatesMatrix.getView().getColorTheme().setValue((Object)new DarkColorTheme((CPColorFactory)SwingFactory.getInstance()));
                parallelCoordinatesMatrix.getView().setShowTiming(true);
                ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_API_V1;
                JFrame frame = new JFrame(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
                frame.setSize(800, 400);
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add(parallelCoordinatesMatrix);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

