/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplot.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.helper.TableHelper;
import com.macrofocus.high_d.scatterplot.AbstractScatterPlot;
import com.macrofocus.high_d.scatterplot.DefaultScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlot;
import com.macrofocus.high_d.scatterplot.ScatterPlotController;
import com.macrofocus.high_d.scatterplot.ScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotView;
import com.macrofocus.high_d.scatterplot.swing.SwingScatterPlotController;
import com.macrofocus.high_d.scatterplot.swing.SwingScatterPlotPanel;
import com.macrofocus.high_d.scatterplot.swing.SwingScatterPlotView;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.java.TableModelDataFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.OverlayLayout;
import javax.swing.table.TableModel;

public class SwingScatterPlot<Row, Column>
extends AbstractScatterPlot<JComponent, Color, Font, Row, Column> {
    private final JComponent nativeComponent = new JComponent(){};

    public SwingScatterPlot() {
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.view = this.createView();
        this.controller = this.createController(this.view);
        this.setView(this.view);
    }

    public SwingScatterPlot(ScatterPlotModel<Color, Row, Column> model) {
        this();
        this.setModel(model);
    }

    public SwingScatterPlot(DataFrame<Row, Column, ?> dataFrame) {
        this();
        this.load(dataFrame);
    }

    public void setView(ScatterPlotView<JComponent, Color, Font, Row, Column> view) {
        if (this.getView() != null) {
            this.nativeComponent.remove((Component)this.getView().getNativeComponent());
        }
        super.setView(view);
        if (this.getView() != null) {
            this.nativeComponent.add((Component)this.getView().getNativeComponent());
        }
        this.nativeComponent.revalidate();
    }

    protected ScatterPlotModel createModel(DataFrame dataFrame) {
        return new DefaultScatterPlotModel((CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), dataFrame);
    }

    protected ScatterPlotView createView() {
        SwingScatterPlotView view = new SwingScatterPlotView();
        return view;
    }

    protected ScatterPlotController createController(ScatterPlotView view) {
        return new SwingScatterPlotController(view);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public static void main(String[] args) {
        AbstractScatterPlot.setLicenseKey((String)"Macrofocus GmbH", (String)"3RCD9-DMQDM-AAEMV-LGN5S-76384-FE5WA");
        TableModel tableModel = TableHelper.createRandomTableModel((int)3, (int)10000, (int)10);
        SwingScatterPlot scatterPlot = new SwingScatterPlot(new TableModelDataFrame(tableModel));
        ScatterPlotModel model = scatterPlot.getModel();
        scatterPlot.getView().getColorTheme().setValue((Object)new LightColorTheme((CPColorFactory)SwingFactory.getInstance()));
        scatterPlot.getView().setShowTiming(true);
        ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_API_V1;
        JFrame frame = new JFrame(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
        frame.setSize(600, 600);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new SwingScatterPlotPanel((ScatterPlot<JComponent, Color, Font, ?, ?>)scatterPlot));
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

