/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.macrofocus.cartoplot.CartoPlotController;
import com.macrofocus.cartoplot.CartoPlotView;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.utils.SwingUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SwingCartoPlotController<R, C>
implements CartoPlotController<JComponent, Color, R, C> {
    private CartoPlotView<JComponent, Color, R, C> view;
    private Mode mode = Mode.Selection;
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();
    private boolean multipleSelectionEnabled = true;
    private boolean selectOnPopupTrigger = false;
    private boolean improvedBorderZooming = false;
    private final KeyListener keyListener = new KeyAdapter(){
        Mode oldMode;

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 83) {
                if (this.oldMode == null) {
                    this.oldMode = SwingCartoPlotController.this.mode;
                }
                SwingCartoPlotController.this.mode = Mode.Selection;
            }
            if (e.getKeyCode() == 90) {
                if (this.oldMode == null) {
                    this.oldMode = SwingCartoPlotController.this.mode;
                }
                SwingCartoPlotController.this.mode = Mode.Zooming;
            }
            if (e.getKeyCode() == 80 || e.getKeyCode() == 32) {
                if (this.oldMode == null) {
                    this.oldMode = SwingCartoPlotController.this.mode;
                }
                SwingCartoPlotController.this.mode = Mode.Panning;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.oldMode != null) {
                SwingCartoPlotController.this.mode = this.oldMode;
                this.oldMode = null;
            }
        }
    };

    public SwingCartoPlotController(CartoPlotView view) {
        this.setView(view);
    }

    public void setView(CartoPlotView<JComponent, Color, R, C> view) {
        if (this.view != null) {
            ((JComponent)this.view.getNativeComponent()).removeKeyListener(this.keyListener);
            ((JComponent)this.view.getNativeComponent()).removeMouseListener(this.mouseListener);
            ((JComponent)this.view.getNativeComponent()).removeMouseMotionListener(this.mouseListener);
            ((JComponent)this.view.getNativeComponent()).removeMouseWheelListener(this.mouseListener);
        }
        this.view = view;
        if (view != null) {
            ((JComponent)view.getNativeComponent()).setFocusable(true);
            ((JComponent)view.getNativeComponent()).addKeyListener(this.keyListener);
            ((JComponent)view.getNativeComponent()).addMouseListener(this.mouseListener);
            ((JComponent)view.getNativeComponent()).addMouseMotionListener(this.mouseListener);
            ((JComponent)view.getNativeComponent()).addMouseWheelListener(this.mouseListener);
        }
    }

    private void zoom(double amount, Double xCenter, Double yCenter) {
        Rectangle2D viewport = this.getViewport();
        Rectangle2D world = this.getWorld();
        Range xRange = new Range(amount, xCenter, viewport.getMinX(), viewport.getWidth(), world.getMinX(), world.getMaxX(), this.view.getXRangeModel().getMaximumExtent()).invoke();
        double xMin = xRange.getMin();
        double xMax = xRange.getMax();
        Range yRange = new Range(amount, yCenter, viewport.getMinY(), viewport.getHeight(), world.getMinY(), world.getMaxY(), this.view.getYRangeModel().getMaximumExtent()).invoke();
        double yMin = yRange.getMin();
        double yMax = yRange.getMax();
        if (xMin < xMax && yMin < yMax) {
            this.view.zoom(false, xMin, xMax, yMin, yMax);
        }
    }

    public Rectangle2D getViewport() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(this.view.getXRangeModel().getStart(), this.view.getYRangeModel().getStart(), this.view.getXRangeModel().getStart() + this.view.getXRangeModel().getExtent(), this.view.getYRangeModel().getStart() + this.view.getYRangeModel().getExtent());
        return r;
    }

    public Rectangle2D getWorld() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(this.view.getXRangeModel().getMinimum(), this.view.getYRangeModel().getMinimum(), this.view.getXRangeModel().getMaximum(), this.view.getYRangeModel().getMaximum());
        return r;
    }

    public static enum Mode {
        Selection,
        Zooming,
        Panning;

    }

    private class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Point last;
        private R selectOnRelease = null;
        private Point zoomOnRelease = null;
        private Point zoomingPoint = null;
        private Point pressedPoint = null;

        private DefaultMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SwingCartoPlotController.this.view != null) {
                ((JComponent)SwingCartoPlotController.this.view.getNativeComponent()).requestFocusInWindow();
                if (SwingCartoPlotController.this.view.getModel() != null) {
                    Point point = e.getPoint();
                    SwingCartoPlotController.this.view.getModel().getProbing().setSelected(SwingCartoPlotController.this.view.getClosestRow(point.x, point.y));
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (SwingCartoPlotController.this.view != null && SwingCartoPlotController.this.view.getModel() != null) {
                SwingCartoPlotController.this.view.getModel().getProbing().clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingCartoPlotController.this.view != null) {
                this.pressedPoint = e.getPoint();
                ((JComponent)SwingCartoPlotController.this.view.getNativeComponent()).requestFocus();
                Object bestrow = SwingCartoPlotController.this.view.getClosestRow(e.getX(), e.getY());
                if (bestrow != null) {
                    if (!SwingHelper.isMultipleSelectionKey((InputEvent)e)) {
                        if (!SwingCartoPlotController.this.view.getModel().getSelection().isSelected(bestrow) || SwingCartoPlotController.this.view.getModel().getSelection().getSelectedCount() > 1) {
                            SwingCartoPlotController.this.view.getModel().getSelection().clearSelection();
                            SwingCartoPlotController.this.view.getModel().getSelection().setSelected(bestrow);
                            SwingCartoPlotController.this.view.setSelectionMode(SwingCartoPlotController.this.view.getModel().getSelection().isSelected(bestrow));
                        }
                    } else {
                        SwingCartoPlotController.this.view.setSelectionMode(!SwingCartoPlotController.this.view.getModel().getSelection().isSelected(bestrow));
                        if (SwingCartoPlotController.this.view.isSelectionMode()) {
                            SwingCartoPlotController.this.view.getModel().getSelection().setSelectedState(bestrow, true);
                        } else {
                            SwingCartoPlotController.this.view.getModel().getSelection().setSelectedState(bestrow, false);
                        }
                    }
                } else {
                    SwingCartoPlotController.this.view.getModel().getSelection().clearSelection();
                }
            }
        }

        private void removeFromSelection(R observation) {
            SwingCartoPlotController.this.view.getModel().getSelection().setSelectedState(observation, false);
        }

        private void setSelection(R observation) {
            if (observation != null) {
                SwingCartoPlotController.this.view.getModel().getSelection().setSelectedElements(new Object[]{observation});
            } else {
                SwingCartoPlotController.this.view.getModel().getSelection().clearSelection();
            }
        }

        private void addToSelection(R observation) {
            SwingCartoPlotController.this.view.getModel().getSelection().setSelectedState(observation, true);
        }

        private void addToSelection(List<R> newSelection) {
            SwingCartoPlotController.this.view.getModel().getSelection().setSelectedIterable(newSelection);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingCartoPlotController.this.view != null) {
                if (!e.isPopupTrigger()) {
                    if (this.selectOnRelease != null && SwingUtilities.isLeftMouseButton(e)) {
                        SwingCartoPlotController.this.view.getModel().getSelection().clearSelection();
                        if (SwingCartoPlotController.this.multipleSelectionEnabled) {
                            this.addToSelection(this.selectOnRelease);
                        } else {
                            this.setSelection(this.selectOnRelease);
                        }
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    SwingCartoPlotController.this.view.stopRubberBand();
                } else if (SwingCartoPlotController.this.selectOnPopupTrigger) {
                    Object node = SwingCartoPlotController.this.view.getClosestRow(e.getPoint().x, e.getPoint().y);
                    this.setSelection(node);
                }
                this.last = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingCartoPlotController.this.view != null && SwingCartoPlotController.this.view.getModel() != null) {
                Point point = e.getPoint();
                if (this.last != null) {
                    switch (SwingCartoPlotController.this.mode.ordinal()) {
                        case 0: {
                            boolean isAlreadySelected;
                            if (!SwingUtilities.isLeftMouseButton(e)) break;
                            if (e.isAltDown() || e.isShiftDown()) {
                                SwingCartoPlotController.this.view.getModel().getProbing().clearSelection();
                                if (!SwingCartoPlotController.this.multipleSelectionEnabled) break;
                                if (!SwingCartoPlotController.this.view.getRubberBand().isActive()) {
                                    SwingCartoPlotController.this.view.startRubberBand(this.pressedPoint.x, this.pressedPoint.y);
                                }
                                SwingCartoPlotController.this.view.stretchRubberBand(e.getPoint().x, e.getPoint().y);
                                com.macrofocus.geom.Rectangle2D rect = SwingCartoPlotController.this.view.getRubberBandScreen();
                                if (rect == null) break;
                                List toSelect = SwingCartoPlotController.this.view.getRows((com.macrofocus.geom.Rectangle2D)new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()));
                                if (e.isControlDown()) {
                                    this.addToSelection(toSelect);
                                } else {
                                    SwingCartoPlotController.this.view.getModel().getSelection().setSelectedIterable((Iterable)toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            Object observation = SwingCartoPlotController.this.view.getClosestRow(point.x, point.y);
                            SwingCartoPlotController.this.view.getModel().getProbing().setSelected(observation);
                            this.selectOnRelease = null;
                            boolean bl = isAlreadySelected = SwingCartoPlotController.this.view.getModel().getSelection() != null && SwingCartoPlotController.this.view.getModel().getSelection().isSelected(observation);
                            if (!isAlreadySelected && !SwingUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                                SwingCartoPlotController.this.view.getModel().getSelection().clearSelection();
                            }
                            if (SwingUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                                if (SwingCartoPlotController.this.multipleSelectionEnabled) {
                                    this.addToSelection(observation);
                                    break;
                                }
                                this.setSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            if (SwingCartoPlotController.this.multipleSelectionEnabled) {
                                this.addToSelection(observation);
                                break;
                            }
                            this.setSelection(observation);
                            break;
                        }
                        case 2: {
                            if (!SwingUtilities.isLeftMouseButton(e)) break;
                            Rectangle2D viewport = SwingCartoPlotController.this.getViewport();
                            Rectangle2D world = SwingCartoPlotController.this.getWorld();
                            double x1 = SwingCartoPlotController.this.view.getScreenTransform().getX().screenToWorld(this.last.x);
                            double x2 = SwingCartoPlotController.this.view.getScreenTransform().getX().screenToWorld(e.getPoint().x);
                            double worldDiffX = x1 - x2;
                            double xMin = viewport.getMinX() + worldDiffX;
                            double xMax = viewport.getMaxX() + worldDiffX;
                            double y1 = SwingCartoPlotController.this.view.getScreenTransform().getY().screenToWorld(this.last.y);
                            double y2 = SwingCartoPlotController.this.view.getScreenTransform().getY().screenToWorld(e.getPoint().y);
                            double worldDiffY = y1 - y2;
                            double yMin = viewport.getMinY() + worldDiffY;
                            double yMax = viewport.getMaxY() + worldDiffY;
                            if (xMin < world.getMinX()) {
                                xMax += world.getMinX() - xMin;
                                xMin = world.getMinX();
                            }
                            if (xMax > world.getMaxX()) {
                                xMin -= xMax - world.getMaxX();
                                xMax = world.getMaxX();
                            }
                            xMin = Math.max(world.getMinX(), xMin);
                            xMax = Math.min(world.getMaxX(), xMax);
                            if (yMin < world.getMinY()) {
                                yMax += world.getMinY() - yMin;
                                yMin = world.getMinY();
                            }
                            if (yMax > world.getMaxY()) {
                                yMin -= yMax - world.getMaxY();
                                yMax = world.getMaxY();
                            }
                            yMin = Math.max(world.getMinY(), yMin);
                            yMax = Math.min(world.getMaxY(), yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            SwingCartoPlotController.this.view.zoom(false, xMin, xMax, yMin, yMax);
                            break;
                        }
                        case 1: {
                            if (!SwingUtilities.isMiddleMouseButton(e)) break;
                            Point p = e.getPoint();
                            SwingCartoPlotController.this.zoom(e.getPoint().getY() - this.last.getY() / 100.0, SwingCartoPlotController.this.view.getScreenTransform().getX().screenToWorld(p.x), SwingCartoPlotController.this.view.getScreenTransform().getY().screenToWorld(p.y));
                            this.zoomOnRelease = null;
                        }
                    }
                }
                this.last = e.getPoint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            Object closest = SwingCartoPlotController.this.view.getClosestRow(event.getX(), event.getY());
            SwingCartoPlotController.this.view.getModel().getProbing().setSelected(closest);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (SwingCartoPlotController.this.view != null) {
                int amount = e.getWheelRotation();
                Point p = e.getPoint();
                SwingCartoPlotController.this.zoom((double)amount / 20.0, SwingCartoPlotController.this.view.getScreenTransform().getX().screenToWorld(p.x), SwingCartoPlotController.this.view.getScreenTransform().getY().screenToWorld(p.y));
            }
        }
    }

    private class Range {
        private final double _amount;
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private double _min;
        private double _max;
        private final double _maxExtent;

        public Range(double amount, Double center, double start, double extent, double minRange, double maxRange, double maxExtent) {
            this._amount = amount;
            this._center = center;
            this._start = start;
            this._extent = extent;
            this._minRange = minRange;
            this._maxRange = maxRange;
            this._maxExtent = maxExtent;
        }

        public double getMin() {
            return this._min;
        }

        public double getMax() {
            return this._max;
        }

        public Range invoke() {
            double range = this._extent;
            double newRange = Math.min(this._maxExtent, range + range * this._amount);
            if (this._center != null) {
                this._min = this._center - newRange * ((this._center - this._start) / range);
                this._max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this._min = this._start;
                this._max = this._start + newRange;
            }
            if (this._min < this._minRange) {
                this._max += this._minRange - this._min;
                this._min = this._minRange;
            }
            if (this._max > this._maxRange) {
                this._min -= this._max - this._maxRange;
                this._max = this._maxRange;
            }
            this._min = Math.max(this._minRange, this._min);
            this._max = Math.min(this._maxRange, this._max);
            return this;
        }
    }
}

