/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.georeferencing.country;

import com.macrofocus.cartoplot.georeferencing.AbstractGeoReferencingService;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.SimpleTableModel;
import com.macrofocus.data.table.TableHelper;
import com.macrofocus.data.table.VariableComboBox;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.swing.ColumnsComboBoxModel;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Geometry;

public class CountryGeoReferencingService<R, C>
extends AbstractGeoReferencingService<JComponent, R> {
    public static final String PROPERTY_PRIMARYKEY_INDEX = "primaryKeyIndex";
    public static final String PROPERTY_FOREIGNKEY_INDEX = "foreignKeyIndex";
    public static final String PROPERTY_GEOMETRY_INDEX = "geometryIndex";
    private DataFrame<R, C, ?> dataFrame;
    private TableModel lookupTableModel;
    private int primaryKeyIndex = -1;
    private C foreignKeyIndex = null;
    private int geometryIndex = -1;

    public CountryGeoReferencingService(DataFrame<R, C, ?> dataFrame) {
        this.dataFrame = dataFrame;
        try {
            InputStream stream = CountryGeoReferencingService.class.getResourceAsStream("ne_50m_admin_0_countries.ser.gz");
            if (stream != null) {
                this.lookupTableModel = TableHelper.read((InputStream)stream);
            } else {
                this.lookupTableModel = DataSourceFactory.getDataSource((File)new File("/Users/luc/macrofocus/dataset/high-d/ne_50m_admin_0_countries/ne_50m_admin_0_countries.shp")).load(null);
                this.lookupTableModel = new SimpleTableModel(this.lookupTableModel, true);
                System.out.println("Creating cb_2015_us_county_20m.ser.gz with columns");
                for (int c = 0; c < this.lookupTableModel.getColumnCount(); ++c) {
                    System.out.println(this.lookupTableModel.getColumnName(c) + ": " + this.lookupTableModel.getColumnClass(c).getSimpleName());
                }
                TableHelper.write((TableModel)this.lookupTableModel, (File)new File("/Users/luc/java/macrofocus/mcartoplot/port/swing/src/main/resources/com/macrofocus/cartoplot/swing/georeferencing/country/ne_50m_admin_0_countries.ser.gz"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this.lookupTableModel != null) {
            for (int c = 0; c < this.lookupTableModel.getColumnCount(); ++c) {
                if (!Geometry.class.isAssignableFrom(this.lookupTableModel.getColumnClass(c))) continue;
                this.setGeometryIndex(c);
            }
        }
        String[] lookupColumns = new String[]{"iso_a3", "iso_a2", "iso_n3", "un_a3", "wb_a2", "wb_a3", "postal", "sovereignt", "name", "name_long", "sov_a3", "admin", "adm0_a3", "geounit", "gu_a3", "subunit", "su_a3", "formal_en", "name_sort"};
        block6: for (Object c1 : dataFrame.columns()) {
            if (this.getPrimaryKeyIndex() >= 0 && this.getForeignKeyIndex() != null) break;
            for (String columnName : lookupColumns) {
                int c2 = TableHelper.findColumn((TableModel)this.lookupTableModel, (String)columnName);
                if (c2 < 0) {
                    System.err.println("Could not find column " + columnName);
                    continue block6;
                }
                boolean match = true;
                boolean allNull = true;
                int foundCount = 0;
                int notFoundCount = 0;
                for (Object r1 : dataFrame.rows()) {
                    Object o1 = dataFrame.getValueAt(r1, c1);
                    if (o1 == null) continue;
                    allNull = false;
                    boolean found = false;
                    for (int r2 = 0; r2 < this.lookupTableModel.getRowCount(); ++r2) {
                        Object o2 = this.lookupTableModel.getValueAt(r2, c2);
                        if (!o1.equals(o2)) continue;
                        found = true;
                        ++foundCount;
                        break;
                    }
                    match &= found;
                    if (found) continue;
                    ++notFoundCount;
                    break;
                }
                if (allNull || !match) continue;
                this.setForeignKeyIndex(c1);
                this.setPrimaryKeyIndex(c2);
                continue block6;
            }
        }
    }

    public boolean isValid() {
        return this.primaryKeyIndex >= 0 && this.foreignKeyIndex != null && this.geometryIndex >= 0;
    }

    public JComponent getEditor() {
        com.macrofocus.molap.dataframe.swing.VariableComboBox inputComboBox = new com.macrofocus.molap.dataframe.swing.VariableComboBox((ComboBoxModel)new ColumnsComboBoxModel(this.dataFrame, false, true));
        inputComboBox.setSelectedItem(this.getForeignKeyIndex());
        inputComboBox.getModel().addListDataListener(new ListDataListener(){
            final /* synthetic */ JComboBox val$inputComboBox;
            {
                this.val$inputComboBox = jComboBox;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Object column = this.val$inputComboBox.getSelectedItem();
                if (column != null) {
                    CountryGeoReferencingService.this.setForeignKeyIndex(column);
                } else {
                    CountryGeoReferencingService.this.setForeignKeyIndex(null);
                }
            }
        });
        VariableComboBox lookupComboBox = new VariableComboBox((ComboBoxModel)new com.macrofocus.data.table.ColumnsComboBoxModel(this.lookupTableModel, false, true));
        lookupComboBox.setSelectedItem(new Column(this.lookupTableModel, this.getPrimaryKeyIndex()));
        lookupComboBox.getModel().addListDataListener(new ListDataListener(){
            final /* synthetic */ JComboBox val$lookupComboBox;
            {
                this.val$lookupComboBox = jComboBox;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Column column = (Column)this.val$lookupComboBox.getSelectedItem();
                if (column != null) {
                    CountryGeoReferencingService.this.setPrimaryKeyIndex(column.getColumn());
                } else {
                    CountryGeoReferencingService.this.setPrimaryKeyIndex(-1);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add((Component)lookupComboBox);
        panel.add((Component)inputComboBox);
        return panel;
    }

    public boolean isPointGeometry() {
        return false;
    }

    public Geometry getGeometry(R row) {
        if (this.primaryKeyIndex >= 0 && this.foreignKeyIndex != null) {
            Object value = this.dataFrame.getValueAt(row, this.foreignKeyIndex);
            for (int r = 0; r < this.lookupTableModel.getRowCount(); ++r) {
                Object l = this.lookupTableModel.getValueAt(r, this.primaryKeyIndex);
                if (!l.equals(value)) continue;
                return (Geometry)this.lookupTableModel.getValueAt(r, this.geometryIndex);
            }
        }
        return null;
    }

    public int getPrimaryKeyIndex() {
        return this.primaryKeyIndex;
    }

    public void setPrimaryKeyIndex(int primaryKeyIndex) {
        if (this.primaryKeyIndex != primaryKeyIndex) {
            int old = this.primaryKeyIndex;
            this.primaryKeyIndex = primaryKeyIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public C getForeignKeyIndex() {
        return this.foreignKeyIndex;
    }

    public void setForeignKeyIndex(C foreignKeyIndex) {
        if (this.foreignKeyIndex != foreignKeyIndex) {
            C old = this.foreignKeyIndex;
            this.foreignKeyIndex = foreignKeyIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public int getGeometryIndex() {
        return this.geometryIndex;
    }

    public void setGeometryIndex(int geometryIndex) {
        if (this.geometryIndex != geometryIndex) {
            int old = this.geometryIndex;
            this.geometryIndex = geometryIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public String toString() {
        return "Country";
    }
}

