/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.tile;

import com.macrofocus.cartoplot.swing.tile.SwingTileFactory;
import com.macrofocus.cartoplot.tile.AbsractTile;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;

public class SwingTile
extends AbsractTile {
    private Priority priority = Priority.High;
    private SwingTileFactory tileFactory;
    private boolean isLoading = false;
    private boolean loaded = false;
    SoftReference<BufferedImage> image = new SoftReference<Object>(null);

    public SwingTile(int x, int y, int zoom) {
        super(x, y, zoom, null);
    }

    SwingTile(int x, int y, int zoom, String url, Priority priority, SwingTileFactory tileFactory) {
        super(x, y, zoom, url);
        this.priority = priority;
        this.tileFactory = tileFactory;
    }

    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    synchronized void setLoaded(boolean loaded) {
        boolean old = this.isLoaded();
        this.loaded = loaded;
    }

    public BufferedImage getImage() {
        BufferedImage img = this.image.get();
        if (img == null) {
            this.setLoaded(false);
            if (this.tileFactory != null) {
                this.tileFactory.startLoading(this);
            }
        }
        return img;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public static enum Priority {
        High,
        Low;

    }
}

